/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Logging;

import com.rookout.rook.Augs.Locations.LocationLogHandler;
import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.Namespaces.ContainerNamespace;
import com.rookout.rook.Processor.Namespaces.LiveTailNamespace;
import com.rookout.rook.Services.Instrumentation.LogRecord;
import java.util.ArrayList;
import java.util.HashMap;

public class LoggingService {
    private static LoggingService instance;
    public static HashMap<String, LocationLogHandler> locations;
    private static final HashMap<String, String> ALLOWED_CLASSES_NAMES_TO_DOTTED_CLASSES_NAMES;
    private static final ArrayList<ArrayList<String>> HOOK_CLASSES_FUNCTIONS_PAIRS;
    public static HashMap<String, HookDescriptors> HOOK_CLASSES_TO_METHODS_CALLBACKS;

    public static LoggingService Build() {
        instance = new LoggingService();
        LogRecord.setStackTraceHookFunctionFrame();
        return instance;
    }

    public static LoggingService Instance() {
        if (instance == null) {
            LoggingService.Build();
        }
        return instance;
    }

    public void Close() {
    }

    public synchronized void AddAug(LocationLogHandler location) throws Exception {
        locations.put(location.getAugId(), location);
        location.SetActive();
    }

    public synchronized void RemoveAug(String locationId) {
        locations.remove(locationId);
    }

    public ArrayList<LocationLogHandler> GetLocations() {
        return new ArrayList<LocationLogHandler>(locations.values());
    }

    public synchronized void ClearAugs() {
        for (String locationId : locations.keySet()) {
            this.RemoveAug(locationId);
        }
    }

    public static Boolean ShouldHook(String className) {
        if (null == instance) {
            return false;
        }
        return LoggingService.IsClassToHook(className);
    }

    public static void DispatchLog(long startTime, Object _this, Object level, Object message, int type, String module, Object ... params) throws Exceptions.ToolException {
        ArrayList<LocationLogHandler> locations = LoggingService.Instance().GetLocations();
        if (locations.size() == 0) {
            return;
        }
        ContainerNamespace extracted = new ContainerNamespace();
        LiveTailNamespace logRecord = new LiveTailNamespace(new LogRecord(_this, type, (double)System.currentTimeMillis() / 1000.0, message, level, module, params));
        extracted.WriteAttribute("log_record", logRecord);
        for (LocationLogHandler location : locations) {
            location.Execute(null, extracted, startTime);
        }
    }

    public static ArrayList<String> GetHookClassMethodsCallbacks(String className) {
        if ((className = LoggingService.getDottedAllowedClass(className)) == null) {
            return null;
        }
        HookDescriptors methodsCallbacks = HOOK_CLASSES_TO_METHODS_CALLBACKS.get(className);
        if (methodsCallbacks == null) {
            return null;
        }
        ArrayList<String> methodsNames = new ArrayList<String>();
        for (HookDescriptor methodCallbacks : methodsCallbacks) {
            methodsNames.add(methodCallbacks.nameOfFunction);
        }
        return methodsNames;
    }

    public static FunctionContext GetMethodCallbackInfo(String className, String methodName, String methodDescriptor) {
        if ((className = LoggingService.getDottedAllowedClass(className)) == null) {
            return null;
        }
        HookDescriptors methodsCallbacks = HOOK_CLASSES_TO_METHODS_CALLBACKS.get(className);
        if (methodsCallbacks != null) {
            for (HookDescriptor methodCallbacks : methodsCallbacks) {
                if (!methodCallbacks.nameOfFunction.equals(methodName) || methodDescriptor != null && !methodCallbacks.descOfFunction.equals(methodDescriptor)) continue;
                return methodCallbacks.GetStaticCallbackFunctionContext();
            }
        }
        return null;
    }

    public static boolean IsHookedFunction(String className, String methodName) {
        for (ArrayList<String> hookClassFunctionPair : HOOK_CLASSES_FUNCTIONS_PAIRS) {
            if (!hookClassFunctionPair.get(1).equals(methodName)) continue;
            return LoggingService.IsClassToHook(className);
        }
        return false;
    }

    private static boolean IsClassToHook(String className) {
        return LoggingService.getDottedAllowedClass(className) != null;
    }

    private static String getDottedAllowedClass(String className) {
        for (String allowedClassName : ALLOWED_CLASSES_NAMES_TO_DOTTED_CLASSES_NAMES.keySet()) {
            if (!LoggingService.IsClassNameAllowed(className, allowedClassName)) continue;
            return ALLOWED_CLASSES_NAMES_TO_DOTTED_CLASSES_NAMES.get(allowedClassName);
        }
        return null;
    }

    private static boolean IsClassNameAllowed(String className, String allowedClass) {
        if (className.length() < allowedClass.length()) {
            return false;
        }
        return className.endsWith(allowedClass);
    }

    static {
        locations = new HashMap();
        ALLOWED_CLASSES_NAMES_TO_DOTTED_CLASSES_NAMES = new HashMap<String, String>(){
            {
                this.put("\\logging\\log4j\\spi\\AbstractLogger", ".log4j.spi.AbstractLogger");
                this.put("/logging/log4j/spi/AbstractLogger", ".log4j.spi.AbstractLogger");
                this.put(".logging.log4j.spi.AbstractLogger", ".log4j.spi.AbstractLogger");
                this.put("\\log4j\\Category", ".log4j.Category");
                this.put("/log4j/Category", ".log4j.Category");
                this.put(".log4j.Category", ".log4j.Category");
                this.put("\\logback\\classic\\Logger", ".logback.classic.Logger");
                this.put("/logback/classic/Logger", ".logback.classic.Logger");
                this.put(".logback.classic.Logger", ".logback.classic.Logger");
            }
        };
        HOOK_CLASSES_FUNCTIONS_PAIRS = new ArrayList<ArrayList<String>>(){
            {
                this.add(new ArrayList<String>(){
                    {
                        this.add(".log4j.spi.AbstractLogger");
                        this.add("logIfEnabled");
                    }
                });
                this.add(new ArrayList<String>(){
                    {
                        this.add(".log4j.Category");
                        this.add("debug");
                    }
                });
                this.add(new ArrayList<String>(){
                    {
                        this.add(".log4j.Category");
                        this.add("info");
                    }
                });
                this.add(new ArrayList<String>(){
                    {
                        this.add(".log4j.Category");
                        this.add("warn");
                    }
                });
                this.add(new ArrayList<String>(){
                    {
                        this.add(".log4j.Category");
                        this.add("error");
                    }
                });
                this.add(new ArrayList<String>(){
                    {
                        this.add(".log4j.Category");
                        this.add("fatal");
                    }
                });
                this.add(new ArrayList<String>(){
                    {
                        this.add(".logback.classic.Logger");
                        this.add("filterAndLog_1");
                    }
                });
                this.add(new ArrayList<String>(){
                    {
                        this.add(".logback.classic.Logger");
                        this.add("filterAndLog_2");
                    }
                });
                this.add(new ArrayList<String>(){
                    {
                        this.add(".logback.classic.Logger");
                        this.add("filterAndLog_0_Or3Plus");
                    }
                });
            }
        };
        HOOK_CLASSES_TO_METHODS_CALLBACKS = new HashMap<String, HookDescriptors>(){
            {
                this.put(".log4j.spi.AbstractLogger", new HookDescriptors(){
                    {
                        this.add(new HookDescriptor("logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/String;Ljava/lang/Throwable;)V", "Log4JLogIfEnabledCallback", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Throwable;)V"));
                        this.add(new HookDescriptor("logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/String;Ljava/lang/Object;)V", "Log4JLogIfEnabledWith1ParamsCallback", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)V"));
                        this.add(new HookDescriptor("logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V", "Log4JLogIfEnabledWith2ParamsCallback", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V"));
                        this.add(new HookDescriptor("logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "Log4JLogIfEnabledWith3ParamsCallback", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V"));
                        this.add(new HookDescriptor("logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "Log4JLogIfEnabledWith4ParamsCallback", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V"));
                        this.add(new HookDescriptor("logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "Log4JLogIfEnabledWith5ParamsCallback", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V"));
                        this.add(new HookDescriptor("logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "Log4JLogIfEnabledWith6ParamsCallback", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V"));
                        this.add(new HookDescriptor("logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "Log4JLogIfEnabledWith7ParamsCallback", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V"));
                        this.add(new HookDescriptor("logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "Log4JLogIfEnabledWith8ParamsCallback", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V"));
                        this.add(new HookDescriptor("logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "Log4JLogIfEnabledWith9ParamsCallback", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V"));
                        this.add(new HookDescriptor("logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "Log4JLogIfEnabledWith10ParamsCallback", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V"));
                        this.add(new HookDescriptor("logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/String;[Ljava/lang/Object;)V", "Log4JLogIfEnabledWithParamsArrayCallback", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Object;)V"));
                        this.add(new HookDescriptor("logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/CharSequence;Ljava/lang/Throwable;)V", "Log4JLogIfEnabledCharSequenceCallback", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/CharSequence;Ljava/lang/Throwable;)V"));
                        this.add(new HookDescriptor("logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Lorg/apache/logging/log4j/message/Message;Ljava/lang/Throwable;)V", "Log4JLogIfEnabledMessageTypeCallback", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Throwable;)V"));
                        this.add(new HookDescriptor("logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/Object;Ljava/lang/Throwable;)V", "Log4JLogIfEnabledMessageObjectCallback", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Throwable;)V"));
                        this.add(new HookDescriptor("logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/String;)V", "Log4JLogIfEnabledNoThrowableCallback", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;)V"));
                        this.add(new HookDescriptor("logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/String;[Lorg/apache/logging/log4j/util/Supplier;)V", "Log4JLogIfEnabledSuppliersArrayAsParamsCallback", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Object;)V"));
                        this.add(new HookDescriptor("logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Lorg/apache/logging/log4j/util/Supplier;Ljava/lang/Throwable;)V", "Log4JLogIfEnabledSupplierAsMessageThrowableCallback", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Throwable;)V"));
                        this.add(new HookDescriptor("logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Lorg/apache/logging/log4j/util/MessageSupplier;Ljava/lang/Throwable;)V", "Log4JLogIfEnabledMessageSupplierThrowableCallback", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Throwable;)V"));
                    }
                });
                this.put(".log4j.Category", new HookDescriptors(){
                    {
                        this.add(new HookDescriptor("debug", "(Ljava/lang/Object;)V", "Log4JCategoryDebug", "(Ljava/lang/Object;Ljava/lang/Object;)V"));
                        this.add(new HookDescriptor("debug", "(Ljava/lang/Object;Ljava/lang/Throwable;)V", "Log4JCategoryDebugThrowable", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Throwable;)V"));
                        this.add(new HookDescriptor("info", "(Ljava/lang/Object;)V", "Log4JCategoryInfo", "(Ljava/lang/Object;Ljava/lang/Object;)V"));
                        this.add(new HookDescriptor("info", "(Ljava/lang/Object;Ljava/lang/Throwable;)V", "Log4JCategoryInfoThrowable", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Throwable;)V"));
                        this.add(new HookDescriptor("warn", "(Ljava/lang/Object;)V", "Log4JCategoryWarning", "(Ljava/lang/Object;Ljava/lang/Object;)V"));
                        this.add(new HookDescriptor("warn", "(Ljava/lang/Object;Ljava/lang/Throwable;)V", "Log4JCategoryWarningThrowable", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Throwable;)V"));
                        this.add(new HookDescriptor("error", "(Ljava/lang/Object;)V", "Log4JCategoryError", "(Ljava/lang/Object;Ljava/lang/Object;)V"));
                        this.add(new HookDescriptor("error", "(Ljava/lang/Object;Ljava/lang/Throwable;)V", "Log4JCategoryErrorThrowable", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Throwable;)V"));
                        this.add(new HookDescriptor("fatal", "(Ljava/lang/Object;)V", "Log4JCategoryFatal", "(Ljava/lang/Object;Ljava/lang/Object;)V"));
                        this.add(new HookDescriptor("fatal", "(Ljava/lang/Object;Ljava/lang/Throwable;)V", "Log4JCategoryFatalThrowable", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Throwable;)V"));
                    }
                });
                this.put(".logback.classic.Logger", new HookDescriptors(){
                    {
                        this.add(new HookDescriptor("filterAndLog_1", "(Ljava/lang/String;Lorg/slf4j/Marker;Lch/qos/logback/classic/Level;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Throwable;)V", "LogBackFilterAndLog_1Callback", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Throwable;)V"));
                        this.add(new HookDescriptor("filterAndLog_2", "(Ljava/lang/String;Lorg/slf4j/Marker;Lch/qos/logback/classic/Level;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Throwable;)V", "LogBackFilterAndLog_2Callback", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Throwable;)V"));
                        this.add(new HookDescriptor("filterAndLog_0_Or3Plus", "(Ljava/lang/String;Lorg/slf4j/Marker;Lch/qos/logback/classic/Level;Ljava/lang/String;[Ljava/lang/Object;Ljava/lang/Throwable;)V", "LogBackFilterAndLog_0_Or3PlusCallback", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Object;Ljava/lang/Throwable;)V"));
                    }
                });
            }
        };
    }

    static class HookDescriptors
    extends ArrayList<HookDescriptor> {
        HookDescriptors() {
        }
    }

    public static class HookDescriptor {
        public String nameOfFunction;
        public String descOfFunction;
        public String staticCallbackName;
        public String descOfStaticCallback;

        public HookDescriptor(String nameOfFunction, String descOfFunction, String staticCallbackName, String descOfStaticCallback) {
            this.nameOfFunction = nameOfFunction;
            this.descOfFunction = descOfFunction;
            this.staticCallbackName = staticCallbackName;
            this.descOfStaticCallback = descOfStaticCallback;
        }

        public FunctionContext GetStaticCallbackFunctionContext() {
            return new FunctionContext(this.staticCallbackName, this.descOfStaticCallback);
        }
    }

    public static class FunctionContext {
        public String functionName;
        public String functionDescriptor;

        public FunctionContext(String functionName, String functionDescriptor) {
            this.functionName = functionName;
            this.functionDescriptor = functionDescriptor;
        }
    }

    private static class LoggingClassNameNotFound
    extends Exception {
        private LoggingClassNameNotFound() {
        }
    }
}

