/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.StackTrace;

import com.rookout.rook.Exceptions;
import com.rookout.rook.RookLogger;
import com.rookout.rook.Services.StackTrace.StackTraceProvider;

public class StackTrace {
    private int baseFrame = 0;
    private Throwable throwable;

    public StackTrace(Throwable java8_and_below_throwable) {
        this.throwable = java8_and_below_throwable;
    }

    public StackTraceElement getBaseFrame() {
        int maxDepth = this.baseFrame + 1;
        try {
            StackTraceElement[] elements = StackTraceProvider.getStackTraceElements(this.throwable, this.baseFrame, maxDepth);
            if (elements.length > 0) {
                return elements[0];
            }
        }
        catch (Throwable t) {
            RookLogger.Instance().warn("Could not collect stacktrace: " + t.getMessage(), new Object[0]);
        }
        return new StackTraceElement("Unavailable", "Unavailable", "Unavailable", -1);
    }

    public StackTraceElement[] getTraceback() throws Exceptions.RookFailedToCollectStacktrace {
        try {
            return StackTraceProvider.getStackTraceElements(this.throwable, this.baseFrame);
        }
        catch (Throwable t) {
            throw new Exceptions.RookFailedToCollectStacktrace(t);
        }
    }

    public StackTraceElement[] getTraceback(int maxDepth) throws Exceptions.RookFailedToCollectStacktrace {
        try {
            return StackTraceProvider.getStackTraceElements(this.throwable, this.baseFrame, maxDepth);
        }
        catch (Throwable t) {
            throw new Exceptions.RookFailedToCollectStacktrace(t);
        }
    }

    public StackTraceElement slowGetFrame(int i) throws Exceptions.RookFailedToCollectStacktrace {
        StackTraceElement[] elements;
        int frameIndex = this.baseFrame + i;
        try {
            elements = StackTraceProvider.getStackTraceElements(this.throwable, this.baseFrame, frameIndex + 1);
        }
        catch (Throwable t) {
            throw new Exceptions.RookFailedToCollectStacktrace(t);
        }
        if (elements.length != 0 && i < elements.length) {
            return elements[i];
        }
        return null;
    }

    public void setBaseFrameIndex(int i) {
        this.baseFrame = i;
    }
}

