/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook;

import java.util.concurrent.atomic.AtomicInteger;

public class LogCache {
    private String[] cache;
    private AtomicInteger nextFreeItem;

    public LogCache(int cacheSize) {
        this.cache = new String[cacheSize];
        this.nextFreeItem = new AtomicInteger(0);
    }

    public boolean ShouldSilenceLog(String log) {
        if (this.isFull() || this.contains(log)) {
            return true;
        }
        int lastValue = this.nextFreeItem.getAndIncrement();
        if (lastValue >= this.cache.length) {
            return true;
        }
        this.put(log, lastValue);
        return false;
    }

    boolean contains(String elem) {
        for (int i = 0; i < Math.min(this.cache.length, this.nextFreeItem.get()); ++i) {
            if (this.cache[i] == null || !this.cache[i].equals(elem)) continue;
            return true;
        }
        return false;
    }

    boolean isFull() {
        return this.nextFreeItem.get() >= this.cache.length;
    }

    synchronized void put(String elem, int index) {
        this.cache[index] = elem;
    }
}

