/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Processor;

import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.NamespaceSerializerBase;
import com.rookout.rook.Processor.Namespaces.ContainerNamespace;
import com.rookout.rook.Processor.Namespaces.JavaObjectNamespace;
import com.rookout.rook.Processor.Namespaces.ListNamespace;
import com.rookout.rook.Processor.Namespaces.LogRecordNamespace;
import com.rookout.rook.Processor.Namespaces.Namespace;
import com.rookout.rook.Processor.Namespaces.TracebackNamespace;
import com.rookout.rook.Processor.RookError;
import com.rookout.rook.RookLogger;
import com.rookout.rook.Utils;
import com.rookout.rook.protobuf.Variant2OuterClass;
import com.rookout.rook.protobuf.VariantOuterClass;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import rook.com.google.protobuf.ByteString;

public class NamespaceSerializer2
extends NamespaceSerializerBase {
    protected HashMap<ByteArrayWrapper, Integer> bufferCache = new HashMap();

    public NamespaceSerializer2() {
        super(true);
    }

    public Variant2OuterClass.Variant2.Builder Dump(Namespace namespace) {
        return this.Dump(namespace, true);
    }

    public Variant2OuterClass.Variant2.Builder Dump(Namespace namespace, boolean logErrors) {
        Variant2OuterClass.Variant2.Builder variant = Variant2OuterClass.Variant2.newBuilder();
        this.Dump(namespace, variant, logErrors);
        return variant;
    }

    void Dump(Namespace namespace, Variant2OuterClass.Variant2.Builder variant, boolean logErrors) {
        block7: {
            try {
                if (namespace instanceof ContainerNamespace) {
                    this.DumpContainerNamespace((ContainerNamespace)namespace, variant, logErrors);
                    break block7;
                }
                if (namespace instanceof JavaObjectNamespace) {
                    this.DumpJavaObjectNamespace((JavaObjectNamespace)namespace, variant, logErrors);
                    break block7;
                }
                if (namespace instanceof ListNamespace) {
                    this.DumpListNamespace((ListNamespace)namespace, variant, logErrors);
                    break block7;
                }
                if (namespace instanceof TracebackNamespace) {
                    this.DumpTracebackNamespace((TracebackNamespace)namespace, variant);
                    break block7;
                }
                if (namespace instanceof LogRecordNamespace) {
                    this.DumpLogRecordNamespace((LogRecordNamespace)namespace, variant);
                    break block7;
                }
                throw new RuntimeException("Namespace not supported! " + namespace.getClass().toString());
            }
            catch (Throwable e) {
                String message = "Failed to serialize namespace";
                variant.clear();
                NamespaceSerializer2.SetVariantTypeInPlace(variant, VariantOuterClass.Variant.Type.VARIANT_ERROR);
                if (!logErrors) break block7;
                variant.setErrorValue(new RookError(e, message).dumps2(this));
                RookLogger.Instance().log(Level.SEVERE, message, e, new Object[0]);
            }
        }
    }

    public static void SetVariantTypeInPlace(Variant2OuterClass.Variant2.Builder variant, VariantOuterClass.Variant.Type type) {
        variant.setVariantTypeMaxDepth(type.ordinal() << 1 | variant.getVariantTypeMaxDepth() & 1);
    }

    private void DumpContainerNamespace(ContainerNamespace namespace, Variant2OuterClass.Variant2.Builder variant, boolean logErrors) {
        NamespaceSerializer2.SetVariantTypeInPlace(variant, VariantOuterClass.Variant.Type.VARIANT_NAMESPACE);
        for (Map.Entry<String, Namespace> entry : namespace.namespaces.entrySet()) {
            variant.addAttributeNamesInCache(this.GetStringIndexInCache(entry.getKey()));
            variant.addAttributeValues(this.Dump(entry.getValue(), logErrors).build());
        }
    }

    private void DumpJavaObjectNamespace(JavaObjectNamespace namespace, Variant2OuterClass.Variant2.Builder variant, boolean logErrors) throws Exception {
        this.DumpJavaObject(namespace.obj, variant, 0, namespace.objectDumpConfig, logErrors);
    }

    private void DumpJavaObject(Object object, Variant2OuterClass.Variant2.Builder variant, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig, boolean logErrors) {
        block2: {
            try {
                this.DumpJavaObjectUnsafe(object, variant, currentDepth, objectDumpConfig, logErrors);
            }
            catch (Throwable e) {
                String message = "Failed to serialize Java Object";
                variant.clear();
                NamespaceSerializer2.SetVariantTypeInPlace(variant, VariantOuterClass.Variant.Type.VARIANT_ERROR);
                if (!logErrors) break block2;
                variant.setErrorValue(new RookError(e, message).dumps2(this));
                RookLogger.Instance().log(Level.SEVERE, message, e, new Object[0]);
            }
        }
    }

    private void dumpStringObject(Object object, Variant2OuterClass.Variant2.Builder variant, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig) {
        NamespaceSerializer2.SetVariantTypeInPlace(variant, VariantOuterClass.Variant.Type.VARIANT_STRING);
        String string = (String)object;
        variant.setOriginalSize(string.length());
        if (string.length() > objectDumpConfig.max_string) {
            string = string.substring(0, objectDumpConfig.max_string);
        }
        variant.setBytesIndexInCache(this.GetStringIndexInCache(string));
    }

    private void DumpJavaObjectUnsafe(Object object, Variant2OuterClass.Variant2.Builder variant, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig, boolean logErrors) throws Exception {
        this.DumpBaseObject(object, variant, currentDepth, objectDumpConfig, logErrors);
        NamespaceSerializerBase.isListOfCharsOptions isListOfCharsOption = NamespaceSerializerBase.isListOfCharsOptions.FALSE;
        if (null == object) {
            NamespaceSerializer2.SetVariantTypeInPlace(variant, VariantOuterClass.Variant.Type.VARIANT_NONE);
        } else if (null != java8 && java8.isSupported(object)) {
            java8.DumpJavaObject(object, variant, currentDepth, objectDumpConfig);
        } else if (object instanceof Integer || object instanceof Short || object instanceof Byte || object instanceof Boolean) {
            if (object instanceof Short) {
                object = ((Short)object).intValue();
            } else if (object instanceof Byte) {
                object = ((Byte)object).intValue();
            } else if (object instanceof Boolean) {
                object = (Boolean)object != false ? Integer.valueOf(1) : Integer.valueOf(0);
            }
            NamespaceSerializer2.SetVariantTypeInPlace(variant, VariantOuterClass.Variant.Type.VARIANT_LONG);
            variant.setLongValue(((Integer)object).intValue());
        } else if (object instanceof Long) {
            NamespaceSerializer2.SetVariantTypeInPlace(variant, VariantOuterClass.Variant.Type.VARIANT_LONG);
            variant.setLongValue((Long)object);
        } else if (object instanceof Double || object instanceof Float) {
            NamespaceSerializer2.SetVariantTypeInPlace(variant, VariantOuterClass.Variant.Type.VARIANT_DOUBLE);
            if (object instanceof Double) {
                variant.setDoubleValue((Double)object);
            } else {
                variant.setDoubleValue(new BigDecimal(((Float)object).floatValue()).doubleValue());
            }
        } else if (object instanceof Enum) {
            NamespaceSerializer2.SetVariantTypeInPlace(variant, VariantOuterClass.Variant.Type.VARIANT_ENUM);
            Enum enm = (Enum)object;
            variant.setOriginalSize(this.GetStringIndexInCache(enm.name()));
            variant.setLongValue(enm.ordinal());
        } else if (object instanceof String || object instanceof Character || otherStringsList.contains(object.getClass().toString()) || object instanceof char[] || object instanceof Character[] || (isListOfCharsOption = NamespaceSerializer2.isListOfChars(object)) != NamespaceSerializerBase.isListOfCharsOptions.FALSE) {
            object = isListOfCharsOption != NamespaceSerializerBase.isListOfCharsOptions.CONCURRENTLY_MODIFIED ? NamespaceSerializer2.castStringObject(object) : "Failed to process list, because it is concurrently modified";
            this.dumpStringObject(object, variant, objectDumpConfig);
        } else if (object instanceof Date) {
            NamespaceSerializer2.SetVariantTypeInPlace(variant, VariantOuterClass.Variant.Type.VARIANT_TIME);
            variant.setTimeValue(Utils.dateToTimestamp((Date)object));
        } else if (object instanceof byte[]) {
            NamespaceSerializer2.SetVariantTypeInPlace(variant, VariantOuterClass.Variant.Type.VARIANT_BINARY);
            byte[] binary = (byte[])object;
            int size = Math.min(binary.length, objectDumpConfig.max_string);
            variant.setOriginalSize(binary.length);
            variant.setBytesIndexInCache(this.GetBufferIndexInCache(new ByteArrayWrapper(binary, size)));
        } else if (object.getClass().isArray()) {
            this.DumpArray(object, variant, currentDepth, objectDumpConfig, logErrors);
        } else if (object instanceof Collection) {
            this.DumpCollection((Collection)object, variant, currentDepth, objectDumpConfig, logErrors);
        } else if (object instanceof Map) {
            this.DumpMap((Map)object, variant, currentDepth, objectDumpConfig, logErrors);
        } else if (object instanceof Throwable) {
            this.DumpThrowable((Throwable)object, variant, currentDepth, objectDumpConfig, logErrors);
        } else if (object instanceof ThreadLocal) {
            this.DumpThreadLocal((ThreadLocal)object, variant, currentDepth, objectDumpConfig, logErrors);
        } else {
            String cls = object.getClass().getName();
            if (cls.equals("org.apache.spark.sql.DataFrame") || cls.equals("org.apache.spark.sql.Dataset")) {
                this.DumpSparkDataFrame(object, variant, currentDepth, objectDumpConfig, logErrors);
            } else if (cls.equals("org.apache.spark.sql.Row") || cls.equals("org.apache.spark.sql.catalyst.expressions.GenericRow") || cls.equals("org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema")) {
                this.DumpSparkRow(object, variant, currentDepth, objectDumpConfig, logErrors);
            } else {
                NamespaceSerializer2.SetVariantTypeInPlace(variant, VariantOuterClass.Variant.Type.VARIANT_OBJECT);
            }
        }
    }

    private void DumpBaseObject(Object object, Variant2OuterClass.Variant2.Builder variant, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig, boolean logErrors) throws Exception {
        if (null == object) {
            variant.setOriginalTypeIndexInCache(this.GetStringIndexInCache("null"));
            return;
        }
        Class<?> cls = null;
        try {
            cls = object.getClass();
        }
        catch (Throwable e) {
            RookLogger.Instance().log(Level.WARNING, "Failed to get class", e, new Object[0]);
            return;
        }
        if (object instanceof Enum) {
            variant.setOriginalTypeIndexInCache(this.GetStringIndexInCache(((Enum)object).getDeclaringClass().getSimpleName()));
        } else {
            variant.setOriginalTypeIndexInCache(this.GetStringIndexInCache(cls.getName()));
        }
        if (NamespaceSerializer2.isPrimitive(cls)) {
            return;
        }
        do {
            Field[] fields;
            int weightedChildrenDepth;
            if ((weightedChildrenDepth = currentDepth + ((fields = cls.getDeclaredFields()).length > objectDumpConfig.max_width ? 2 : 1)) >= objectDumpConfig.max_depth) {
                if (fields.length > 0) {
                    variant.setVariantTypeMaxDepth(variant.getVariantTypeMaxDepth() | 1);
                }
                return;
            }
            for (Field field : fields) {
                if (Modifier.isStatic(field.getModifiers()) || primitiveClasses.contains(field.getDeclaringClass()) || field.getName().equals("$outer")) continue;
                Variant2OuterClass.Variant2.Builder value = Variant2OuterClass.Variant2.newBuilder();
                if (NamespaceSerializer2.setAccessible(field, true)) {
                    this.DumpJavaObject(field.get(object), value, weightedChildrenDepth, objectDumpConfig, logErrors);
                } else {
                    NamespaceSerializer2.SetVariantTypeInPlace(value, VariantOuterClass.Variant.Type.VARIANT_NOT_SUPPORTED);
                }
                variant.addAttributeNamesInCache(this.GetStringIndexInCache(field.getName()));
                variant.addAttributeValues(value);
            }
        } while (null != (cls = cls.getSuperclass()));
    }

    private void DumpArray(Object collection, Variant2OuterClass.Variant2.Builder variant, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig, boolean logErrors) {
        NamespaceSerializer2.SetVariantTypeInPlace(variant, VariantOuterClass.Variant.Type.VARIANT_LIST);
        variant.setOriginalSize(Array.getLength(collection));
        if (currentDepth < objectDumpConfig.max_collection_depth) {
            int max_items = Math.min(Array.getLength(collection), objectDumpConfig.max_width);
            for (int i = 0; i < max_items; ++i) {
                Variant2OuterClass.Variant2.Builder item = Variant2OuterClass.Variant2.newBuilder();
                this.DumpJavaObject(Array.get(collection, i), item, currentDepth + 1, objectDumpConfig, logErrors);
                variant.addCollectionValues(item);
            }
        } else {
            variant.setVariantTypeMaxDepth(variant.getVariantTypeMaxDepth() | 1);
        }
    }

    private void DumpCollection(Collection collection, Variant2OuterClass.Variant2.Builder variant, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig, boolean logErrors) {
        if (collection instanceof Set) {
            NamespaceSerializer2.SetVariantTypeInPlace(variant, VariantOuterClass.Variant.Type.VARIANT_SET);
        } else {
            NamespaceSerializer2.SetVariantTypeInPlace(variant, VariantOuterClass.Variant.Type.VARIANT_LIST);
        }
        variant.setOriginalSize(collection.size());
        if (currentDepth < objectDumpConfig.max_collection_depth) {
            Iterator it = collection.iterator();
            for (int index = 0; index < objectDumpConfig.max_width && it.hasNext(); ++index) {
                Variant2OuterClass.Variant2.Builder item = Variant2OuterClass.Variant2.newBuilder();
                this.DumpJavaObject(it.next(), item, currentDepth + 1, objectDumpConfig, logErrors);
                variant.addCollectionValues(item);
            }
        }
    }

    private void DumpMap(Map collection, Variant2OuterClass.Variant2.Builder variant, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig, boolean logErrors) throws Exception {
        NamespaceSerializer2.SetVariantTypeInPlace(variant, VariantOuterClass.Variant.Type.VARIANT_MAP);
        variant.setOriginalSize(collection.size());
        if (currentDepth < objectDumpConfig.max_collection_depth) {
            Iterator it = collection.entrySet().iterator();
            for (int index = 0; index < objectDumpConfig.max_width && it.hasNext(); ++index) {
                Map.Entry entry = it.next();
                Variant2OuterClass.Variant2.Builder first = Variant2OuterClass.Variant2.newBuilder();
                this.DumpJavaObject(entry.getKey(), first, currentDepth + 1, objectDumpConfig, logErrors);
                Variant2OuterClass.Variant2.Builder second = Variant2OuterClass.Variant2.newBuilder();
                this.DumpJavaObject(entry.getValue(), second, currentDepth + 1, objectDumpConfig, logErrors);
                variant.addCollectionKeys(first);
                variant.addCollectionValues(second);
            }
        }
    }

    private void DumpThrowable(Throwable exception, Variant2OuterClass.Variant2.Builder variant, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig, boolean logErrors) throws Exception {
        NamespaceSerializer2.SetVariantTypeInPlace(variant, VariantOuterClass.Variant.Type.VARIANT_OBJECT);
        Variant2OuterClass.Variant2.Builder messageValue = Variant2OuterClass.Variant2.newBuilder();
        this.DumpJavaObject(exception.getMessage(), messageValue, currentDepth + 1, objectDumpConfig, logErrors);
        variant.addAttributeNamesInCache(this.GetStringIndexInCache("detailMessage"));
        variant.addAttributeValues(messageValue);
        Variant2OuterClass.Variant2.Builder causeValue = Variant2OuterClass.Variant2.newBuilder();
        Throwable cause = exception.getCause();
        if (cause != exception) {
            this.DumpJavaObject(cause, causeValue, currentDepth + 1, objectDumpConfig, logErrors);
        } else {
            this.DumpJavaObject(null, causeValue, currentDepth + 1, objectDumpConfig, logErrors);
        }
        variant.addAttributeNamesInCache(this.GetStringIndexInCache("cause"));
        variant.addAttributeValues(causeValue);
        Variant2OuterClass.Variant2.Builder tracebackValue = Variant2OuterClass.Variant2.newBuilder();
        this.DumpJavaObject(exception.getStackTrace(), tracebackValue, currentDepth + 1, objectDumpConfig, logErrors);
        variant.addAttributeNamesInCache(this.GetStringIndexInCache("stackTrace"));
        variant.addAttributeValues(tracebackValue);
    }

    private void DumpListNamespace(ListNamespace namespace, Variant2OuterClass.Variant2.Builder variant, boolean logErrors) {
        NamespaceSerializer2.SetVariantTypeInPlace(variant, VariantOuterClass.Variant.Type.VARIANT_LIST);
        variant.setOriginalTypeIndexInCache(this.GetStringIndexInCache(namespace.originalType));
        variant.setOriginalSize(namespace.originalSize);
        Iterator<Namespace> it = namespace.list.iterator();
        while (it.hasNext()) {
            variant.addCollectionValues(this.Dump(it.next(), logErrors).build());
        }
    }

    private void DumpTracebackNamespace(TracebackNamespace namespace, Variant2OuterClass.Variant2.Builder variant) throws Exceptions.ToolException {
        namespace.dump(variant, new TracebackNamespace.Callable(){

            @Override
            public int call(String str) {
                return NamespaceSerializer2.this.GetStringIndexInCache(str);
            }
        });
    }

    private void DumpLogRecordNamespace(LogRecordNamespace namespace, Variant2OuterClass.Variant2.Builder variant) throws Exceptions.ToolException {
        namespace.dumpToVariant(variant);
    }

    private void DumpThreadLocal(ThreadLocal threadLocal, Variant2OuterClass.Variant2.Builder variant, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig, boolean logErrors) throws Exception {
        Object value = threadLocal.get();
        this.DumpJavaObjectUnsafe(value, variant, currentDepth, objectDumpConfig, logErrors);
    }

    private void DumpSparkDataFrame(Object dataFrame, Variant2OuterClass.Variant2.Builder variant, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig, boolean logErrors) throws Exception {
        Class<?> dataFrameClass = dataFrame.getClass();
        NamespaceSerializer2.SetVariantTypeInPlace(variant, VariantOuterClass.Variant.Type.VARIANT_LIST);
        Method count = dataFrameClass.getMethod("count", new Class[0]);
        variant.setOriginalSize(((Long)count.invoke(dataFrame, new Object[0])).intValue());
        if (currentDepth < objectDumpConfig.max_collection_depth) {
            Method head = dataFrameClass.getMethod("head", Integer.TYPE);
            Object[] rows = (Object[])head.invoke(dataFrame, objectDumpConfig.max_width);
            for (int i = 0; i < rows.length; ++i) {
                Variant2OuterClass.Variant2.Builder item = Variant2OuterClass.Variant2.newBuilder();
                this.DumpJavaObject(rows[i], item, currentDepth + 1, objectDumpConfig, logErrors);
                variant.addCollectionValues(item);
            }
        }
    }

    private void DumpSparkRow(Object row, Variant2OuterClass.Variant2.Builder variant, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig, boolean logErrors) throws Exception {
        NamespaceSerializer2.SetVariantTypeInPlace(variant, VariantOuterClass.Variant.Type.VARIANT_OBJECT);
        Class<?> rowClass = row.getClass();
        Method apply = rowClass.getMethod("apply", Integer.TYPE);
        Object structType = rowClass.getMethod("schema", new Class[0]).invoke(row, new Object[0]);
        String[] names = (String[])structType.getClass().getMethod("fieldNames", new Class[0]).invoke(structType, new Object[0]);
        int weightedChildrenDepth = currentDepth + (names.length > objectDumpConfig.max_width ? 2 : 1);
        if (weightedChildrenDepth >= objectDumpConfig.max_depth) {
            if (names.length > 0) {
                variant.setVariantTypeMaxDepth(variant.getVariantTypeMaxDepth() | 1);
            }
            return;
        }
        for (int i = 0; i < names.length; ++i) {
            Variant2OuterClass.Variant2.Builder value = Variant2OuterClass.Variant2.newBuilder();
            this.DumpJavaObject(apply.invoke(row, i), value, weightedChildrenDepth, objectDumpConfig, logErrors);
            variant.addAttributeNamesInCache(this.GetStringIndexInCache(names[i]));
            variant.addAttributeValues(value);
        }
    }

    private int GetBufferIndexInCache(ByteArrayWrapper byteArrayWrapper) {
        if (this.bufferCache.containsKey(byteArrayWrapper)) {
            return this.bufferCache.get(byteArrayWrapper);
        }
        int currentSize = this.bufferCache.size();
        this.bufferCache.put(byteArrayWrapper, currentSize);
        return currentSize;
    }

    public BufferCacheHolder getBufferCache() {
        ArrayList<Integer> bufferIndexes = new ArrayList<Integer>();
        ArrayList<ByteString> buffers = new ArrayList<ByteString>();
        for (ByteArrayWrapper byteArrayWrapper : this.bufferCache.keySet()) {
            bufferIndexes.add(this.bufferCache.get(byteArrayWrapper));
            buffers.add(ByteString.copyFrom(byteArrayWrapper.data, 0, byteArrayWrapper.finalBufferSize));
        }
        return new BufferCacheHolder(bufferIndexes, buffers);
    }

    public final class ByteArrayWrapper {
        private final byte[] data;
        private int hashCode;
        private int finalBufferSize;

        public ByteArrayWrapper(byte[] data, int finalBufferSize) {
            this.data = data;
            this.hashCode = this.getHashCode(data, finalBufferSize);
            this.finalBufferSize = finalBufferSize;
        }

        public boolean equals(Object other) {
            if (!(other instanceof ByteArrayWrapper)) {
                return false;
            }
            return Arrays.equals(this.data, ((ByteArrayWrapper)other).data);
        }

        public int hashCode() {
            return this.hashCode;
        }

        private int getHashCode(byte[] a, int size) {
            if (a == null) {
                return 0;
            }
            int result = 1;
            size = Math.min(size, a.length);
            for (int i = 0; i < size; ++i) {
                result = 31 * result + a[i];
            }
            return result;
        }
    }

    public class BufferCacheHolder {
        List<Integer> bufferIndexes;
        List<ByteString> buffers;

        public BufferCacheHolder(List<Integer> bufferIndexes, List<ByteString> buffers) {
            this.bufferIndexes = bufferIndexes;
            this.buffers = buffers;
        }

        public List<ByteString> getBuffers() {
            return this.buffers;
        }

        public List<Integer> getBufferIndexes() {
            return this.bufferIndexes;
        }
    }
}

