/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Processor;

import com.rookout.org.apache.commons.lang3.ArrayUtils;
import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.NamespaceSerializerExt;
import com.rookout.rook.Processor.Namespaces.ContainerNamespace;
import com.rookout.rook.Processor.Namespaces.JavaObjectNamespace;
import com.rookout.rook.Processor.Namespaces.ListNamespace;
import com.rookout.rook.Processor.Namespaces.LogRecordNamespace;
import com.rookout.rook.Processor.Namespaces.Namespace;
import com.rookout.rook.Processor.Namespaces.TracebackNamespace;
import com.rookout.rook.Processor.RookError;
import com.rookout.rook.RookLogger;
import com.rookout.rook.Utils;
import com.rookout.rook.protobuf.VariantOuterClass;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import rook.com.google.protobuf.ByteString;

public class NamespaceSerializer {
    private static NamespaceSerializerExt java8 = null;
    private static final String[] otherStrings;
    private static final Set<String> otherStringsList;
    private static final Class[] primitiveClassesList;
    private static final Set<Class> primitiveClasses;
    private static final String[] extensionPrimitiveClassesList;
    private static final Set<String> extensionPrimitiveClasses;
    private HashMap<String, Integer> stringCache;
    private boolean useStringCache;

    private static boolean isPrimitive(Class cls) {
        return primitiveClasses.contains(cls) || null != java8 && java8.isPrimitive(cls) || extensionPrimitiveClasses.contains(cls.getName());
    }

    public NamespaceSerializer() {
        this(false);
    }

    public NamespaceSerializer(boolean useStringCache) {
        this.useStringCache = useStringCache;
        this.stringCache = new HashMap();
        if (useStringCache) {
            this.stringCache.put("", 0);
        }
    }

    public HashMap<String, Integer> getStringCache() {
        return this.stringCache;
    }

    public VariantOuterClass.Variant.Builder Dump(Namespace namespace) {
        return this.Dump(namespace, true);
    }

    public VariantOuterClass.Variant.Builder Dump(Namespace namespace, boolean logErrors) {
        VariantOuterClass.Variant.Builder variant = VariantOuterClass.Variant.newBuilder();
        this.Dump(namespace, variant, logErrors);
        return variant;
    }

    void Dump(Namespace namespace, VariantOuterClass.Variant.Builder variant) {
        this.Dump(namespace, variant, true);
    }

    void Dump(Namespace namespace, VariantOuterClass.Variant.Builder variant, boolean logErrors) {
        block7: {
            try {
                if (namespace instanceof ContainerNamespace) {
                    this.DumpContainerNamespace((ContainerNamespace)namespace, variant, logErrors);
                    break block7;
                }
                if (namespace instanceof JavaObjectNamespace) {
                    this.DumpJavaObjectNamespace((JavaObjectNamespace)namespace, variant, logErrors);
                    break block7;
                }
                if (namespace instanceof ListNamespace) {
                    this.DumpListNamespace((ListNamespace)namespace, variant, logErrors);
                    break block7;
                }
                if (namespace instanceof TracebackNamespace) {
                    this.DumpTracebackNamespace((TracebackNamespace)namespace, variant);
                    break block7;
                }
                if (namespace instanceof LogRecordNamespace) {
                    this.DumpLogRecordNamespace((LogRecordNamespace)namespace, variant);
                    break block7;
                }
                throw new RuntimeException("Namespace not supported! " + namespace.getClass().toString());
            }
            catch (Throwable e) {
                String message = "Failed to serialize namespace";
                variant.clear();
                variant.setVariantType(VariantOuterClass.Variant.Type.VARIANT_ERROR);
                if (!logErrors) break block7;
                variant.setErrorValue(new RookError(e, message).dumps());
                RookLogger.Instance().log(Level.SEVERE, message, e, new Object[0]);
            }
        }
    }

    private void DumpContainerNamespace(ContainerNamespace namespace, VariantOuterClass.Variant.Builder variant, boolean logErrors) {
        variant.setVariantType(VariantOuterClass.Variant.Type.VARIANT_NAMESPACE);
        VariantOuterClass.Variant.Namespace.Builder result = VariantOuterClass.Variant.Namespace.newBuilder();
        for (Map.Entry<String, Namespace> entry : namespace.namespaces.entrySet()) {
            VariantOuterClass.Variant.NamedValue.Builder value = VariantOuterClass.Variant.NamedValue.newBuilder();
            value.setName(entry.getKey());
            value.setValue(this.Dump(entry.getValue(), logErrors));
            result.addAttributes(value);
        }
        variant.setNamespaceValue(result);
    }

    private void DumpJavaObjectNamespace(JavaObjectNamespace namespace, VariantOuterClass.Variant.Builder variant, boolean logErrors) throws Exception {
        this.DumpJavaObject(namespace.obj, variant, 0, namespace.objectDumpConfig, logErrors);
    }

    private void DumpJavaObject(Object object, VariantOuterClass.Variant.Builder variant, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig, boolean logErrors) throws Exception {
        block2: {
            try {
                this.DumpJavaObjectUnsafe(object, variant, currentDepth, objectDumpConfig, logErrors);
            }
            catch (Throwable e) {
                String message = "Failed to serialize Java Object";
                variant.clear();
                variant.setVariantType(VariantOuterClass.Variant.Type.VARIANT_ERROR);
                if (!logErrors) break block2;
                variant.setErrorValue(new RookError(e, message).dumps());
                RookLogger.Instance().log(Level.SEVERE, message, e, new Object[0]);
            }
        }
    }

    private isListOfCharsOptions isListOfChars(Object object) {
        if (!(object instanceof List) || ((List)object).isEmpty()) {
            return isListOfCharsOptions.FALSE;
        }
        try {
            ListIterator itr = ((List)object).listIterator();
            if (itr.next() instanceof Character) {
                return isListOfCharsOptions.TRUE;
            }
        }
        catch (ConcurrentModificationException exc) {
            return isListOfCharsOptions.CONCURRENTLY_MODIFIED;
        }
        catch (Throwable t) {
            return isListOfCharsOptions.FALSE;
        }
        return isListOfCharsOptions.FALSE;
    }

    public Object castStringObject(Object object) {
        if (!(object instanceof String)) {
            if (object instanceof char[]) {
                object = new String((char[])object);
            } else if (object instanceof Character[]) {
                object = new String(ArrayUtils.toPrimitive((Character[])object));
            } else if (object instanceof List) {
                StringBuilder sb = new StringBuilder();
                try {
                    for (Character ch : (List)object) {
                        sb.append(ch);
                    }
                    object = sb.toString();
                }
                catch (Exception e) {
                    object = "Failed to process list";
                }
            } else {
                object = object.toString();
            }
        }
        return object;
    }

    private void dumpStringObject(Object object, VariantOuterClass.Variant.Builder variant, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig) {
        variant.setVariantType(VariantOuterClass.Variant.Type.VARIANT_STRING);
        VariantOuterClass.Variant.String.Builder stringBuilder = VariantOuterClass.Variant.String.newBuilder();
        String string = (String)object;
        stringBuilder.setOriginalSize(string.length());
        if (string.length() > objectDumpConfig.max_string) {
            string = string.substring(0, objectDumpConfig.max_string);
        }
        if (!this.useStringCache) {
            stringBuilder.setValue(string);
        } else {
            stringBuilder.setValueIndexInCache(this.GetStringIndexInCache(string));
        }
        variant.setStringValue(stringBuilder);
    }

    private void DumpJavaObjectUnsafe(Object object, VariantOuterClass.Variant.Builder variant, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig, boolean logErrors) throws Exception {
        this.DumpBaseObject(object, variant, currentDepth, objectDumpConfig, logErrors);
        isListOfCharsOptions isListOfCharsOption = isListOfCharsOptions.FALSE;
        if (null == object) {
            variant.setVariantType(VariantOuterClass.Variant.Type.VARIANT_NONE);
        } else if (null != java8 && java8.isSupported(object)) {
            java8.DumpJavaObject(object, variant, currentDepth, objectDumpConfig);
        } else if (object instanceof Integer || object instanceof Short || object instanceof Byte || object instanceof Boolean) {
            if (object instanceof Short) {
                object = ((Short)object).intValue();
            } else if (object instanceof Byte) {
                object = ((Byte)object).intValue();
            } else if (object instanceof Boolean) {
                object = (Boolean)object != false ? Integer.valueOf(1) : Integer.valueOf(0);
            }
            variant.setVariantType(VariantOuterClass.Variant.Type.VARIANT_INT);
            variant.setIntValue((Integer)object);
        } else if (object instanceof Long) {
            variant.setVariantType(VariantOuterClass.Variant.Type.VARIANT_LONG);
            variant.setLongValue((Long)object);
        } else if (object instanceof Double || object instanceof Float) {
            variant.setVariantType(VariantOuterClass.Variant.Type.VARIANT_DOUBLE);
            if (object instanceof Double) {
                variant.setDoubleValue((Double)object);
            } else {
                variant.setDoubleValue(new BigDecimal(((Float)object).floatValue()).doubleValue());
            }
        } else if (object instanceof Enum) {
            variant.setVariantType(VariantOuterClass.Variant.Type.VARIANT_ENUM);
            Enum enm = (Enum)object;
            variant.setEnumValue(VariantOuterClass.Variant.Enumeration.newBuilder().setTypeName(enm.getDeclaringClass().getSimpleName()).setOrdinalValue(enm.ordinal()).setStringValue(enm.name()));
        } else if (object instanceof String || object instanceof Character || otherStringsList.contains(variant.getOriginalType()) || object instanceof char[] || object instanceof Character[] || (isListOfCharsOption = this.isListOfChars(object)) != isListOfCharsOptions.FALSE) {
            object = isListOfCharsOption != isListOfCharsOptions.CONCURRENTLY_MODIFIED ? this.castStringObject(object) : "Failed to process list, because it is concurrently modified";
            this.dumpStringObject(object, variant, objectDumpConfig);
        } else if (object instanceof Date) {
            variant.setVariantType(VariantOuterClass.Variant.Type.VARIANT_TIME);
            variant.setTimeValue(Utils.dateToTimestamp((Date)object));
        } else if (object instanceof byte[]) {
            variant.setVariantType(VariantOuterClass.Variant.Type.VARIANT_BINARY);
            byte[] binary = (byte[])object;
            int size = Math.min(binary.length, objectDumpConfig.max_string);
            VariantOuterClass.Variant.Binary.Builder binaryBuilder = VariantOuterClass.Variant.Binary.newBuilder();
            binaryBuilder.setOriginalSize(binary.length);
            binaryBuilder.setValue(ByteString.copyFrom(binary, 0, size));
            variant.setBinaryValue(binaryBuilder);
        } else if (object.getClass().isArray()) {
            this.DumpArray(object, variant, currentDepth, objectDumpConfig, logErrors);
        } else if (object instanceof Collection) {
            this.DumpCollection((Collection)object, variant, currentDepth, objectDumpConfig, logErrors);
        } else if (object instanceof Map) {
            this.DumpMap((Map)object, variant, currentDepth, objectDumpConfig, logErrors);
        } else if (object instanceof Throwable) {
            this.DumpThrowable((Throwable)object, variant, currentDepth, objectDumpConfig, logErrors);
        } else if (object instanceof ThreadLocal) {
            this.DumpThreadLocal((ThreadLocal)object, variant, currentDepth, objectDumpConfig, logErrors);
        } else {
            String cls = object.getClass().getName();
            if (cls.equals("org.apache.spark.sql.DataFrame") || cls.equals("org.apache.spark.sql.Dataset")) {
                this.DumpSparkDataFrame(object, variant, currentDepth, objectDumpConfig, logErrors);
            } else if (cls.equals("org.apache.spark.sql.Row") || cls.equals("org.apache.spark.sql.catalyst.expressions.GenericRow") || cls.equals("org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema")) {
                this.DumpSparkRow(object, variant, currentDepth, objectDumpConfig, logErrors);
            } else {
                this.DumpUserClass(object, variant, currentDepth, objectDumpConfig);
            }
        }
    }

    private void DumpMaxDepth(VariantOuterClass.Variant.Builder variant) {
        variant.setVariantType(VariantOuterClass.Variant.Type.VARIANT_MAX_DEPTH);
    }

    private void SetMaxDepthFlag(VariantOuterClass.Variant.Builder variant) {
        variant.setMaxDepth(true);
    }

    private boolean setAccessible(Field field, boolean newState) {
        if (newState != field.isAccessible()) {
            try {
                field.setAccessible(newState);
            }
            catch (Throwable ex) {
                return false;
            }
        }
        return true;
    }

    private void DumpBaseObject(Object object, VariantOuterClass.Variant.Builder variant, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig, boolean logErrors) throws Exception {
        if (null == object) {
            if (!this.useStringCache) {
                variant.setOriginalType("null");
            } else {
                variant.setOriginalTypeIndexInCache(this.GetStringIndexInCache("null"));
            }
            return;
        }
        Class<?> cls = null;
        try {
            cls = object.getClass();
        }
        catch (Throwable e) {
            RookLogger.Instance().log(Level.WARNING, "Failed to get class", e, new Object[0]);
            return;
        }
        if (!this.useStringCache) {
            variant.setOriginalType(cls.toString());
        } else {
            variant.setOriginalTypeIndexInCache(this.GetStringIndexInCache(cls.getName()));
        }
        if (NamespaceSerializer.isPrimitive(cls)) {
            return;
        }
        do {
            Field[] fields;
            int weightedChildrenDepth;
            if ((weightedChildrenDepth = currentDepth + ((fields = cls.getDeclaredFields()).length > objectDumpConfig.max_width ? 2 : 1)) >= objectDumpConfig.max_depth) {
                if (fields.length > 0) {
                    this.SetMaxDepthFlag(variant);
                }
                return;
            }
            for (Field field : fields) {
                if (Modifier.isStatic(field.getModifiers()) || primitiveClasses.contains(field.getDeclaringClass()) || field.getName().equals("$outer")) continue;
                VariantOuterClass.Variant.Builder value = VariantOuterClass.Variant.newBuilder();
                if (this.setAccessible(field, true)) {
                    this.DumpJavaObject(field.get(object), value, weightedChildrenDepth, objectDumpConfig, logErrors);
                } else {
                    value.setVariantType(VariantOuterClass.Variant.Type.VARIANT_NOT_SUPPORTED);
                }
                VariantOuterClass.Variant.NamedValue.Builder attribute = VariantOuterClass.Variant.NamedValue.newBuilder();
                attribute.setName(field.getName());
                attribute.setValue(value);
                variant.addAttributes(attribute);
            }
        } while (null != (cls = cls.getSuperclass()));
    }

    private void DumpArray(Object collection, VariantOuterClass.Variant.Builder variant, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig, boolean logErrors) throws Exception {
        variant.setVariantType(VariantOuterClass.Variant.Type.VARIANT_LIST);
        VariantOuterClass.Variant.List.Builder list = VariantOuterClass.Variant.List.newBuilder();
        list.setType(ListNamespace.GetCommonType(collection));
        list.setOriginalSize(Array.getLength(collection));
        if (currentDepth < objectDumpConfig.max_collection_depth) {
            int max_items = Math.min(Array.getLength(collection), objectDumpConfig.max_width);
            for (int i = 0; i < max_items; ++i) {
                VariantOuterClass.Variant.Builder item = VariantOuterClass.Variant.newBuilder();
                this.DumpJavaObject(Array.get(collection, i), item, currentDepth + 1, objectDumpConfig, logErrors);
                list.addValues(item);
            }
        } else {
            variant.setMaxDepth(true);
        }
        variant.setListValue(list);
    }

    private void DumpCollection(Collection collection, VariantOuterClass.Variant.Builder variant, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig, boolean logErrors) throws Exception {
        variant.setVariantType(VariantOuterClass.Variant.Type.VARIANT_LIST);
        VariantOuterClass.Variant.List.Builder list = VariantOuterClass.Variant.List.newBuilder();
        list.setType(ListNamespace.GetCommonType(collection));
        list.setOriginalSize(collection.size());
        if (currentDepth < objectDumpConfig.max_collection_depth) {
            Iterator it = collection.iterator();
            for (int index = 0; index < objectDumpConfig.max_width && it.hasNext(); ++index) {
                VariantOuterClass.Variant.Builder item = VariantOuterClass.Variant.newBuilder();
                this.DumpJavaObject(it.next(), item, currentDepth + 1, objectDumpConfig, logErrors);
                list.addValues(item);
            }
        }
        variant.setListValue(list);
    }

    private void DumpMap(Map collection, VariantOuterClass.Variant.Builder variant, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig, boolean logErrors) throws Exception {
        variant.setVariantType(VariantOuterClass.Variant.Type.VARIANT_MAP);
        VariantOuterClass.Variant.Map.Builder map = VariantOuterClass.Variant.Map.newBuilder();
        map.setOriginalSize(collection.size());
        if (currentDepth < objectDumpConfig.max_collection_depth) {
            Iterator it = collection.entrySet().iterator();
            for (int index = 0; index < objectDumpConfig.max_width && it.hasNext(); ++index) {
                Map.Entry entry = it.next();
                VariantOuterClass.Variant.Builder first = VariantOuterClass.Variant.newBuilder();
                this.DumpJavaObject(entry.getKey(), first, currentDepth + 1, objectDumpConfig, logErrors);
                VariantOuterClass.Variant.Builder second = VariantOuterClass.Variant.newBuilder();
                this.DumpJavaObject(entry.getValue(), second, currentDepth + 1, objectDumpConfig, logErrors);
                VariantOuterClass.Variant.Pair.Builder pair = VariantOuterClass.Variant.Pair.newBuilder();
                pair.setFirst(first);
                pair.setSecond(second);
                map.addPairs(pair);
            }
        }
        variant.setMapValue(map);
    }

    private void DumpThrowable(Throwable exception, VariantOuterClass.Variant.Builder variant, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig, boolean logErrors) throws Exception {
        variant.setVariantType(VariantOuterClass.Variant.Type.VARIANT_OBJECT);
        VariantOuterClass.Variant.Builder messageValue = VariantOuterClass.Variant.newBuilder();
        this.DumpJavaObject(exception.getMessage(), messageValue, currentDepth + 1, objectDumpConfig, logErrors);
        VariantOuterClass.Variant.NamedValue.Builder messageAttribute = VariantOuterClass.Variant.NamedValue.newBuilder();
        messageAttribute.setName("detailMessage");
        messageAttribute.setValue(messageValue);
        variant.addAttributes(messageAttribute);
        VariantOuterClass.Variant.Builder causeValue = VariantOuterClass.Variant.newBuilder();
        Throwable cause = exception.getCause();
        if (cause != exception) {
            this.DumpJavaObject(cause, causeValue, currentDepth + 1, objectDumpConfig, logErrors);
        } else {
            this.DumpJavaObject(null, causeValue, currentDepth + 1, objectDumpConfig, logErrors);
        }
        VariantOuterClass.Variant.NamedValue.Builder causeAttribute = VariantOuterClass.Variant.NamedValue.newBuilder();
        causeAttribute.setName("cause");
        causeAttribute.setValue(causeValue);
        variant.addAttributes(causeAttribute);
        VariantOuterClass.Variant.Builder tracebackValue = VariantOuterClass.Variant.newBuilder();
        this.DumpJavaObject(exception.getStackTrace(), tracebackValue, currentDepth + 1, objectDumpConfig, logErrors);
        VariantOuterClass.Variant.NamedValue.Builder tracebackAttribute = VariantOuterClass.Variant.NamedValue.newBuilder();
        tracebackAttribute.setName("stackTrace");
        tracebackAttribute.setValue(tracebackValue);
        variant.addAttributes(tracebackAttribute);
    }

    private void DumpUserClass(Object exception, VariantOuterClass.Variant.Builder variant, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig) {
        variant.setVariantType(VariantOuterClass.Variant.Type.VARIANT_OBJECT);
    }

    private void DumpListNamespace(ListNamespace namespace, VariantOuterClass.Variant.Builder variant, boolean logErrors) {
        variant.setVariantType(VariantOuterClass.Variant.Type.VARIANT_LIST);
        variant.setOriginalType(namespace.originalType);
        VariantOuterClass.Variant.List.Builder result = VariantOuterClass.Variant.List.newBuilder();
        result.setType(namespace.commonType);
        result.setOriginalSize(namespace.originalSize);
        Iterator<Namespace> it = namespace.list.iterator();
        while (it.hasNext()) {
            result.addValues(this.Dump(it.next(), logErrors));
        }
        variant.setListValue(result);
    }

    private void DumpTracebackNamespace(TracebackNamespace namespace, VariantOuterClass.Variant.Builder variant) throws Exceptions.ToolException {
        if (!this.useStringCache) {
            namespace.dump(variant, null);
        } else {
            namespace.dump(variant, new TracebackNamespace.Callable(){

                @Override
                public int call(String str) {
                    return NamespaceSerializer.this.GetStringIndexInCache(str);
                }
            });
        }
    }

    private void DumpLogRecordNamespace(LogRecordNamespace namespace, VariantOuterClass.Variant.Builder variant) throws Exceptions.ToolException {
        namespace.dumpToVariant(variant);
    }

    private void DumpThreadLocal(ThreadLocal threadLocal, VariantOuterClass.Variant.Builder variant, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig, boolean logErrors) throws Exception {
        Object value = threadLocal.get();
        this.DumpJavaObjectUnsafe(value, variant, currentDepth, objectDumpConfig, logErrors);
    }

    private void DumpSparkDataFrame(Object dataFrame, VariantOuterClass.Variant.Builder variant, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig, boolean logErrors) throws Exception {
        Class<?> dataFrameClass = dataFrame.getClass();
        variant.setVariantType(VariantOuterClass.Variant.Type.VARIANT_LIST);
        VariantOuterClass.Variant.List.Builder list = VariantOuterClass.Variant.List.newBuilder();
        list.setType("list");
        Method count = dataFrameClass.getMethod("count", new Class[0]);
        list.setOriginalSize(((Long)count.invoke(dataFrame, new Object[0])).intValue());
        if (currentDepth < objectDumpConfig.max_collection_depth) {
            Method head = dataFrameClass.getMethod("head", Integer.TYPE);
            Object[] rows = (Object[])head.invoke(dataFrame, objectDumpConfig.max_width);
            for (int i = 0; i < rows.length; ++i) {
                VariantOuterClass.Variant.Builder item = VariantOuterClass.Variant.newBuilder();
                this.DumpJavaObject(rows[i], item, currentDepth + 1, objectDumpConfig, logErrors);
                list.addValues(item);
            }
        }
        variant.setListValue(list);
    }

    private void DumpSparkRow(Object row, VariantOuterClass.Variant.Builder variant, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig, boolean logErrors) throws Exception {
        variant.setVariantType(VariantOuterClass.Variant.Type.VARIANT_OBJECT);
        Class<?> rowClass = row.getClass();
        Method apply = rowClass.getMethod("apply", Integer.TYPE);
        Object structType = rowClass.getMethod("schema", new Class[0]).invoke(row, new Object[0]);
        String[] names = (String[])structType.getClass().getMethod("fieldNames", new Class[0]).invoke(structType, new Object[0]);
        int weightedChildrenDepth = currentDepth + (names.length > objectDumpConfig.max_width ? 2 : 1);
        if (weightedChildrenDepth >= objectDumpConfig.max_depth) {
            if (names.length > 0) {
                this.SetMaxDepthFlag(variant);
            }
            return;
        }
        for (int i = 0; i < names.length; ++i) {
            VariantOuterClass.Variant.Builder value = VariantOuterClass.Variant.newBuilder();
            this.DumpJavaObject(apply.invoke(row, i), value, weightedChildrenDepth, objectDumpConfig, logErrors);
            VariantOuterClass.Variant.NamedValue.Builder attribute = VariantOuterClass.Variant.NamedValue.newBuilder();
            attribute.setName(names[i]);
            attribute.setValue(value);
            variant.addAttributes(attribute);
        }
    }

    private int GetStringIndexInCache(String str) {
        if (this.stringCache.containsKey(str)) {
            return this.stringCache.get(str);
        }
        int currentSize = this.stringCache.size();
        this.stringCache.put(str, currentSize);
        return currentSize;
    }

    static {
        try {
            Class<?> namespaceSerializerJava8Ext = Class.forName("com.rookout.rook.Processor.NamespaceSerializerJava8Ext");
            java8 = (NamespaceSerializerExt)namespaceSerializerJava8Ext.newInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        otherStrings = new String[]{"class clojure.lang.Keyword", "class clojure.lang.Symbol"};
        otherStringsList = new HashSet<String>(Arrays.asList(otherStrings));
        primitiveClassesList = new Class[]{Integer.class, Long.class, Double.class, Float.class, Character.class, Boolean.class, Byte.class, Short.class, String.class, ArrayList.class, LinkedList.class, CopyOnWriteArrayList.class, Vector.class, HashMap.class, ConcurrentHashMap.class, Hashtable.class, LinkedHashMap.class, TreeMap.class, WeakHashMap.class, Throwable.class, Date.class, Object.class, Enum.class, HashSet.class};
        primitiveClasses = new HashSet<Class>(Arrays.asList(primitiveClassesList));
        extensionPrimitiveClassesList = new String[]{"clojure.lang.PersistentArrayMap", "clojure.lang.PersistentHashMap", "org.apache.spark.sql.DataFrame", "org.apache.spark.sql.Dataset", "org.apache.spark.sql.Row", "org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema", "org.apache.spark.sql.catalyst.expressions.GenericRow"};
        extensionPrimitiveClasses = new HashSet<String>(Arrays.asList(extensionPrimitiveClassesList));
    }

    private static enum isListOfCharsOptions {
        TRUE,
        FALSE,
        CONCURRENTLY_MODIFIED;

    }
}

