/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.ComWs;

import com.rookout.rook.Config;
import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.RookError;
import com.rookout.rook.RookLogger;
import com.rookout.rook.UserWarnings;
import com.rookout.rook.Utils;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class Queue {
    public static AtomicInteger maxMessageSize = new AtomicInteger(Queue.getMaxMessageSize());
    private int maxQueueLength = Queue.getMaxQueueLength();
    private int maxQueueSize = Queue.getMaxQueueSize();
    protected LinkedBlockingQueue<byte[]> pendingMessages = new LinkedBlockingQueue(this.maxQueueLength);
    protected AtomicInteger pendingMessagesSize = new AtomicInteger();
    private boolean shouldLog = true;

    protected Queue() {
    }

    void offer(byte[] message) {
        if (message.length >= maxMessageSize.get()) {
            UserWarnings.SendWarning(new RookError(new Exceptions.RookMessageSizeExceeded(message.length, maxMessageSize.get())));
            RookLogger.Instance().warn("Dropping message, size was %d which is over the message size limit", message.length);
            return;
        }
        if (!this.TryAllocateMemoryInQueue(message.length)) {
            return;
        }
        this.pendingMessages.offer(message);
    }

    byte[] poll(long timeout, TimeUnit unit) {
        if (this.pendingMessages.isEmpty()) {
            this.shouldLog = true;
        }
        byte[] message = null;
        try {
            message = this.pendingMessages.poll(timeout, unit);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (null == message) {
            return null;
        }
        this.pendingMessagesSize.addAndGet(-message.length);
        return message;
    }

    private synchronized boolean TryAllocateMemoryInQueue(int length) {
        if (this.pendingMessages.size() > this.maxQueueLength || this.pendingMessagesSize.get() + length > this.maxQueueSize) {
            if (this.shouldLog) {
                this.shouldLog = false;
                RookLogger.Instance().warn("Max queue limits were reached (%d/%d, %d/%d) - Dumping message", this.pendingMessages.size(), this.maxQueueLength, this.pendingMessagesSize.get() + length, this.maxQueueSize);
            }
            return false;
        }
        this.pendingMessagesSize.addAndGet(length);
        return true;
    }

    private static int getMaxMessageSize() {
        String maxMessageSizeString = Utils.GetConfigurationString("ROOKOUT_MAX_MESSAGE_SIZE");
        if (maxMessageSizeString != null) {
            try {
                int maxMessageSize = Integer.parseInt(maxMessageSizeString);
                if (maxMessageSize > Config.Instance().AgentComConfiguration$MAX_MESSAGE_SIZE.get()) {
                    return maxMessageSize;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return Config.Instance().AgentComConfiguration$MAX_MESSAGE_SIZE.get();
    }

    private static int getMaxQueueLength() {
        return Config.Instance().AgentComConfiguration$MAX_QUEUED_MESSAGES;
    }

    private static int getMaxQueueSize() {
        return Config.Instance().AgentComConfiguration$MAX_QUEUE_SIZE;
    }

    public boolean isFull() {
        return this.pendingMessages.size() >= this.maxQueueLength || this.pendingMessagesSize.get() >= this.maxQueueSize;
    }
}

