/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook;

import com.rookout.rook.Augs.AugFactory;
import com.rookout.rook.Augs.Locations.Location;
import com.rookout.rook.ComWs.OutputWs;
import com.rookout.rook.Processor.RookError;
import com.rookout.rook.RookLogger;
import com.rookout.rook.TriggerServices;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import rook.org.json.JSONObject;

public class AugManager {
    private TriggerServices triggerServices;
    private OutputWs output;
    private AugFactory factory;
    private HashSet<String> augIds = new HashSet();

    public AugManager(TriggerServices triggerServices, OutputWs output) {
        this.triggerServices = triggerServices;
        this.output = output;
        this.factory = new AugFactory(output);
    }

    public void InitializeAugs(HashMap<String, JSONObject> augConfigs) {
        HashSet<String> leftovers = new HashSet<String>(this.augIds);
        for (Map.Entry<String, JSONObject> e : augConfigs.entrySet()) {
            String augId = e.getKey();
            if (leftovers.contains(augId)) {
                leftovers.remove(augId);
                continue;
            }
            this.AddAug(e.getValue());
        }
        for (String augId : leftovers) {
            this.RemoveAug(augId);
        }
    }

    public void AddAug(JSONObject config) {
        Location aug;
        try {
            aug = this.factory.GetAug(config);
        }
        catch (Throwable t) {
            String message = "Failed to parse aug";
            RookLogger.Instance().log(Level.SEVERE, message, t, new Object[0]);
            String augId = null;
            try {
                augId = config.getString("id");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (augId != null) {
                this.output.SendRuleStatus(augId, "Error", new RookError(t, message));
            }
            return;
        }
        if (this.augIds.contains(aug.getAugId())) {
            RookLogger.Instance().debug("Aug already exists - " + aug.getAugId(), new Object[0]);
            return;
        }
        RookLogger.Instance().debug("Adding aug-\t" + aug.getAugId(), new Object[0]);
        aug.AddAug(this.triggerServices);
        this.augIds.add(aug.getAugId());
    }

    public void RemoveAug(String augId) {
        RookLogger.Instance().debug("Removing aug-\t" + augId, new Object[0]);
        this.triggerServices.RemoveAug(augId);
        this.augIds.remove(augId);
    }

    public void ClearAugs() {
        Object[] idsCopy;
        RookLogger.Instance().debug("Clearing all augs", new Object[0]);
        for (Object augId : idsCopy = this.augIds.toArray()) {
            this.RemoveAug((String)augId);
        }
        this.triggerServices.ClearAugs();
    }
}

