/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Instrumentation;

import com.rookout.rook.RookLogger;
import com.rookout.rook.Services.Instrumentation.BaseVisitor;
import com.rookout.rook.Services.Instrumentation.VisitorUtils;
import com.rookout.rook.Services.Logging.LoggingService;
import java.util.ArrayList;
import java.util.logging.Level;
import rook.org.objectweb.asm.MethodVisitor;
import rook.org.objectweb.asm.Type;
import rook.org.objectweb.asm.tree.InsnList;
import rook.org.objectweb.asm.tree.MethodInsnNode;
import rook.org.objectweb.asm.tree.MethodNode;
import rook.org.objectweb.asm.tree.VarInsnNode;

public class LoggingVisitor
extends BaseVisitor {
    private boolean isHooked = false;

    LoggingVisitor(String className, ClassLoader classLoader, BaseVisitor augVisitor) {
        super(589824, classLoader, className, augVisitor);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        final MethodVisitor methodVisitor = super.visitMethod(access, name, descriptor, signature, exceptions);
        ArrayList<String> methodAndCallback = LoggingService.GetHookClassMethodsCallbacks(this.className);
        if (methodAndCallback == null || !methodAndCallback.contains(name)) {
            return methodVisitor;
        }
        return new MethodNode(327680, access, name, descriptor, signature, exceptions){

            @Override
            public void visitEnd() {
                LoggingService.FunctionContext methodCallbackInfo = LoggingService.GetMethodCallbackInfo(LoggingVisitor.this.className, this.name, this.desc);
                if (!LoggingVisitor.this.isHooked) {
                    RookLogger.Instance().debug("LoggingService hooked a class - " + LoggingVisitor.this.className, new Object[0]);
                }
                if (methodCallbackInfo != null) {
                    String callback = methodCallbackInfo.functionName;
                    String callbackDescriptor = methodCallbackInfo.functionDescriptor;
                    InsnList hook = this.BuildHook(callback, callbackDescriptor);
                    this.instructions.insert(hook);
                    LoggingVisitor.this.isHooked = true;
                    LoggingVisitor.this.verify(this);
                }
                super.visitEnd();
                this.accept(methodVisitor);
            }

            private InsnList BuildHook(String callback, String callbackDescriptor) {
                Type[] argumentsTypes;
                InsnList hook = new InsnList();
                if (this.name.equals("<init>") || (this.access & 8) != 0) {
                    RookLogger.Instance().log(Level.SEVERE, "Constructors and Static functions are not supported");
                    throw new BaseVisitor.FunctionNotSupported("Constructors and Static functions are not supported");
                }
                hook.add(new VarInsnNode(25, 0));
                int argumentIndex = 1;
                for (Type argumentType : argumentsTypes = Type.getArgumentTypes(this.desc)) {
                    String descriptor = argumentType.getDescriptor();
                    hook.add(new VarInsnNode(VisitorUtils.GetOpcode(descriptor), argumentIndex));
                    if (descriptor.equals("D") || descriptor.equals("J")) {
                        argumentIndex += 2;
                        continue;
                    }
                    ++argumentIndex;
                }
                hook.add(new MethodInsnNode(184, "com/rookout/agent/StaticCallback", callback, callbackDescriptor, false));
                if (this.maxStack <= argumentIndex) {
                    this.maxStack = argumentIndex + 1;
                }
                return hook;
            }
        };
    }

    @Override
    boolean isHooked() {
        return this.isHooked;
    }
}

