/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook;

import com.rookout.rook.ComWs.OutputWs;
import com.rookout.rook.Config;
import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.Namespaces.ContainerNamespace;
import com.rookout.rook.Processor.Namespaces.JavaObjectNamespace;
import com.rookout.rook.Utils;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class RookLogger {
    private static final int EXCEPTION_MAX_DEPTH = 6;
    private static final int EXCEPTION_MAX_COLLECTION_DEPTH = 4;
    private static final int STACK_DEPTH_OF_CALLER = 2;
    protected static RookLogger logger;
    private static ArrayList<LogHandler> handlers;
    private static OutputWs output;
    private static BufferedWriter fileHandle;
    public static String logPath;
    private static RandomAccessFile fileIndexHandle;
    private static SimpleDateFormat dateFormat;
    private int level;

    public static RookLogger Instance() {
        if (null == logger) {
            logger = RookLogger.buildRookLogger();
        }
        return logger;
    }

    public static void Close() {
        if (fileHandle != null) {
            try {
                fileHandle.close();
                fileIndexHandle.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected RookLogger(Level level) {
        this.level = level.intValue();
        dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS Z");
    }

    public static void RegisterOutput(OutputWs output) {
        RookLogger.output = output;
    }

    public static void RemoveOutput(OutputWs output) {
        RookLogger.output = null;
    }

    private static RookLogger buildRookLogger() {
        Level parsedLevel;
        block7: {
            String level = Config.Instance().LoggingConfiguration$LOG_LEVEL;
            boolean logToStderr = Config.Instance().LoggingConfiguration$LOG_TO_STDERR;
            if (Utils.GetExecutalbePath().contains("worker.org.gradle.process.internal.worker.GradleWorkerMain")) {
                System.out.println("Rook running in test verbosity");
                level = "DEBUG";
                logToStderr = true;
            }
            parsedLevel = RookLogger.getLevel(level);
            handlers = new ArrayList();
            if (logToStderr) {
                handlers.add(new LogHandler(){

                    @Override
                    public void call(LogRecord logRecord) {
                        System.out.println(RookLogger.getFormatedMessage(logRecord));
                    }
                });
                if (!"".equals(Config.Instance().LoggingConfiguration$FILE_NAME)) {
                    try {
                        Path logPath = Paths.get(Config.Instance().LoggingConfiguration$FILE_NAME, new String[0]);
                        if (!logPath.isAbsolute()) {
                            String osName = System.getProperty("os.name").toLowerCase();
                            logPath = osName.contains("mac") ? Paths.get(Utils.getEnv("HOME", "."), Config.Instance().LoggingConfiguration$FILE_NAME) : (osName.contains("win") ? Paths.get(Utils.getEnv("USERPROFILE", "."), Config.Instance().LoggingConfiguration$FILE_NAME) : Paths.get("/var/log", Config.Instance().LoggingConfiguration$FILE_NAME));
                        }
                        if (!Files.exists(logPath.getParent(), new LinkOption[0]) && !logPath.getParent().toFile().mkdirs()) {
                            throw new IOException("Failed to create directory- " + logPath.getParent().toString());
                        }
                        RookLogger.logPath = logPath.toString();
                        fileIndexHandle = new RandomAccessFile(RookLogger.logPath, "rw");
                        fileHandle = new BufferedWriter(new FileWriter(fileIndexHandle.getFD()));
                        handlers.add(new LogHandler(){

                            @Override
                            public synchronized void call(LogRecord logRecord) {
                                try {
                                    if (fileHandle != null) {
                                        String formattedMessage = RookLogger.getFormatedMessage(logRecord);
                                        if (fileIndexHandle.getFilePointer() + (long)formattedMessage.length() >= (long)Config.Instance().LoggingConfiguration$MAX_LOG_SIZE) {
                                            fileIndexHandle.seek(0L);
                                        }
                                        fileHandle.write(formattedMessage);
                                        fileHandle.newLine();
                                        fileHandle.flush();
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        });
                    }
                    catch (Throwable e) {
                        if (!Config.Instance().LoggingConfiguration$DEBUG) break block7;
                        System.err.printf("[Rookout] Failed to open log file: (%s)\n", e);
                    }
                }
            }
        }
        handlers.add(new LogHandler(){

            @Override
            public void call(LogRecord logRecord) {
                if (null == output) {
                    return;
                }
                if (logRecord.getSourceClassName().startsWith("rook.org.glassfish.tyrus")) {
                    return;
                }
                ContainerNamespace arguments = new ContainerNamespace();
                try {
                    Object[] parameters;
                    Throwable e = logRecord.getThrown();
                    if (null != e) {
                        JavaObjectNamespace.ObjectDumpConfig tailoredDumpConfig = JavaObjectNamespace.ObjectDumpConfig.GetDefaultDumpConfig();
                        tailoredDumpConfig.max_depth = 6;
                        tailoredDumpConfig.max_collection_depth = 4;
                        arguments.WriteAttribute("exc", new JavaObjectNamespace(e, tailoredDumpConfig));
                    }
                    if (null != (parameters = logRecord.getParameters()) && parameters.length > 0) {
                        arguments.WriteAttribute("args", new JavaObjectNamespace(parameters));
                    }
                }
                catch (Exceptions.ToolException e) {
                    // empty catch block
                }
                String formattedMessage = logRecord.getMessage();
                output.SendLogMessage(logRecord.getLevel().intValue(), logRecord.getMillis(), logRecord.getSourceClassName(), logRecord.getSourceMethodName(), formattedMessage, formattedMessage, arguments);
            }
        });
        return new RookLogger(parsedLevel);
    }

    private LogRecord createLogEntry(StackTraceElement stackTraceElement, String msg, Level level, Throwable exception, Object ... args) {
        LogRecord logRecord = new LogRecord(level, String.format(msg, args));
        logRecord.setThrown(exception);
        if (stackTraceElement != null) {
            logRecord.setSourceClassName(stackTraceElement.getClassName());
            logRecord.setSourceMethodName(stackTraceElement.getMethodName());
        }
        if (args != null && args.length > 0) {
            logRecord.setParameters(args);
        }
        return logRecord;
    }

    private static String getFormatedMessage(LogRecord logRecord) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.print(dateFormat.format(new Date()));
        pw.print(" ");
        pw.print(logRecord.getMessage());
        if (null != logRecord.getThrown()) {
            logRecord.getThrown().printStackTrace(pw);
        }
        return sw.toString();
    }

    private void publish(Level level, String format, Throwable exc, Object ... args) {
        if (level.intValue() < this.level) {
            return;
        }
        LogRecord logRecord = this.createLogEntry(new Throwable().getStackTrace()[2], format, level, exc, args);
        for (LogHandler c : handlers) {
            c.call(logRecord);
        }
    }

    public void log(Level level, String format, Object ... args) {
        this.publish(level, format, null, args);
    }

    public void log(Level level, String format, Throwable exc, Object ... args) {
        this.publish(level, format, exc, args);
    }

    public void log(Level level, String str) {
        this.publish(level, str, null, new Object[0]);
    }

    public void debug(String format, Object ... args) {
        this.publish(Level.FINE, format, null, args);
    }

    public void info(String format, Object ... args) {
        this.publish(Level.INFO, format, null, args);
    }

    public void warn(String format, Object ... args) {
        this.publish(Level.WARNING, format, null, args);
    }

    public void fatal(String format, Object ... args) {
        this.publish(Level.SEVERE, format, null, args);
    }

    private static Level getLevel(String levelName) {
        switch (levelName) {
            case "CRITICAL": 
            case "ERROR": {
                return Level.SEVERE;
            }
            case "WARN": 
            case "WARNING": {
                return Level.WARNING;
            }
            case "INFO": {
                return Level.INFO;
            }
            case "DEBUG": {
                return Level.FINE;
            }
            case "OFF": {
                return Level.OFF;
            }
        }
        return Level.WARNING;
    }

    public static interface LogHandler {
        public void call(LogRecord var1);
    }
}

