/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook;

import com.rookout.rook.RookOptions;
import com.rookout.rook.Singleton;
import com.rookout.rook.Utils;
import java.lang.instrument.Instrumentation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import rook.org.json.JSONObject;

public class JavaAgent {
    private static RookOptions opts;
    private static List<String> TRUE_VALUES;

    public static void premain(String agentArgs, Instrumentation instrumentation) throws Exception {
        if (JavaAgent.isLoaded()) {
            return;
        }
        System.setProperty("com.rookout.rook.present", "TRUE");
        String disable = Utils.GetConfigurationString("ROOKOUT_DISABLE_AUTOSTART");
        if (disable != null && !disable.equals("0")) {
            return;
        }
        opts = RookOptions.deserialize(System.getProperties());
        JavaAgent.opts.reload_classes = false;
        JavaAgent.getDisableClassTransformOption();
        JavaAgent.InitRook(instrumentation);
        Singleton.start();
    }

    public static void agentmain(String agentArgs, Instrumentation instrumentation) throws Exception {
        if (JavaAgent.isLoaded()) {
            return;
        }
        JavaAgent.loadAgentArgs(agentArgs);
        System.setProperty("com.rookout.rook.present", "TRUE");
        opts = RookOptions.deserialize(System.getProperties());
        if (JavaAgent.opts.reload_classes == null) {
            String v = Utils.GetConfigurationString("ROOKOUT_DISABLE_CLASS_RELOADING");
            JavaAgent.opts.reload_classes = v != null ? Boolean.valueOf(v.equals("1")) : Boolean.valueOf(true);
        }
        JavaAgent.getDisableClassTransformOption();
        JavaAgent.InitRook(instrumentation);
        Singleton.start();
    }

    private static void loadAgentArgs(String agentArgs) {
        if (null == agentArgs) {
            return;
        }
        try {
            JSONObject json = new JSONObject(agentArgs);
            for (String key : json.keySet()) {
                System.setProperty(key, json.getString(key));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static boolean isLoaded() {
        String rookPresent = System.getProperty("com.rookout.rook.present");
        if (rookPresent != null) {
            return rookPresent.equals("TRUE");
        }
        return false;
    }

    private static void getDisableClassTransformOption() {
        if (JavaAgent.opts.disable_class_transform == null) {
            String v = Utils.GetConfigurationString("ROOKOUT_DISABLE_CLASS_TRANSFORM");
            JavaAgent.opts.disable_class_transform = v != null ? Boolean.valueOf(v.equals("1")) : Boolean.valueOf(false);
        }
    }

    private static void InitRook(Instrumentation instrumentation) {
        JavaAgent.loadOptions();
        Singleton.init(opts, instrumentation);
    }

    public static void SetOptions(RookOptions options) {
        opts = options;
    }

    public static void loadOptions() {
        String v;
        if (JavaAgent.opts.debug == null) {
            v = Utils.GetConfigurationString("ROOKOUT_DEBUG");
            JavaAgent.opts.debug = v != null ? Boolean.valueOf(TRUE_VALUES.contains(v)) : Boolean.valueOf(false);
        }
        if (JavaAgent.opts.class_load_verbose == null) {
            v = Utils.GetConfigurationString("ROOKOUT_CLASS_LOAD_VERBOSE");
            JavaAgent.opts.class_load_verbose = v != null ? Boolean.valueOf(TRUE_VALUES.contains(v)) : Boolean.valueOf(false);
        }
        if (JavaAgent.opts.log_to_stderr == null && (v = Utils.GetConfigurationString("ROOKOUT_LOG_TO_STDERR")) != null) {
            JavaAgent.opts.log_to_stderr = TRUE_VALUES.contains(v);
        }
        if (JavaAgent.opts.log_file == null && (v = Utils.GetConfigurationString("ROOKOUT_LOG_FILE")) != null) {
            JavaAgent.opts.log_file = v;
        }
        if (JavaAgent.opts.log_level == null && (v = Utils.GetConfigurationString("ROOKOUT_LOG_LEVEL")) != null) {
            JavaAgent.opts.log_level = v;
        }
        if (JavaAgent.opts.host == null) {
            v = Utils.GetConfigurationString("ROOKOUT_CONTROLLER_HOST");
            if (v != null) {
                JavaAgent.opts.host = v;
            } else {
                v = Utils.GetConfigurationString("ROOKOUT_AGENT_HOST");
                if (v != null) {
                    JavaAgent.opts.host = v;
                }
            }
        }
        if (JavaAgent.opts.port == null) {
            v = Utils.GetConfigurationString("ROOKOUT_CONTROLLER_PORT");
            if (v != null) {
                try {
                    JavaAgent.opts.port = Integer.parseInt(v);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                v = Utils.GetConfigurationString("ROOKOUT_AGENT_PORT");
                if (v != null) {
                    try {
                        JavaAgent.opts.port = Integer.parseInt(v);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        if (JavaAgent.opts.proxy == null && (v = Utils.GetConfigurationString("ROOKOUT_PROXY")) != null) {
            JavaAgent.opts.proxy = v;
        }
        if (JavaAgent.opts.token == null && (v = Utils.GetConfigurationString("ROOKOUT_TOKEN")) != null) {
            JavaAgent.opts.token = v;
        }
        if (JavaAgent.opts.tags == null) {
            JavaAgent.opts.tags = new String[0];
            v = Utils.GetConfigurationString("ROOKOUT_ROOK_TAGS");
            if (v != null) {
                JavaAgent.opts.tags = v.replaceAll("['\"]", "").split(";");
            }
        }
        if (JavaAgent.opts.labels == null) {
            String liveTailEnvVar;
            JavaAgent.opts.labels = new HashMap();
            v = Utils.GetConfigurationString("ROOKOUT_LABELS");
            if (v != null) {
                for (String label : v.replaceAll("['\"]", "").split(",")) {
                    String[] parts = label.split(":");
                    if (parts.length != 2) continue;
                    String key = parts[0].trim();
                    String value = parts[1].trim();
                    if (key.isEmpty()) continue;
                    JavaAgent.opts.labels.put(key, value);
                }
            }
            if ((liveTailEnvVar = Utils.GetConfigurationString("ROOKOUT_LIVE_TAIL")) != null || JavaAgent.opts.live_tail != null) {
                JavaAgent.opts.labels.put("livetail", "on");
            }
        }
        if (JavaAgent.opts.throw_errors == null) {
            JavaAgent.opts.throw_errors = false;
        }
        if (JavaAgent.opts.disableMonitor == null && (v = Utils.GetConfigurationString("ROOKOUT_DISABLE_MONITOR")) != null) {
            JavaAgent.opts.disableMonitor = TRUE_VALUES.contains(v);
        }
    }

    static {
        TRUE_VALUES = Arrays.asList("y", "Y", "yes", "Yes", "YES", "true", "True", "TRUE", "1");
    }
}

