/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Logging;

import com.rookout.rook.Augs.Locations.LocationLogHandler;
import com.rookout.rook.Processor.Namespaces.ContainerNamespace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;

public class LoggingService {
    private static LoggingService instance;
    public static HashMap<String, LocationLogHandler> locations;
    public static HashMap<String, String[][]> HOOK_CLASSES_TO_METHODS_CALLBACKS;

    public static LoggingService Build() {
        instance = new LoggingService();
        return instance;
    }

    public static LoggingService Instance() {
        if (instance == null) {
            LoggingService.Build();
        }
        return instance;
    }

    public void Close() {
    }

    public synchronized void AddAug(LocationLogHandler location) throws Exception {
        locations.put(location.getAugId(), location);
        location.SetActive();
    }

    public synchronized void RemoveAug(String locationId) {
        locations.remove(locationId);
    }

    public ArrayList<LocationLogHandler> GetLocations() {
        return new ArrayList<LocationLogHandler>(locations.values());
    }

    public synchronized void ClearAugs() {
        for (String locationId : locations.keySet()) {
            this.RemoveAug(locationId);
        }
    }

    public static Boolean ShouldHook(String className) {
        if (null == instance) {
            return false;
        }
        className = LoggingService.prepareClassName(className);
        return LoggingService.GetClassesToHook().contains(className);
    }

    public static void DispatchLog(ContainerNamespace extracted, long startTime) {
        ArrayList<LocationLogHandler> locations = LoggingService.Instance().GetLocations();
        if (locations.size() > 0) {
            locations.get(0).Execute(null, extracted, startTime);
        }
    }

    public static Set<String> GetClassesToHook() {
        return HOOK_CLASSES_TO_METHODS_CALLBACKS.keySet();
    }

    public static ArrayList<String> GetHookClassMethodsCallbacks(String className) {
        String[][] methodsCallbacks = HOOK_CLASSES_TO_METHODS_CALLBACKS.get(className = LoggingService.prepareClassName(className));
        if (methodsCallbacks == null) {
            return null;
        }
        ArrayList<String> methodsNames = new ArrayList<String>();
        for (String[] methodCallbacks : methodsCallbacks) {
            methodsNames.add(methodCallbacks[0]);
        }
        return methodsNames;
    }

    public static String[] GetMethodCallbackInfo(String className, String methodName, String methodDescriptor) {
        String[][] methodsCallbacks = HOOK_CLASSES_TO_METHODS_CALLBACKS.get(className = LoggingService.prepareClassName(className));
        if (methodsCallbacks != null) {
            for (String[] methodCallbacks : methodsCallbacks) {
                if (!methodCallbacks[0].equals(methodName) || methodDescriptor != null && !methodCallbacks[1].equals(methodDescriptor)) continue;
                return Arrays.copyOfRange(methodCallbacks, 2, methodCallbacks.length);
            }
        }
        return null;
    }

    public static String GetCallback(String className, String methodName, String methodDescriptor) {
        String[] methodCallbackInfo = LoggingService.GetMethodCallbackInfo(className, methodName, methodDescriptor);
        if (methodCallbackInfo != null) {
            return methodCallbackInfo[1];
        }
        return null;
    }

    private static String prepareClassName(String className) {
        String preparedClassName = className.replace('/', '.');
        preparedClassName = preparedClassName.replace('\\', '.');
        return preparedClassName;
    }

    static {
        locations = new HashMap();
        HOOK_CLASSES_TO_METHODS_CALLBACKS = new HashMap<String, String[][]>(){
            {
                this.put("org.apache.logging.log4j.spi.AbstractLogger", new String[][]{{"logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/String;Ljava/lang/Throwable;)V", "Log4JLogIfEnabledCallback", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Throwable;)V"}, {"logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/String;Ljava/lang/Object;)V", "Log4JLogIfEnabledWith1ParamsCallback", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)V"}, {"logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V", "Log4JLogIfEnabledWith2ParamsCallback", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V"}, {"logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "Log4JLogIfEnabledWith3ParamsCallback", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V"}, {"logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "Log4JLogIfEnabledWith4ParamsCallback", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V"}, {"logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "Log4JLogIfEnabledWith5ParamsCallback", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V"}, {"logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "Log4JLogIfEnabledWith6ParamsCallback", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V"}, {"logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "Log4JLogIfEnabledWith7ParamsCallback", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V"}, {"logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "Log4JLogIfEnabledWith8ParamsCallback", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V"}, {"logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "Log4JLogIfEnabledWith9ParamsCallback", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V"}, {"logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "Log4JLogIfEnabledWith10ParamsCallback", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V"}, {"logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/String;[Ljava/lang/Object;)V", "Log4JLogIfEnabledWithParamsArrayCallback", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Object;)V"}});
            }
        };
    }
}

