/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Processor.Namespaces;

import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.Namespaces.FrameNamespace;
import com.rookout.rook.Processor.Namespaces.JavaObjectNamespace;
import com.rookout.rook.Processor.Namespaces.Namespace;
import com.rookout.rook.Services.StackTrace.StackTrace;
import com.rookout.rook.protobuf.VariantOuterClass;
import java.util.HashMap;

public class TracebackNamespace
extends Namespace {
    private int depth;
    private StackTraceElement[] stackTraceElements = null;
    private StackTrace stackTrace = null;

    public TracebackNamespace(StackTraceElement[] stackTraceElements, int depth) {
        this.depth = depth;
        this.stackTraceElements = stackTraceElements;
    }

    public TracebackNamespace(StackTrace stackTrace, int depth) {
        this.depth = depth;
        this.stackTrace = stackTrace;
    }

    @Override
    public Namespace ReadKey(Object key) {
        return new FrameNamespace(new HashMap<String, Object>(), this.slowGetFrame((Integer)key));
    }

    @Override
    public Namespace CallMethod(String name, String args) throws Exceptions.ToolException {
        switch (name) {
            case "size": {
                return new JavaObjectNamespace(this.depth);
            }
        }
        return super.CallMethod(name, args);
    }

    public void dump(VariantOuterClass.Variant.Builder variant, Callable getStringIndexInCache) throws Exceptions.ToolException {
        variant.setVariantType(VariantOuterClass.Variant.Type.VARIANT_TRACEBACK);
        VariantOuterClass.Variant.Traceback.Builder traceback = VariantOuterClass.Variant.Traceback.newBuilder();
        StackTraceElement[] frames = this.getFrameList(this.depth);
        for (int i = 0; i < frames.length; ++i) {
            StackTraceElement frameElement = frames[i];
            VariantOuterClass.Variant.CodeObject.Builder frame = VariantOuterClass.Variant.CodeObject.newBuilder();
            frame.setLineno(frameElement.getLineNumber() == -1 ? 0 : frameElement.getLineNumber());
            if (getStringIndexInCache == null) {
                frame.setModule(TracebackNamespace.getValueOrDefault(frameElement.getClassName(), "unavailable"));
                frame.setFilename(TracebackNamespace.getValueOrDefault(frameElement.getFileName(), "unavailable"));
                frame.setName(TracebackNamespace.getValueOrDefault(frameElement.getMethodName(), "unavailable"));
            } else {
                frame.setModuleIndexInCache(getStringIndexInCache.call(TracebackNamespace.getValueOrDefault(frameElement.getClassName(), "unavailable")));
                frame.setFilenameIndexInCache(getStringIndexInCache.call(TracebackNamespace.getValueOrDefault(frameElement.getFileName(), "unavailable")));
                frame.setNameIndexInCache(getStringIndexInCache.call(TracebackNamespace.getValueOrDefault(frameElement.getMethodName(), "unavailable")));
            }
            traceback.addLocations(frame);
        }
        variant.setTraceback(traceback);
    }

    private StackTraceElement slowGetFrame(int i) {
        if (this.stackTraceElements != null) {
            return this.stackTraceElements[i];
        }
        return this.stackTrace.slowGetFrame(i);
    }

    private StackTraceElement[] getFrameList(int userMaxDepth) {
        if (this.stackTraceElements != null) {
            return this.stackTraceElements;
        }
        return this.stackTrace.getTraceback(userMaxDepth);
    }

    public static <T> T getValueOrDefault(T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static interface Callable {
        public int call(String var1);
    }
}

