/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Instrumentation;

import com.rookout.rook.Augs.Locations.LocationFileLine;
import com.rookout.rook.Services.Instrumentation.Files;
import java.util.HashMap;
import java.util.HashSet;
import rook.com.google.common.collect.ImmutableSet;
import rook.com.google.common.collect.Sets;

class ActiveLocations {
    HashMap<Files.ClassObject, Locations> activeLocations = new HashMap();

    ActiveLocations() {
    }

    synchronized void AddLocation(LocationFileLine location, Files.ClassObject cls) {
        Locations locations = this.activeLocations.get(cls);
        if (null == locations) {
            locations = new Locations();
            this.activeLocations.put(cls, locations);
        }
        if (!locations.contains(location)) {
            location.SetActive();
            locations.add(location);
        }
    }

    synchronized void RemoveLocation(LocationFileLine location, Files.ClassObject cls) {
        Locations locations = this.activeLocations.get(cls);
        if (null == locations) {
            return;
        }
        if (locations.contains(location)) {
            location.SetRemoved();
            locations.remove(location);
        }
        if (locations.isEmpty()) {
            this.activeLocations.remove(cls);
        }
    }

    synchronized boolean IsActive(LocationFileLine location, Files.ClassObject cls) {
        Locations locations = this.activeLocations.get(cls);
        if (null == locations) {
            return false;
        }
        return locations.contains(location);
    }

    synchronized void SetAllLocations(Locations newLocations, Files.ClassObject cls) {
        Locations oldLocations = this.activeLocations.get(cls);
        if (null == oldLocations) {
            if (newLocations.isEmpty()) {
                return;
            }
            oldLocations = new Locations();
            this.activeLocations.put(cls, oldLocations);
        }
        ImmutableSet<LocationFileLine> additions = Sets.difference(newLocations, oldLocations).immutableCopy();
        ImmutableSet<LocationFileLine> removals = Sets.difference(oldLocations, newLocations).immutableCopy();
        for (LocationFileLine location : additions) {
            this.AddLocation(location, cls);
        }
        for (LocationFileLine location : removals) {
            this.RemoveLocation(location, cls);
        }
    }

    static class Locations
    extends HashSet<LocationFileLine> {
        Locations() {
        }
    }
}

