/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook;

import com.rookout.rook.RookLogger;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import rook.com.google.protobuf.Timestamp;
import rook.com.google.protobuf.util.Timestamps;

public class Utils {
    static final Pattern COMMAND_LINE_PARSER = Pattern.compile("\"(?:\\\\\"|[^\\\\(?=\")])*\"|[^ \"]+");

    public static String GetExecutalbePath() {
        ArrayList<String> commandLine = Utils.GetCommandLine();
        if (commandLine.size() > 0) {
            return commandLine.get(0);
        }
        return "";
    }

    public static ArrayList<String> GetCommandLine() {
        String commnadLine = System.getProperty("sun.java.command");
        if (null == commnadLine) {
            return new ArrayList<String>();
        }
        return Utils.ParseCommandLine(commnadLine);
    }

    public static ArrayList<String> ParseCommandLine(String commandLine) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = COMMAND_LINE_PARSER.matcher(commandLine);
        while (matcher.find()) {
            String match = matcher.group();
            String argument = match.replaceAll("\"$", "").replaceAll("^\"", "").replace("\\\"", "\"");
            result.add(argument);
        }
        return result;
    }

    public static byte[] getEntryBytes(JarFile file, ZipEntry entry) throws IOException {
        byte[] a_by = null;
        try (DataInputStream dis = new DataInputStream(file.getInputStream(entry));){
            long lSize = entry.getSize();
            a_by = new byte[(int)lSize];
            dis.readFully(a_by);
        }
        return a_by;
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuffer result = new StringBuffer();
        for (byte b : bytes) {
            result.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
        }
        return result.toString();
    }

    public static Timestamp dateToTimestamp(Date date) {
        return Timestamps.fromMillis(date.getTime());
    }

    public static Boolean IsColdFusionFile(String filePath) {
        return filePath.endsWith(".cfc") || filePath.endsWith(".cfm");
    }

    public static Boolean IsScalaFile(String filePath) {
        return filePath.endsWith(".scala");
    }

    public static Boolean isGroovyFile(String filePath) {
        return filePath.endsWith(".groovy");
    }

    public static String getEnv(String envString, String defaultValue) {
        String env = System.getenv(envString);
        if (env != null) {
            return env;
        }
        return defaultValue;
    }

    public static String GetConfigurationString(String env) {
        String v = System.getenv(env);
        if (v == null) {
            v = System.getProperty(env);
        }
        return v;
    }

    public static void GetAllFileInDirectory(List<String> fileNames, Path dir) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            for (Path path : stream) {
                if (path.toFile().isDirectory()) {
                    Utils.GetAllFileInDirectory(fileNames, path);
                    continue;
                }
                fileNames.add(path.toString());
            }
        }
        catch (Exception e) {
            RookLogger.Instance().log(Level.SEVERE, "Failed to iterate file system: " + e.toString(), e, new Object[0]);
        }
    }

    public static long MSToNS(long milliseconds) {
        return milliseconds * 1000000L;
    }

    public static long DoubleMSToNS(double milliseconds) {
        return (long)(milliseconds * 1000000.0);
    }

    public static double getTimeInMillisDouble() {
        return System.nanoTime() / 1000000L;
    }
}

