/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.ComWs;

import com.rookout.rook.ComWs.AgentComWs;
import com.rookout.rook.ComWs.TokenBucket;
import com.rookout.rook.Config;
import com.rookout.rook.Processor.NamespaceSerializer;
import com.rookout.rook.Processor.Namespaces.ContainerNamespace;
import com.rookout.rook.Processor.Namespaces.Namespace;
import com.rookout.rook.Processor.RookError;
import com.rookout.rook.RookLogger;
import com.rookout.rook.Utils;
import com.rookout.rook.protobuf.Messages;
import com.rookout.rook.protobuf.VariantOuterClass;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import rook.com.google.protobuf.Timestamp;

public class OutputWs {
    HashMap<Integer, Messages.LogMessage.LogLevel> logLevels = new HashMap<Integer, Messages.LogMessage.LogLevel>(){
        {
            this.put(Level.ALL.intValue(), Messages.LogMessage.LogLevel.DEBUG);
            this.put(Level.INFO.intValue(), Messages.LogMessage.LogLevel.INFO);
            this.put(Level.WARNING.intValue(), Messages.LogMessage.LogLevel.WARNING);
            this.put(Level.SEVERE.intValue(), Messages.LogMessage.LogLevel.FATAL);
        }
    };
    private String agentId = "";
    private AgentComWs agentCom;
    private String[] tags = new String[0];
    private HashMap<String, String> labels = new HashMap();
    private boolean closing = false;
    TokenBucket ruleStatusUpdatesBucket;
    TokenBucket userMessageBucket;
    TokenBucket logMessageBucket;

    public OutputWs() {
        Config config = Config.Instance();
        this.ruleStatusUpdatesBucket = new TokenBucket(config.OutputWsConfiguration$MAX_STATUS_UPDATES, config.OutputWsConfiguration$BUCKET_REFRESH_RATE, new TokenBucket.Callable(){

            @Override
            public void call() {
                RookLogger.Instance().log(Level.SEVERE, "Limit reached, dropping status updates");
            }
        });
        this.userMessageBucket = new TokenBucket(config.OutputWsConfiguration$MAX_AUG_MESSAGES, config.OutputWsConfiguration$BUCKET_REFRESH_RATE, new TokenBucket.Callable(){

            @Override
            public void call() {
                RookLogger.Instance().log(Level.SEVERE, "Limit reached, dropping aug report messages");
            }
        });
        this.logMessageBucket = new TokenBucket(config.OutputWsConfiguration$MAX_LOG_ITEMS, config.OutputWsConfiguration$BUCKET_REFRESH_RATE, new TokenBucket.Callable(){

            @Override
            public void call() {
                OutputWs.this.internalSendLogMessage(3, System.currentTimeMillis(), "", "", "Limit reached, dropping log messages", "Limit reached, dropping log messages", null);
            }
        });
        RookLogger.RegisterOutput(this);
    }

    public void Close() {
        this.closing = true;
        RookLogger.RemoveOutput(this);
        this.StopSendingMessages();
    }

    public void setAgentCom(AgentComWs agentCom) {
        this.agentCom = agentCom;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public void SendWarning(String ruleId, RookError error) {
        this.SendRuleStatus(ruleId, "Warning", error);
    }

    public void SendRuleStatus(final String ruleId, final String active, final RookError error) {
        if (this.closing) {
            return;
        }
        this.ruleStatusUpdatesBucket.doIfAvailable(new TokenBucket.Callable(){

            @Override
            public void call() {
                Messages.RuleStatusMessage.Builder ruleStatusMessage = Messages.RuleStatusMessage.newBuilder();
                ruleStatusMessage.setAgentId(OutputWs.this.agentId);
                ruleStatusMessage.setRuleId(ruleId);
                ruleStatusMessage.setActive(active);
                if (error != null) {
                    try {
                        ruleStatusMessage.setError(VariantOuterClass.Error.parseFrom(error.dumps().toByteArray()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                OutputWs.this.agentCom.add(ruleStatusMessage.build());
            }
        });
    }

    public void SendUserMessage(final String augId, final String reportId, final Namespace arguments) {
        if (this.closing) {
            return;
        }
        this.userMessageBucket.doIfAvailable(new TokenBucket.Callable(){

            @Override
            public void call() {
                Messages.AugReportMessage.Builder augReportMessage = Messages.AugReportMessage.newBuilder();
                augReportMessage.setAgentId(OutputWs.this.agentId);
                augReportMessage.setAugId(augId);
                augReportMessage.setReportId(reportId);
                if (null != arguments) {
                    NamespaceSerializer serializer = new NamespaceSerializer(Config.Instance().StringCache_UserMessage.get());
                    try {
                        augReportMessage.setArguments(VariantOuterClass.Variant.parseFrom(serializer.Dump(arguments).build().toByteArray()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    augReportMessage.putAllStringsCache(serializer.getStringCache());
                }
                OutputWs.this.agentCom.add(augReportMessage.build());
            }
        });
    }

    public void SendLogMessage(final int level, final long timeInMillis, final String className, final String methodName, final String text, final String formattedMesage, final ContainerNamespace arguments) {
        if (this.closing) {
            return;
        }
        this.logMessageBucket.doIfAvailable(new TokenBucket.Callable(){

            @Override
            public void call() {
                OutputWs.this.internalSendLogMessage(level, timeInMillis, className, methodName, text, formattedMesage, arguments);
            }
        });
    }

    private void internalSendLogMessage(int level, long timeInMillis, String className, String methodName, String text, String formattedMesage, ContainerNamespace arguments) {
        if (this.agentCom == null) {
            return;
        }
        Messages.LogMessage.Builder logMessage = Messages.LogMessage.newBuilder();
        Timestamp.Builder timestamp = Timestamp.newBuilder();
        long seconds = timeInMillis / 1000L;
        long nanos = (timeInMillis - seconds * 1000L) * 1000L;
        timestamp.setSeconds(seconds);
        timestamp.setNanos((int)nanos);
        logMessage.setTimestamp(timestamp);
        logMessage.setAgentId(this.agentId);
        Messages.LogMessage.LogLevel msgLevel = this.logLevels.get(level);
        if (msgLevel == null) {
            msgLevel = Messages.LogMessage.LogLevel.WARNING;
        }
        logMessage.setLevel(msgLevel);
        logMessage.setClassName(className);
        logMessage.setMethodName(methodName);
        logMessage.setText(text);
        logMessage.setFormattedMessage(formattedMesage);
        if (null != arguments) {
            NamespaceSerializer serializer = new NamespaceSerializer();
            try {
                logMessage.setLegacyArguments(VariantOuterClass.Variant.parseFrom(serializer.Dump((Namespace)arguments, false).build().toByteArray()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.agentCom.add(logMessage.build());
    }

    public void FlushMessages() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void StartSendingMessages() {
        OutputWs outputWs = this;
        synchronized (outputWs) {
            this.closing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void StopSendingMessages() {
        OutputWs outputWs = this;
        synchronized (outputWs) {
            this.closing = true;
        }
    }

    public void setTags(String[] tags, HashMap<String, String> labels) {
        if (tags != null) {
            this.tags = tags;
        }
        if (labels != null) {
            this.labels = labels;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getManifestValue(String key, String jar) {
        try (JarFile file = new JarFile(jar);){
            ZipEntry entry = file.getEntry("META-INF/MANIFEST.MF");
            if (entry == null) {
                throw new IOException("Failed to get manifest file");
            }
            Manifest manifest = new Manifest(new ByteArrayInputStream(Utils.getEntryBytes(file, entry)));
            Attributes entries = manifest.getMainAttributes();
            String result = entries.getValue(key);
            if (result != null) {
                String string = result;
                return string;
            }
            throw new IOException("Failed to find manifest tag " + key + " in file " + file.getName());
        }
        catch (IOException e) {
            RookLogger.Instance().log(Level.INFO, "Failed to get jar commit: " + e.getMessage());
            return "";
        }
    }

    static String GetUserSuppliedValue(String name, String executable) {
        String value = Utils.GetConfigurationString(name);
        if (null != value) {
            return value;
        }
        if (executable == null) {
            executable = Utils.GetExecutalbePath();
        }
        if (executable.endsWith(".jar") || executable.endsWith(".war") || executable.endsWith(".ear")) {
            return OutputWs.getManifestValue(name, executable);
        }
        return "";
    }
}

