/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.ComWs;

import com.rookout.rook.ComWs.ConnectException;
import com.rookout.rook.ComWs.EnvelopeWrapper;
import com.rookout.rook.ComWs.IncomingMessageHandler;
import com.rookout.rook.ComWs.Information;
import com.rookout.rook.ComWs.OutputWs;
import com.rookout.rook.ComWs.ProxySocketFactory;
import com.rookout.rook.ComWs.RookoutWebSocketClient;
import com.rookout.rook.Config;
import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.RookError;
import com.rookout.rook.RookLogger;
import com.rookout.rook.UserWarnings;
import com.rookout.rook.Utils;
import com.rookout.rook.protobuf.EnvelopeOuterClass;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import rook.com.google.protobuf.Any;
import rook.com.google.protobuf.Message;

public class AgentComWs
implements IncomingMessageHandler {
    protected String agentId;
    private Double currentBackoff;
    private final OutputWs output;
    private final URI agentUri;
    private URI proxy;
    private final String token;
    private int retries = 0;
    private final HashMap<String, List<MessageCallback>> callbacks;
    private final Config config = Config.Instance();
    private final Information info;
    private final RookLogger logger = RookLogger.Instance();
    boolean stopping;
    private final LinkedBlockingQueue<byte[]> pendingMessages;
    private Thread writeThread;
    private final int maxMessageSize;

    private static URI buildAgentUri(String agentHost, int agentPort) throws URISyntaxException {
        agentHost = agentHost == null || agentHost.contains("://") ? agentHost : "ws://" + agentHost;
        return new URI(String.format("%s:%d/v1", agentHost, agentPort));
    }

    public AgentComWs(OutputWs output, String agentHost, int agentPort, String proxy, String token, Map<String, String> labels, String[] tags, boolean debug) throws URISyntaxException, SSLException, GeneralSecurityException {
        this.output = output;
        this.agentUri = AgentComWs.buildAgentUri(agentHost, agentPort);
        this.resetId();
        this.output.setAgentId(this.agentId);
        this.currentBackoff = this.config.AgentComConfiguration$BACK_OFF;
        this.token = token;
        this.callbacks = new HashMap();
        this.info = Information.Collect(debug);
        this.info.agentId = this.agentId;
        this.info.labels = labels;
        this.info.tags = tags;
        this.pendingMessages = new LinkedBlockingQueue(this.config.AgentComConfiguration$MAX_QUEUED_MESSAGES);
        this.stopping = false;
        this.maxMessageSize = this.getMaxMessageSize();
        if (proxy != null && !proxy.equals("")) {
            try {
                if (!proxy.contains("://")) {
                    proxy = "http://" + proxy;
                }
                this.proxy = new URI(proxy);
            }
            catch (URISyntaxException e) {
                this.logger.fatal("Bad proxy address: " + e.getMessage(), new Object[0]);
            }
        }
    }

    private int getMaxMessageSize() {
        String maxMessageSizeString = Utils.GetConfigurationString("ROOKOUT_MAX_MESSAGE_SIZE");
        if (maxMessageSizeString != null) {
            try {
                int maxMessageSize = Integer.parseInt(maxMessageSizeString);
                if (maxMessageSize > this.config.AgentComConfiguration$MAX_MESSAGE_SIZE) {
                    return maxMessageSize;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.config.AgentComConfiguration$MAX_MESSAGE_SIZE;
    }

    private void addToQueue(EnvelopeOuterClass.Envelope envelope) {
        byte[] serializedMsg = envelope.toByteArray();
        if (serializedMsg.length > this.maxMessageSize) {
            UserWarnings.SendWarning(new RookError(new Exceptions.RookMessageSizeExceeded(serializedMsg.length, this.maxMessageSize)));
            this.logger.warn("Dropping message, size was %d which is over the message size limit", serializedMsg.length);
            return;
        }
        if (!this.pendingMessages.offer(serializedMsg)) {
            // empty if block
        }
    }

    private void add(EnvelopeOuterClass.Envelope envelope) {
        this.addToQueue(envelope);
    }

    public <T extends Message> void add(T message) {
        this.add(EnvelopeWrapper.envelope(message));
    }

    public void on(String messageName, Callable callback) {
        this.registerCallback(messageName, callback, true);
    }

    public void once(String messageName, Callable callback) {
        this.registerCallback(messageName, callback, false);
    }

    private void registerCallback(String messageName, Callable callback, Boolean persistent) {
        MessageCallback messageCallback = new MessageCallback(callback, persistent);
        if (!this.callbacks.containsKey(messageName)) {
            this.callbacks.put(messageName, new ArrayList());
        }
        this.callbacks.get(messageName).add(messageCallback);
    }

    public void ConnectToAgent() throws Exceptions.RookInvalidToken, IOException {
        final AgentComWs self = this;
        final ConnectException connectException = new ConnectException();
        final CountDownLatch connectedLatch = new CountDownLatch(1);
        this.writeThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                try {
                    Date lastSuccessfulConnection = new Date(0L);
                    ProxySocketFactory socketFactory = null;
                    if (AgentComWs.this.proxy != null) {
                        AgentComWs.this.logger.debug("Connecting via proxy: %s", AgentComWs.this.proxy.toString());
                        socketFactory = new ProxySocketFactory(AgentComWs.this.proxy.getHost(), AgentComWs.this.proxy.getPort(), AgentComWs.this.agentUri.getHost(), AgentComWs.this.agentUri.getPort(), AgentComWs.this.agentUri.getScheme().equals("wss"));
                    }
                    RookoutWebSocketClient client = new RookoutWebSocketClient(self.agentUri, self.token, self, self.info, socketFactory);
                    while (!self.stopping) {
                        try {
                            client.doConnectionAttempt();
                            double differenceSeconds = (double)(new Date().getTime() - lastSuccessfulConnection.getTime()) / 1000.0;
                            if (differenceSeconds > ((AgentComWs)AgentComWs.this).config.AgentComConfiguration$RESET_BACKOFF_TIMEOUT) {
                                self.currentBackoff = ((AgentComWs)AgentComWs.this).config.AgentComConfiguration$BACK_OFF;
                                self.retries = 0;
                            }
                            lastSuccessfulConnection = new Date();
                            ConnectException connectException2 = connectException;
                            synchronized (connectException2) {
                                connectException.ioexception = null;
                                connectException.invalidtoken = null;
                            }
                            connectedLatch.countDown();
                            self.sendLoop(client);
                            if (self.stopping) {
                                return;
                            }
                        }
                        catch (IOException e) {
                            connectException.ioexception = e;
                            AgentComWs.this.logger.warn(e.getMessage(), new Object[0]);
                        }
                        catch (Exceptions.RookInvalidToken e) {
                            connectException.invalidtoken = e;
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                        catch (Exception e) {
                            self.logger.warn("Got unexpected exception %s: %s", e.getClass().getName(), e.getMessage());
                            connectException.ioexception = new IOException(e.getMessage());
                        }
                        finally {
                            client.close();
                        }
                        self.retries++;
                        self.currentBackoff = Math.min(self.currentBackoff * 2.0, (double)((AgentComWs)AgentComWs.this).config.AgentCom$MAX_SLEEP.intValue());
                        RookLogger.Instance().info(String.format("Reconnecting, retry = #%d, waiting %.2fs", self.retries, self.currentBackoff), new Object[0]);
                        try {
                            Thread.sleep((long)(self.currentBackoff * 1000.0));
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                }
                catch (IOException | GeneralSecurityException e) {
                    connectException.ioexception = new IOException(e.getMessage());
                }
            }
        });
        this.writeThread.setDaemon(true);
        this.writeThread.start();
        try {
            if (!connectedLatch.await(this.config.AgentCom$CONNECTION_TIMEOUT.intValue(), TimeUnit.SECONDS)) {
                ConnectException connectException2 = connectException;
                synchronized (connectException2) {
                    if (connectException.ioexception != null) {
                        throw connectException.ioexception;
                    }
                    if (connectException.invalidtoken != null) {
                        throw connectException.invalidtoken;
                    }
                    throw new IOException("Failed to connect to the controller. Will keep trying");
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void sendLoop(RookoutWebSocketClient client) throws InterruptedException {
        while (!this.stopping && client.isOpen()) {
            byte[] message = this.pendingMessages.poll(500L, TimeUnit.MILLISECONDS);
            if (message == null) continue;
            client.send(message);
        }
    }

    @Override
    public void handleIncomingMessage(Any message) {
        String[] splittedEnvelopeType = message.getTypeUrl().split("\\.", -1);
        String partialTypeName = splittedEnvelopeType[splittedEnvelopeType.length - 1];
        this.callAllCallbacks(partialTypeName, message);
    }

    private void callAllCallbacks(String messageType, Any message) {
        List<MessageCallback> cb = this.callbacks.get(messageType);
        ArrayList<MessageCallback> remainingCallbacks = new ArrayList<MessageCallback>();
        for (MessageCallback messageCallback : cb) {
            messageCallback.callback.call(message);
            if (!messageCallback.persistent.booleanValue()) continue;
            remainingCallbacks.add(messageCallback);
        }
        this.callbacks.put(messageType, remainingCallbacks);
    }

    public void Close() {
        this.output.FlushMessages();
        this.output.StopSendingMessages();
        this.stopping = true;
        if (this.writeThread != null) {
            this.writeThread.interrupt();
            try {
                this.writeThread.join(2000L, 0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.writeThread.isAlive()) {
                this.writeThread.interrupt();
            }
        }
    }

    private void resetId() {
        this.agentId = UUID.randomUUID().toString().replace("-", "");
    }

    private class MessageCallback {
        Callable callback;
        Boolean persistent;

        MessageCallback(Callable callback, Boolean persistent) {
            this.callback = callback;
            this.persistent = persistent;
        }
    }

    public static interface Callable {
        public void call(Any var1);
    }
}

