/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Processor.Namespaces;

import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.Namespaces.ContainerNamespace;
import com.rookout.rook.Processor.Namespaces.JavaObjectNamespace;
import com.rookout.rook.Processor.Namespaces.ListNamespace;
import com.rookout.rook.Processor.Namespaces.Namespace;
import com.rookout.rook.Processor.Namespaces.StackNamespace;
import java.util.ArrayList;
import java.util.Map;

public class JavaUtilsNamespace
extends Namespace {
    @Override
    public Namespace CallMethod(String name, String args) throws Exceptions.ToolException {
        switch (name) {
            case "exception": 
            case "exception_string": 
            case "exception_type": {
                return new JavaObjectNamespace("Indirect exception access is not supported on Java!");
            }
            case "module": 
            case "class": {
                try {
                    return new JavaObjectNamespace(Class.forName(args));
                }
                catch (ClassNotFoundException e) {
                    throw new Exceptions.RookMethodFailed(name, args, (Throwable)e);
                }
            }
            case "thread_id": {
                return new JavaObjectNamespace(Thread.currentThread().getId());
            }
            case "thread_name": {
                return new JavaObjectNamespace(Thread.currentThread().getName());
            }
            case "threads": {
                return new JavaObjectNamespace(Thread.getAllStackTraces().keySet());
            }
            case "thread_tracebacks": {
                Map<Thread, StackTraceElement[]> threads = Thread.getAllStackTraces();
                ArrayList<Namespace> result = new ArrayList<Namespace>();
                for (Map.Entry<Thread, StackTraceElement[]> threadEntry : threads.entrySet()) {
                    StackTraceElement[] stackTraceElements = threadEntry.getValue();
                    Namespace traceback = new StackNamespace(stackTraceElements).Traceback("");
                    ContainerNamespace container = new ContainerNamespace();
                    container.WriteAttribute("id", new JavaObjectNamespace(threadEntry.getKey().getId()));
                    container.WriteAttribute("name", new JavaObjectNamespace(threadEntry.getKey().getName()));
                    container.WriteAttribute("daemon", new JavaObjectNamespace(threadEntry.getKey().isDaemon()));
                    container.WriteAttribute("traceback", traceback);
                    result.add(container);
                }
                return new ListNamespace(result);
            }
            case "env": {
                return new JavaObjectNamespace(System.getenv(args));
            }
        }
        return super.CallMethod(name, args);
    }
}

