/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Augs.Locations;

import com.rookout.rook.Augs.Aug;
import com.rookout.rook.Augs.Locations.HashInfo;
import com.rookout.rook.Augs.Locations.Location;
import com.rookout.rook.ComWs.OutputWs;
import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.ProcessorFactory;
import com.rookout.rook.Processor.RookError;
import com.rookout.rook.RookLogger;
import com.rookout.rook.TriggerServices;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.logging.Level;
import rook.org.json.JSONObject;

public class LocationFileLine
extends Location {
    public static final String NAME = "file_line";
    private String filename;
    private Integer lineno;
    private HashInfo hashInfo;
    private int activeCount = 0;
    private HashMap<String, Boolean> classMatchCache = new HashMap();

    public LocationFileLine(String arguments, ProcessorFactory processorFactory, OutputWs output, Aug aug) {
        this(new JSONObject(arguments), processorFactory, output, aug);
    }

    public LocationFileLine(JSONObject arguments, ProcessorFactory processorFactory, OutputWs output, Aug aug) {
        super(output, aug);
        if (arguments.has("filename")) {
            this.filename = arguments.getString("filename");
        }
        this.lineno = arguments.getInt("lineno");
        String file_hash = null;
        Long line_crc = null;
        Boolean line_crc_unique = null;
        if (arguments.has("sha256")) {
            file_hash = arguments.getString("sha256");
        }
        if (arguments.has("line_crc32_2")) {
            line_crc = Long.decode("0x" + arguments.getString("line_crc32_2"));
        }
        if (arguments.has("line_unique")) {
            line_crc_unique = arguments.getBoolean("line_unique");
        }
        this.hashInfo = new HashInfo(file_hash, line_crc, line_crc_unique);
    }

    public LocationFileLine(String filename, int lineno, HashInfo hashInfo, OutputWs output, Aug aug) {
        super(output, aug);
        this.filename = filename;
        this.lineno = lineno;
        this.hashInfo = hashInfo;
    }

    @Override
    public void AddAug(TriggerServices triggerServices) {
        try {
            try {
                triggerServices.getInstrumentation().AddAug(this);
            }
            catch (InvalidPathException e) {
                throw new Exceptions.RookInvalidObjectConfiguration("filename", this.filename, (Throwable)e);
            }
        }
        catch (Throwable e) {
            String message = "Exception when adding aug";
            RookLogger.Instance().log(Level.SEVERE, message, e, new Object[0]);
            this.SetError(new RookError(e, message));
        }
    }

    public String getFilename() {
        return Paths.get(this.filename, new String[0]).getFileName().toString();
    }

    public String getFileExtension() {
        String filename = this.getFilename();
        int lastDot = filename.lastIndexOf(46);
        if (-1 == lastDot) {
            return "";
        }
        return filename.substring(lastDot);
    }

    public int getLineno() {
        return this.lineno;
    }

    public HashInfo getHashInfo() {
        return this.hashInfo;
    }

    public Boolean getClassMatchFromCache(URL rawClass) {
        return this.classMatchCache.get(rawClass.toString());
    }

    public void addClassMatchToCache(URL rawClass, Boolean match) {
        this.classMatchCache.put(rawClass.toString(), match);
    }

    public int getNumberOfMatchesInCache() {
        return this.classMatchCache.size();
    }

    @Override
    public void SetActive() {
        if (this.activeCount == 0) {
            super.SetActive();
        }
        ++this.activeCount;
    }

    @Override
    public void SetRemoved() {
        --this.activeCount;
        if (this.activeCount == 0) {
            super.SetRemoved();
        }
    }
}

