/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Instrumentation;

import com.rookout.rook.Augs.Locations.LocationFileLine;
import com.rookout.rook.Config;
import com.rookout.rook.Processor.RookError;
import com.rookout.rook.RookLogger;
import com.rookout.rook.Services.Instrumentation.ActiveLocations;
import com.rookout.rook.Services.Instrumentation.Augs;
import com.rookout.rook.Services.Instrumentation.CallbackDispatcher;
import com.rookout.rook.Services.Instrumentation.ClassReloader;
import com.rookout.rook.Services.Instrumentation.Files;
import com.rookout.rook.Services.Instrumentation.IClassReloader;
import com.rookout.rook.Services.Instrumentation.NoopClassReloader;
import com.rookout.rook.Services.Instrumentation.Visitor;
import com.rookout.rook.UserWarnings;
import java.lang.annotation.Annotation;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import rook.com.google.common.collect.HashBiMap;
import rook.org.objectweb.asm.ClassReader;
import rook.org.objectweb.asm.ClassWriter;

public class InstrumentationService
implements ClassFileTransformer {
    private final String[] excludedContains = new ArrayList<String>(){
        {
            this.add("$Lambda$");
        }
    }.toArray(new String[0]);
    private Augs augs = new Augs();
    private Files files = new Files();
    private ActiveLocations activeLocations = new ActiveLocations();
    public boolean silencedRetransformFailure = false;
    public static InstrumentationService instance;
    private static Instrumentation inst;
    private IClassReloader classReloader = null;
    private static boolean shouldReloadAllClassesOnStart;
    private static boolean disableClassTransform;

    public static void SetInstrumentation(Instrumentation instrumentation, boolean shouldReloadAllClassesOnStartArg, boolean disableClassTransformArg) {
        inst = instrumentation;
        shouldReloadAllClassesOnStart = shouldReloadAllClassesOnStartArg;
        disableClassTransform = disableClassTransformArg;
    }

    public static InstrumentationService Build() {
        if (null == inst) {
            RookLogger.Instance().log(Level.WARNING, "Java agent was not initialized, instrumentation not available");
            return null;
        }
        if (null != instance) {
            throw new RuntimeException("Cannot create multiple instances!");
        }
        instance = new InstrumentationService();
        return instance;
    }

    public void ResetClassReloader() {
        if (null != this.classReloader) {
            this.classReloader.Stop();
            this.classReloader = null;
        }
        this.classReloader = new ClassReloader(inst, this.augs, this.files, this.activeLocations);
    }

    public void Close() {
        if (disableClassTransform) {
            return;
        }
        this.classReloader.Stop();
        this.ClearAugs();
        inst.removeTransformer(this);
        CallbackDispatcher.Close();
        instance = null;
    }

    public void AddAug(LocationFileLine location) throws Exception {
        this.classReloader.AddAug(location);
    }

    public void RemoveAug(String augId) {
        this.classReloader.RemoveAug(augId);
    }

    public void ClearAugs() {
        Set<String> augIds = this.augs.AllAugIds();
        for (String augId : augIds) {
            try {
                this.RemoveAug(augId);
            }
            catch (Throwable e) {
                RookLogger.Instance().log(Level.SEVERE, "Error while removing aug", e, new Object[0]);
            }
        }
    }

    private InstrumentationService() {
        if (disableClassTransform) {
            this.classReloader = new NoopClassReloader();
            return;
        }
        CallbackDispatcher.CreateCallbackDispatcher(this.augs);
        this.LoadDeps();
        inst.addTransformer(this, true);
        if (shouldReloadAllClassesOnStart) {
            this.ReloadAllClasses();
        }
        this.ResetClassReloader();
    }

    private void LoadDeps() {
        HashBiMap<Integer, Integer> map = HashBiMap.create();
        map.get(1);
        map.put(1, 1);
        map.get(1);
    }

    private void finalizeNamespaceArray(ArrayList<String> arr) {
        ArrayList<String> copy = new ArrayList<String>(arr);
        for (String c : copy) {
            arr.add(c.replace('.', '/'));
        }
    }

    private static boolean IsKotlinClass(Class cls) {
        for (Annotation annotations : cls.getAnnotations()) {
            if (!annotations.annotationType().getName().toLowerCase().contains("kotlin")) continue;
            return true;
        }
        return false;
    }

    private static void AddClassToList(Class cls, String className, Files files) {
        int fileNameIndex = className.lastIndexOf(46);
        if (fileNameIndex == -1) {
            fileNameIndex = className.lastIndexOf(47);
        }
        if (fileNameIndex != -1) {
            String fileName = className.substring(fileNameIndex + 1);
            int subclassIndex = fileName.indexOf(36);
            if (subclassIndex != -1) {
                fileName = fileName.substring(0, subclassIndex);
            }
            if (InstrumentationService.IsKotlinClass(cls)) {
                String kotlinFileName = fileName + ".kt";
                files.AddClass(cls.getClassLoader(), kotlinFileName, className);
                if (kotlinFileName.endsWith("Kt.kt")) {
                    files.AddClass(cls.getClassLoader(), kotlinFileName.replace("Kt.kt", ".kt"), className);
                }
                return;
            }
            files.AddClass(cls.getClassLoader(), fileName + ".java", className);
        }
    }

    private boolean IsClassExcluded(String className) {
        for (int i = 0; i < this.excludedContains.length; ++i) {
            if (!className.contains(this.excludedContains[i])) continue;
            return true;
        }
        return false;
    }

    private void ReloadAllClasses() {
        Class[] classes = inst.getAllLoadedClasses();
        int classesLength = classes.length;
        RookLogger.Instance().debug("Parsing " + classesLength + " classes", new Object[0]);
        for (int i = 0; i < classesLength; ++i) {
            String className = "";
            Class cls = classes[i];
            className = cls.getName();
            if (className == null || this.IsClassExcluded(className) || !inst.isModifiableClass(cls) || cls.getProtectionDomain() == null) continue;
            InstrumentationService.AddClassToList(cls, className.replace(".", "/"), this.files);
        }
        RookLogger.Instance().debug("Done reloading classes", new Object[0]);
    }

    @Override
    public byte[] transform(ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        try {
            if (null == className || null == protectionDomain || this.IsClassExcluded(className)) {
                return null;
            }
            URL location = null;
            if (protectionDomain.getCodeSource() != null) {
                location = protectionDomain.getCodeSource().getLocation();
            }
            if (Config.Instance().InstrumentationConfig$CLASS_LOAD_VERBOSE) {
                RookLogger.Instance().debug("Starting class retransform: " + className, new Object[0]);
            }
            ClassReader reader = new ClassReader(classfileBuffer);
            ClassWriter writer = new ClassWriter(reader, 0);
            Visitor visitor = new Visitor(this.files, this.augs, this.activeLocations, classLoader, className, location, writer);
            try {
                reader.accept(visitor, 0);
            }
            catch (Visitor.IgnoreClassException e) {
                return null;
            }
            if (!visitor.isHooked()) {
                return null;
            }
            return writer.toByteArray();
        }
        catch (Throwable e) {
            this.silencedRetransformFailure = true;
            String message = "Failed to transform class: " + className + "  - " + e.toString();
            RookLogger.Instance().log(Level.WARNING, message, e, new Object[0]);
            UserWarnings.SendError(new RookError(e, message));
            return null;
        }
    }

    static {
        shouldReloadAllClassesOnStart = false;
        disableClassTransform = false;
    }
}

