/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Instrumentation;

import com.rookout.rook.Augs.Locations.LocationFileLine;
import com.rookout.rook.Processor.RookError;
import com.rookout.rook.RookLogger;
import com.rookout.rook.Services.Instrumentation.Augs;
import com.rookout.rook.Services.Instrumentation.CallbackDispatcher;
import com.rookout.rook.Services.Instrumentation.Files;
import com.rookout.rook.Services.Instrumentation.HashCheck;
import com.rookout.rook.Services.Instrumentation.LocalVariableInfo;
import com.rookout.rook.Services.Instrumentation.VisitorUtils;
import com.rookout.rook.Utils;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import rook.org.objectweb.asm.ClassVisitor;
import rook.org.objectweb.asm.MethodVisitor;
import rook.org.objectweb.asm.Type;
import rook.org.objectweb.asm.tree.AbstractInsnNode;
import rook.org.objectweb.asm.tree.InsnList;
import rook.org.objectweb.asm.tree.InsnNode;
import rook.org.objectweb.asm.tree.LdcInsnNode;
import rook.org.objectweb.asm.tree.LineNumberNode;
import rook.org.objectweb.asm.tree.MethodInsnNode;
import rook.org.objectweb.asm.tree.MethodNode;
import rook.org.objectweb.asm.tree.TypeInsnNode;
import rook.org.objectweb.asm.tree.analysis.Analyzer;
import rook.org.objectweb.asm.tree.analysis.AnalyzerException;
import rook.org.objectweb.asm.tree.analysis.BasicValue;
import rook.org.objectweb.asm.tree.analysis.BasicVerifier;

class Visitor
extends ClassVisitor {
    private final Files files;
    private final Augs augs;
    List<Type> interfaces;
    Type superType;
    private final ClassLoader classLoader;
    private String fileName;
    private final String className;
    private final URL sourceLocation;
    private boolean isCfm = false;
    private boolean hookedClass = false;
    private Augs.AugsInFile validAugs;

    Visitor(Files files, Augs augs, ClassLoader classLoader, String className, URL sourceLocation, ClassVisitor nextVisitor) {
        super(458752, nextVisitor);
        this.files = files;
        this.augs = augs;
        this.interfaces = null;
        this.superType = null;
        this.classLoader = classLoader;
        this.className = className;
        this.sourceLocation = sourceLocation;
        this.validAugs = new Augs.AugsInFile();
    }

    boolean isHooked() {
        return this.hookedClass;
    }

    @Override
    public void visitSource(String file, String debug) {
        super.visitSource(file, debug);
        if (null != file) {
            if (file.startsWith("<")) {
                this.fileName = file;
            } else {
                try {
                    Path filePath = Paths.get(file, new String[0]);
                    this.fileName = filePath.getFileName().toString();
                }
                catch (InvalidPathException e) {
                    this.fileName = file;
                }
            }
            this.files.AddClass(this.classLoader, this.fileName, this.className);
            this.isCfm = Utils.IsColdFusionFile(this.fileName);
        }
        for (Map.Entry entry : this.augs.GetAugs(this.fileName).entrySet()) {
            Augs.AugList augList = (Augs.AugList)((Augs.AugList)entry.getValue()).clone();
            for (LocationFileLine location : augList) {
                try {
                    this.addAugInValidPosition(location);
                }
                catch (Throwable e) {
                    String message = "Exception while initializing aug during visitSource on aug";
                    RookLogger.Instance().log(Level.SEVERE, message, e, new Object[0]);
                    location.SetError(new RookError(e, message));
                }
            }
        }
        if (this.validAugs.isEmpty()) {
            throw new IgnoreClassException();
        }
    }

    private void addAugInValidPosition(LocationFileLine location) {
        int updatedLineNo = location.getLineno();
        if (HashCheck.shouldValidateHash(location)) {
            updatedLineNo = HashCheck.GetUpdatedLineNumber(location, this.className, this.classLoader);
        }
        if (updatedLineNo != -1) {
            Augs.AugList validAugsList = (Augs.AugList)this.validAugs.get(updatedLineNo);
            if (validAugsList != null) {
                validAugsList.add(location);
            } else {
                Augs.AugList newAugList = new Augs.AugList();
                newAugList.add(location);
                this.validAugs.put(updatedLineNo, newAugList);
            }
        }
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.superType = superName == null ? null : Type.getObjectType(superName);
        this.interfaces = new ArrayList<Type>();
        for (String anInterface : interfaces) {
            this.interfaces.add(Type.getObjectType(anInterface));
        }
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        final MethodVisitor methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
        if (null == this.fileName || this.validAugs.isEmpty()) {
            throw new IgnoreClassException();
        }
        return new MethodNode(327680, access, name, desc, signature, exceptions){

            @Override
            public void visitEnd() {
                boolean hookedMethod = false;
                ArrayList<Integer> hookedLines = new ArrayList<Integer>();
                Augs.AugList activeAugs = new Augs.AugList();
                ListIterator<AbstractInsnNode> insn = this.instructions.iterator();
                while (insn.hasNext()) {
                    Augs.AugList augList;
                    AbstractInsnNode node = insn.next();
                    if (node.getType() != 15) continue;
                    LineNumberNode lineNumberNode = (LineNumberNode)node;
                    if (hookedLines.contains(lineNumberNode.line) || (augList = (Augs.AugList)Visitor.this.validAugs.get(lineNumberNode.line)) == null || augList.isEmpty()) continue;
                    if (this.instructions.get(insn.nextIndex()).getType() == 14) {
                        node = insn.next();
                    }
                    InsnList hook = this.BuildHook(lineNumberNode, augList);
                    this.instructions.insert(node, hook);
                    activeAugs.addAll(augList);
                    hookedMethod = true;
                    Visitor.this.hookedClass = true;
                    hookedLines.add(lineNumberNode.line);
                }
                if (hookedMethod) {
                    this.maxStack += 6;
                    this.verify();
                    for (LocationFileLine location : activeAugs) {
                        location.SetActive();
                    }
                }
                this.accept(methodVisitor);
            }

            private void verify() {
                BasicVerifier verifier = new BasicVerifier();
                Analyzer<BasicValue> a = new Analyzer<BasicValue>(verifier);
                try {
                    a.analyze(Visitor.this.className, this);
                }
                catch (AnalyzerException e) {
                    throw new BytecodeVerificationException("Error while transforming method", e);
                }
                try {
                    Visitor.this.classLoader.loadClass("com.rookout.agent.StaticCallback");
                }
                catch (ClassNotFoundException e) {
                    throw new ClassLoadingVerificationException(e);
                }
            }

            private InsnList BuildHook(LineNumberNode hookNode, Augs.AugList augs) {
                InsnList hook = new InsnList();
                hook.add(VisitorUtils.PushInt(augs.size()));
                hook.add(new TypeInsnNode(189, Type.getInternalName(String.class)));
                hook.add(new InsnNode(89));
                for (int i = 0; i < augs.size(); ++i) {
                    hook.add(VisitorUtils.PushInt(i));
                    hook.add(new LdcInsnNode(((LocationFileLine)augs.get(i)).getAugId()));
                    hook.add(new InsnNode(83));
                    hook.add(new InsnNode(89));
                }
                hook.remove(hook.getLast());
                hook.add(new TypeInsnNode(187, Type.getInternalName(HashMap.class)));
                hook.add(new InsnNode(89));
                hook.add(new MethodInsnNode(183, Type.getInternalName(HashMap.class), "<init>", "()V", false));
                LocalVariableInfo[] variables = new LocalVariableInfo[this.maxLocals];
                for (int i = 0; i < variables.length; ++i) {
                    variables[i] = new LocalVariableInfo();
                }
                VisitorUtils.LoadArguments(variables, this.name, this.desc, this.access);
                this.ScanMethod(hookNode, variables);
                int localsCount = VisitorUtils.ParseVariables(variables, hook, Visitor.this.isCfm);
                String localsFromDisk = Utils.GetConfigurationString("ROOKOUT_ENABLE_LOCALS_PARSING");
                if (localsFromDisk != null && localsCount == 0) {
                    RookLogger.Instance().log(Level.INFO, "No locals found - parsing variables from disk");
                    VisitorUtils.ParseLocalVariablesFromDisk(Visitor.this.sourceLocation, hook, hookNode, Visitor.this.className, this.name, this.desc, Visitor.this.isCfm);
                }
                hook.add(new MethodInsnNode(184, "com/rookout/agent/StaticCallback", "Callback", CallbackDispatcher.CallbackDescriptor, false));
                return hook;
            }

            private void ScanMethod(LineNumberNode hookNode, LocalVariableInfo[] variables) {
                AbstractInsnNode insnIterator;
                ListIterator<AbstractInsnNode> it = this.instructions.iterator();
                while (it.hasNext() && (insnIterator = it.next()) != hookNode) {
                    VisitorUtils.ParseVariblesFromNodes(insnIterator, variables, this.localVariables, this.name, Visitor.this.superType);
                }
            }
        };
    }

    static class ClassLoadingVerificationException
    extends AssertionError {
        ClassLoadingVerificationException(Throwable cause) {
            super("Unable to load class using relevant ClassLoader", cause);
        }
    }

    static class BytecodeVerificationException
    extends AssertionError {
        BytecodeVerificationException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    static class IgnoreClassException
    extends AssertionError {
        IgnoreClassException() {
        }
    }
}

