/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Instrumentation;

import com.rookout.rook.Augs.Aug;
import com.rookout.rook.Augs.Locations.HashInfo;
import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.RookError;
import com.rookout.rook.RookLogger;
import com.rookout.rook.Utils;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.zip.CRC32;

class HashCheck {
    HashCheck() {
    }

    static FileHashes getBufferHash(byte[] buffer) throws NoSuchAlgorithmException, IOException {
        String fileContents = new String(buffer).replace("\r\n", "\n").replace("\r\u0000\n\u0000", "\n\u0000").replace("\r", "\n");
        CRC32 checksum = new CRC32();
        String[] lines = fileContents.split("\n");
        Long[] linesHashes = new Long[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            checksum.update(lines[i].getBytes(), 0, lines[i].length());
            linesHashes[i] = checksum.getValue() & 0xFFFFFFFFFFFFFFFFL;
            checksum.reset();
        }
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] hash = digest.digest(fileContents.getBytes("UTF-8"));
        return new FileHashes(Utils.bytesToHex(hash), linesHashes);
    }

    static FileHashes getFileHash(String filename) throws NoSuchAlgorithmException, IOException {
        return HashCheck.getBufferHash(Files.readAllBytes(Paths.get(filename, new String[0])));
    }

    static FileHashes getJarFileHash(JarFile jar, JarEntry filename) throws NoSuchAlgorithmException, IOException {
        return HashCheck.getBufferHash(Utils.getEntryBytes(jar, filename));
    }

    static ArrayList<FileHashes> getJarHashes(JarFile jar, String fileName) throws NoSuchAlgorithmException, IOException {
        ArrayList<FileHashes> hashes = new ArrayList<FileHashes>();
        Enumeration<JarEntry> elements = jar.entries();
        while (elements.hasMoreElements()) {
            JarEntry entry = elements.nextElement();
            if (!entry.getName().endsWith(fileName)) continue;
            hashes.add(HashCheck.getJarFileHash(jar, entry));
        }
        return hashes;
    }

    static String getDecodedURLPath(URL url) throws URISyntaxException {
        return Paths.get(url.toURI()).toString();
    }

    static int findLineUsingCrc(Aug aug, HashInfo hashInfo, FileHashes fileHashes, String filePath) {
        Long actualCrc = 0L;
        if (hashInfo.lineno > 0 && hashInfo.lineno <= fileHashes.lines_crcs.length) {
            actualCrc = fileHashes.lines_crcs[hashInfo.lineno - 1];
        }
        if (fileHashes.lines_crcs.length >= hashInfo.lineno && hashInfo.line_crc.equals(actualCrc)) {
            return hashInfo.lineno;
        }
        if (!hashInfo.line_crc_unique.booleanValue()) {
            aug.SetError(new RookError(new Exceptions.RookCrcMismatchException(filePath, hashInfo.line_crc, actualCrc)));
            return -1;
        }
        int firstIndex = -1;
        boolean secondFound = false;
        for (int i = 0; i < fileHashes.lines_crcs.length; ++i) {
            if (!fileHashes.lines_crcs[i].equals(hashInfo.line_crc)) continue;
            if (firstIndex == -1) {
                firstIndex = i;
                continue;
            }
            secondFound = true;
            break;
        }
        if (firstIndex != -1 && !secondFound) {
            int updatedLine = firstIndex + 1;
            aug.SendWarning(new RookError(new Exceptions.RookLineMoved(filePath, hashInfo.lineno, updatedLine)));
            return updatedLine;
        }
        aug.SetError(new RookError(new Exceptions.RookCrcMismatchException(filePath, hashInfo.line_crc, actualCrc)));
        return -1;
    }

    static boolean shouldValidateHash(Aug aug, HashInfo hashInfo, String className, URL sourceLocation, String fileName) {
        if (sourceLocation == null) {
            aug.SendWarning(new RookError(new Exceptions.RookSourceMissing(fileName, className)));
            return false;
        }
        if (hashInfo == null) {
            return false;
        }
        return hashInfo.file_hash != null || hashInfo.line_crc != null;
    }

    static int findLineUsingCrcFromMultipleFiles(Aug aug, HashInfo hashInfo, ArrayList<FileHashes> hashes, String fileName) {
        int count = 0;
        int potentialNewLine = -1;
        for (FileHashes h : hashes) {
            int updatedLine = HashCheck.findLineUsingCrc(aug, hashInfo, h, fileName);
            if (updatedLine == -1) continue;
            potentialNewLine = updatedLine;
            ++count;
        }
        if (count == 1) {
            return potentialNewLine;
        }
        return -1;
    }

    static int GetUpdatedLineNumber(Aug aug, HashInfo hashInfo, String className, URL sourceLocation, String fileName, int originalLine) {
        try {
            ArrayList<FileHashes> hashes;
            block20: {
                hashes = new ArrayList<FileHashes>();
                try {
                    String sourceLocationPath;
                    if (Utils.IsColdFusionFile(fileName).booleanValue() || Utils.isGroovyFile(fileName).booleanValue()) {
                        String filePath = sourceLocation.getPath();
                        FileHashes localHash = HashCheck.getFileHash(filePath);
                        if (hashInfo.line_crc != null) {
                            return HashCheck.findLineUsingCrc(aug, hashInfo, localHash, filePath);
                        }
                        if (!localHash.file_hash.equals(hashInfo.file_hash)) {
                            aug.SetError(new RookError(new Exceptions.RookHashMismatchException(filePath, hashInfo.file_hash, localHash.file_hash)));
                            return -1;
                        }
                        return hashInfo.lineno;
                    }
                    URLConnection connection = sourceLocation.openConnection();
                    if (connection instanceof JarURLConnection) {
                        URI url;
                        String sourcePath = sourceLocation.getPath();
                        int index = sourcePath.indexOf(33);
                        if (index != -1) {
                            url = new URI(sourcePath.substring(0, index));
                        } else {
                            RookLogger.Instance().log(Level.SEVERE, "Encountered unusual path: " + sourcePath);
                            url = new URI(sourcePath);
                        }
                        hashes.addAll(HashCheck.getJarHashes(new JarFile(url.getPath()), fileName));
                        break block20;
                    }
                    if (connection.getURL().getFile().endsWith(".jar")) {
                        JarFile jar = new JarFile(HashCheck.getDecodedURLPath(connection.getURL()));
                        hashes.addAll(HashCheck.getJarHashes(jar, fileName));
                        break block20;
                    }
                    if (!sourceLocation.getPath().endsWith("/") && !sourceLocation.getPath().endsWith("\\")) break block20;
                    try {
                        sourceLocationPath = HashCheck.getDecodedURLPath(sourceLocation);
                    }
                    catch (IllegalArgumentException | URISyntaxException e) {
                        sourceLocationPath = sourceLocation.getFile();
                    }
                    ArrayList<File> sourceFiles = new ArrayList<File>();
                    sourceFiles.add(Paths.get(sourceLocationPath, fileName).toFile());
                    int indexOfBackslash = className.lastIndexOf("/");
                    if (indexOfBackslash != -1) {
                        sourceFiles.add(Paths.get(sourceLocationPath, className.substring(0, indexOfBackslash).replace("/", File.separator), fileName).toFile());
                    }
                    for (File file : sourceFiles) {
                        if (!file.isFile()) continue;
                        hashes.add(HashCheck.getFileHash(file.getAbsolutePath()));
                    }
                }
                catch (IOException | NoSuchAlgorithmException e) {
                    aug.SendWarning(new RookError(new Exceptions.RookHashCalculationFailed(fileName, className, (Throwable)e)));
                    return originalLine;
                }
            }
            if (hashes.isEmpty()) {
                aug.SendWarning(new RookError(new Exceptions.RookSourceFileNotFound(fileName)));
                return hashInfo.lineno;
            }
            int count = 0;
            for (FileHashes h : hashes) {
                if (!h.file_hash.equals(hashInfo.file_hash)) continue;
                ++count;
            }
            if (count == 0) {
                if (hashInfo.line_crc != null && hashInfo.lineno != -1) {
                    return HashCheck.findLineUsingCrcFromMultipleFiles(aug, hashInfo, hashes, fileName);
                }
                aug.SetError(new RookError(new Exceptions.RookHashMismatchException(fileName, hashInfo.file_hash, hashes.get((int)0).file_hash)));
                return -1;
            }
            if (count == 1) {
                return hashInfo.lineno;
            }
            aug.SendWarning(new RookError(new Exceptions.RookMultipleSoruceFilesFound(fileName)));
            return hashInfo.lineno;
        }
        catch (Throwable e) {
            String message = "Exception while performing hash check";
            RookLogger.Instance().log(Level.WARNING, message, e, new Object[0]);
            aug.SendWarning(new RookError(e, message));
            return hashInfo.lineno;
        }
    }

    public static class FileHashes {
        public String file_hash;
        public Long[] lines_crcs;

        public FileHashes(String file_hash, Long[] lines_crcs) {
            this.file_hash = file_hash;
            this.lines_crcs = lines_crcs;
        }
    }
}

