/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.propono.blogclient.atomprotocol;

import com.rometools.propono.atom.client.ClientEntry;
import com.rometools.propono.atom.common.rome.AppModule;
import com.rometools.propono.atom.common.rome.AppModuleImpl;
import com.rometools.propono.blogclient.BaseBlogEntry;
import com.rometools.propono.blogclient.BlogClientException;
import com.rometools.propono.blogclient.BlogEntry;
import com.rometools.propono.blogclient.atomprotocol.AtomBlog;
import com.rometools.propono.blogclient.atomprotocol.AtomCollection;
import com.rometools.propono.utils.ProponoException;
import com.rometools.rome.feed.atom.Category;
import com.rometools.rome.feed.atom.Content;
import com.rometools.rome.feed.atom.Entry;
import com.rometools.rome.feed.atom.Link;
import com.rometools.rome.feed.atom.Person;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Deprecated
public class AtomEntry
extends BaseBlogEntry
implements BlogEntry {
    String editURI = null;
    AtomCollection collection = null;

    AtomEntry(AtomBlog blog, AtomCollection collection) throws BlogClientException {
        super(blog);
        this.collection = collection;
    }

    AtomEntry(AtomCollection collection, ClientEntry entry) throws BlogClientException {
        this((AtomBlog)collection.getBlog(), collection);
        this.copyFromRomeEntry(entry);
    }

    AtomEntry(AtomBlog blog, ClientEntry entry) throws BlogClientException {
        super(blog);
        this.copyFromRomeEntry(entry);
    }

    @Override
    public String getToken() {
        return this.editURI;
    }

    AtomCollection getCollection() {
        return this.collection;
    }

    void setCollection(AtomCollection collection) {
        this.collection = collection;
    }

    public boolean equals(Object o) {
        AtomEntry other;
        if (o instanceof AtomEntry && (other = (AtomEntry)o).getToken() != null && this.getToken() != null) {
            return other.getToken().equals(this.getToken());
        }
        return false;
    }

    @Override
    public void save() throws BlogClientException {
        boolean create;
        boolean bl = create = this.getToken() == null;
        if (create && this.getCollection() == null) {
            throw new BlogClientException("Cannot save entry, no collection");
        }
        if (create) {
            try {
                ClientEntry clientEntry = this.collection.getClientCollection().createEntry();
                this.copyToRomeEntry(clientEntry);
                this.collection.getClientCollection().addEntry(clientEntry);
                this.copyFromRomeEntry(clientEntry);
            }
            catch (ProponoException ex) {
                throw new BlogClientException("Error saving entry", ex);
            }
        }
        try {
            ClientEntry clientEntry = ((AtomBlog)this.getBlog()).getService().getEntry(this.getToken());
            this.copyToRomeEntry(clientEntry);
            clientEntry.update();
            this.copyFromRomeEntry(clientEntry);
        }
        catch (ProponoException ex) {
            throw new BlogClientException("Error updating entry", ex);
        }
    }

    @Override
    public void delete() throws BlogClientException {
        if (this.getToken() == null) {
            throw new BlogClientException("Cannot delete unsaved entry");
        }
        try {
            ClientEntry clientEntry = ((AtomBlog)this.getBlog()).getService().getEntry(this.editURI);
            clientEntry.remove();
        }
        catch (ProponoException ex) {
            throw new BlogClientException("Error removing entry", ex);
        }
    }

    void copyFromRomeEntry(ClientEntry entry) {
        Person romeAuthor;
        List authors;
        this.id = entry.getId();
        this.title = entry.getTitle();
        this.editURI = entry.getEditURI();
        List altlinks = entry.getAlternateLinks();
        if (altlinks != null) {
            for (Link link : altlinks) {
                if (!"alternate".equals(link.getRel()) && link.getRel() != null) continue;
                this.permalink = link.getHrefResolved();
                break;
            }
        }
        List contents = entry.getContents();
        Content romeContent = null;
        if (contents != null && !contents.isEmpty()) {
            romeContent = (Content)contents.get(0);
        }
        if (romeContent != null) {
            this.content = new BlogEntry.Content(romeContent.getValue());
            this.content.setType(romeContent.getType());
            this.content.setSrc(romeContent.getSrc());
        }
        if (entry.getCategories() != null) {
            ArrayList<BlogEntry.Category> cats = new ArrayList<BlogEntry.Category>();
            List romeCats = entry.getCategories();
            for (Category romeCat : romeCats) {
                BlogEntry.Category cat = new BlogEntry.Category();
                cat.setId(romeCat.getTerm());
                cat.setUrl(romeCat.getScheme());
                cat.setName(romeCat.getLabel());
                cats.add(cat);
            }
            this.categories = cats;
        }
        if ((authors = entry.getAuthors()) != null && !authors.isEmpty() && (romeAuthor = (Person)authors.get(0)) != null) {
            this.author = new BlogEntry.Person();
            this.author.setName(romeAuthor.getName());
            this.author.setEmail(romeAuthor.getEmail());
            this.author.setUrl(romeAuthor.getUrl());
        }
        this.publicationDate = entry.getPublished();
        this.modificationDate = entry.getModified();
        AppModule control = (AppModule)entry.getModule("http://www.w3.org/2007/app");
        this.draft = control != null && control.getDraft() != null ? control.getDraft() : false;
    }

    Entry copyToRomeEntry(ClientEntry entry) {
        if (this.id != null) {
            entry.setId(this.id);
        }
        entry.setTitle(this.title);
        if (this.author != null) {
            Person person = new Person();
            person.setName(this.author.getName());
            person.setEmail(this.author.getEmail());
            person.setUrl(this.author.getUrl());
            ArrayList<Person> authors = new ArrayList<Person>();
            authors.add(person);
            entry.setAuthors(authors);
        }
        if (this.content != null) {
            Content romeContent = new Content();
            romeContent.setValue(this.content.getValue());
            romeContent.setType(this.content.getType());
            ArrayList contents = new ArrayList();
            contents.add(romeContent);
            entry.setContents(contents);
        }
        if (this.categories != null) {
            ArrayList<Category> romeCats = new ArrayList<Category>();
            for (BlogEntry.Category cat : this.categories) {
                Category romeCategory = new Category();
                romeCategory.setTerm(cat.getId());
                romeCategory.setScheme(cat.getUrl());
                romeCategory.setLabel(cat.getName());
                romeCats.add(romeCategory);
            }
            entry.setCategories(romeCats);
        }
        entry.setPublished(this.publicationDate == null ? new Date() : this.publicationDate);
        entry.setModified(this.modificationDate == null ? new Date() : this.modificationDate);
        ArrayList<AppModuleImpl> modules = new ArrayList<AppModuleImpl>();
        AppModuleImpl control = new AppModuleImpl();
        control.setDraft(new Boolean(this.draft));
        modules.add(control);
        entry.setModules(modules);
        return entry;
    }
}

