/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.propono.atom.server.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
class FileStore {
    private static final Logger LOG = LoggerFactory.getLogger(FileStore.class);
    private static final FileStore fileStore = new FileStore();

    FileStore() {
    }

    public String getNextId() {
        return RandomStringUtils.randomAlphanumeric((int)20);
    }

    public boolean exists(String path) {
        File f = new File(path);
        return f.exists();
    }

    public InputStream getFileInputStream(String path) {
        LOG.debug("getFileContents path: " + path);
        try {
            return new BufferedInputStream(new FileInputStream(path));
        }
        catch (FileNotFoundException e) {
            LOG.debug("   File not found: " + path);
            return null;
        }
    }

    public OutputStream getFileOutputStream(String path) {
        LOG.debug("getFileOutputStream path: " + path);
        try {
            File f = new File(path);
            f.getParentFile().mkdirs();
            return new BufferedOutputStream(new FileOutputStream(f));
        }
        catch (FileNotFoundException e) {
            LOG.debug("   File not found: " + path);
            return null;
        }
    }

    public void createOrUpdateFile(String path, InputStream content) throws FileNotFoundException, IOException {
        int read;
        LOG.debug("createOrUpdateFile path: " + path);
        File f = new File(path);
        f.mkdirs();
        FileOutputStream out = new FileOutputStream(f);
        byte[] buffer = new byte[2048];
        while ((read = content.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
        out.close();
    }

    public void deleteFile(String path) {
        LOG.debug("deleteFile path: " + path);
        File f = new File(path);
        if (!f.delete()) {
            LOG.debug("   Failed to delete: " + f.getAbsolutePath());
        }
    }

    public static FileStore getFileStore() {
        return fileStore;
    }

    public boolean deleteDirectory(String path) {
        return this.deleteDirectory(new File(path));
    }

    public boolean deleteDirectory(File path) {
        LOG.debug("deleteDirectory path: " + path);
        if (path.exists()) {
            File[] files;
            for (File file : files = path.listFiles()) {
                if (file.isDirectory()) {
                    this.deleteDirectory(file);
                    continue;
                }
                file.delete();
            }
        }
        return path.delete();
    }
}

