/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.propono.atom.common;

import com.rometools.propono.atom.common.AtomService;
import com.rometools.propono.atom.common.Categories;
import com.rometools.propono.utils.ProponoException;
import com.rometools.rome.io.impl.Atom10Parser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Parent;

@Deprecated
public class Collection {
    public static final String ENTRY_TYPE = "application/atom+xml;type=entry";
    private final List<Categories> categories = new ArrayList<Categories>();
    private Element collectionElement = null;
    private String baseURI = null;
    private String title = null;
    private String titleType = null;
    private List<String> accepts = new ArrayList<String>();
    private String href = null;

    public Collection(String title, String titleType, String href) {
        this.title = title;
        this.titleType = titleType;
        this.href = href;
    }

    public Collection(Element e) throws ProponoException {
        this.collectionElement = e;
        this.parseCollectionElement(e);
    }

    public Collection(Element e, String baseURI) throws ProponoException {
        this.collectionElement = e;
        this.baseURI = baseURI;
        this.parseCollectionElement(e);
    }

    public List<String> getAccepts() {
        return this.accepts;
    }

    public void addAccept(String accept) {
        this.accepts.add(accept);
    }

    public void setAccepts(List<String> accepts) {
        this.accepts = accepts;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public String getHrefResolved() {
        if (Atom10Parser.isAbsoluteURI((String)this.href)) {
            return this.href;
        }
        if (this.baseURI != null && this.collectionElement != null) {
            int lastslash = this.baseURI.lastIndexOf("/");
            return Atom10Parser.resolveURI((String)this.baseURI.substring(0, lastslash), (Parent)this.collectionElement, (String)this.href);
        }
        return null;
    }

    public String getHrefResolved(String relativeUri) {
        if (Atom10Parser.isAbsoluteURI((String)relativeUri)) {
            return relativeUri;
        }
        if (this.baseURI != null && this.collectionElement != null) {
            int lastslash = this.baseURI.lastIndexOf("/");
            return Atom10Parser.resolveURI((String)this.baseURI.substring(0, lastslash), (Parent)this.collectionElement, (String)relativeUri);
        }
        return null;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitleType() {
        return this.titleType;
    }

    public void setTitleType(String titleType) {
        this.titleType = titleType;
    }

    public void addCategories(Categories cats) {
        this.categories.add(cats);
    }

    public List<Categories> getCategories() {
        return this.categories;
    }

    public boolean accepts(String ct) {
        for (String element : this.accepts) {
            String[] rules;
            String accept = element;
            if (accept != null && accept.trim().equals("*/*")) {
                return true;
            }
            String entryType = "application/atom+xml";
            boolean entry = "application/atom+xml".equals(ct);
            if (entry && null == accept) {
                return true;
            }
            if (entry && "entry".equals(accept)) {
                return true;
            }
            if (entry && "application/atom+xml".equals(accept)) {
                return true;
            }
            for (String rule2 : rules = this.accepts.toArray(new String[this.accepts.size()])) {
                String rule = rule2.trim();
                if (rule.equals(ct)) {
                    return true;
                }
                int slashstar = rule.indexOf("/*");
                if (slashstar <= 0 || !ct.startsWith(rule = rule.substring(0, slashstar + 1))) continue;
                return true;
            }
        }
        return false;
    }

    public Element collectionToElement() {
        Collection collection = this;
        Element element = new Element("collection", AtomService.ATOM_PROTOCOL);
        element.setAttribute("href", collection.getHref());
        Element titleElem = new Element("title", AtomService.ATOM_FORMAT);
        titleElem.setText(collection.getTitle());
        if (collection.getTitleType() != null && !collection.getTitleType().equals("TEXT")) {
            titleElem.setAttribute("type", collection.getTitleType(), AtomService.ATOM_FORMAT);
        }
        element.addContent((Content)titleElem);
        Iterator<Object> iterator = collection.getCategories().iterator();
        while (iterator.hasNext()) {
            Categories categories;
            Categories cats = categories = iterator.next();
            element.addContent((Content)cats.categoriesToElement());
        }
        for (Object object : collection.getAccepts()) {
            String range = (String)object;
            Element acceptElem = new Element("accept", AtomService.ATOM_PROTOCOL);
            acceptElem.setText(range);
            element.addContent((Content)acceptElem);
        }
        return element;
    }

    public Collection elementToCollection(Element element) throws ProponoException {
        return new Collection(element);
    }

    protected void parseCollectionElement(Element element) throws ProponoException {
        List acceptElems;
        this.setHref(element.getAttribute("href").getValue());
        Element titleElem = element.getChild("title", AtomService.ATOM_FORMAT);
        if (titleElem != null) {
            this.setTitle(titleElem.getText());
            if (titleElem.getAttribute("type", AtomService.ATOM_FORMAT) != null) {
                this.setTitleType(titleElem.getAttribute("type", AtomService.ATOM_FORMAT).getValue());
            }
        }
        if ((acceptElems = element.getChildren("accept", AtomService.ATOM_PROTOCOL)) != null && !acceptElems.isEmpty()) {
            for (Element acceptElem : acceptElems) {
                this.addAccept(acceptElem.getTextTrim());
            }
        }
        List catsElems = element.getChildren("categories", AtomService.ATOM_PROTOCOL);
        for (Element catsElem : catsElems) {
            Categories cats = new Categories(catsElem, this.baseURI);
            this.addCategories(cats);
        }
    }
}

