/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.propono.atom.client;

import com.rometools.propono.atom.client.AuthStrategy;
import com.rometools.propono.utils.ProponoException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import net.oauth.OAuth;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthMessage;
import net.oauth.OAuthServiceProvider;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.util.ParameterParser;

@Deprecated
public class OAuthStrategy
implements AuthStrategy {
    private State state = State.UNAUTHORIZED;
    private final String username;
    private final String consumerKey;
    private final String consumerSecret;
    private final String keyType;
    private final String reqUrl;
    private final String authzUrl;
    private final String accessUrl;
    private final String nonce;
    private final long timestamp;
    private String requestToken = null;
    private String accessToken = null;
    private String tokenSecret = null;

    public OAuthStrategy(String username, String key, String secret, String keyType, String reqUrl, String authzUrl, String accessUrl) throws ProponoException {
        this.username = username;
        this.reqUrl = reqUrl;
        this.authzUrl = authzUrl;
        this.accessUrl = accessUrl;
        this.consumerKey = key;
        this.consumerSecret = secret;
        this.keyType = keyType;
        this.nonce = UUID.randomUUID().toString();
        this.timestamp = new Date().getTime() / 1000L;
        this.init();
    }

    private void init() throws ProponoException {
        this.callOAuthUri(this.reqUrl);
        this.callOAuthUri(this.authzUrl);
        this.callOAuthUri(this.accessUrl);
    }

    @Override
    public void addAuthentication(HttpClient httpClient, HttpMethodBase method) throws ProponoException {
        Object parameters;
        if (this.state != State.ACCESS_TOKEN) {
            throw new ProponoException("ERROR: authentication strategy failed init");
        }
        Object originalqlist = null;
        if (method.getQueryString() != null) {
            String qstring = method.getQueryString().trim();
            qstring = qstring.startsWith("?") ? qstring.substring(1) : qstring;
            originalqlist = parameters = new ParameterParser().parse(qstring, '&');
        } else {
            originalqlist = new ArrayList();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        parameters = originalqlist.iterator();
        while (parameters.hasNext()) {
            Object element = parameters.next();
            NameValuePair pair = (NameValuePair)element;
            params.put(pair.getName(), pair.getValue());
        }
        params.put("xoauth_requestor_id", this.username);
        params.put("oauth_consumer_key", this.consumerKey);
        params.put("oauth_signature_method", this.keyType);
        params.put("oauth_timestamp", Long.toString(this.timestamp));
        params.put("oauth_nonce", this.nonce);
        params.put("oauth_token", this.accessToken);
        params.put("oauth_token_secret", this.tokenSecret);
        String finalUri = null;
        OAuthServiceProvider provider = new OAuthServiceProvider(this.reqUrl, this.authzUrl, this.accessUrl);
        OAuthConsumer consumer = new OAuthConsumer(null, this.consumerKey, this.consumerSecret, provider);
        OAuthAccessor accessor = new OAuthAccessor(consumer);
        accessor.tokenSecret = this.tokenSecret;
        try {
            OAuthMessage message = new OAuthMessage(method.getName(), method.getURI().toString(), params.entrySet());
            message.sign(accessor);
            finalUri = OAuth.addParameters((String)message.URL, (Iterable)message.getParameters());
        }
        catch (Exception ex) {
            throw new ProponoException("ERROR: OAuth signing request", ex);
        }
        method.setQueryString(finalUri.substring(finalUri.lastIndexOf("?")));
    }

    private void callOAuthUri(String uri) throws ProponoException {
        String content;
        GetMethod method;
        String finalUri;
        OAuthMessage message;
        HttpClient httpClient = new HttpClient();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("oauth_version", "1.0");
        if (this.username != null) {
            params.put("xoauth_requestor_id", this.username);
        }
        params.put("oauth_consumer_key", this.consumerKey);
        params.put("oauth_signature_method", this.keyType);
        params.put("oauth_timestamp", Long.toString(this.timestamp));
        params.put("oauth_nonce", this.nonce);
        params.put("oauth_callback", "none");
        OAuthServiceProvider provider = new OAuthServiceProvider(this.reqUrl, this.authzUrl, this.accessUrl);
        OAuthConsumer consumer = new OAuthConsumer(null, this.consumerKey, this.consumerSecret, provider);
        OAuthAccessor accessor = new OAuthAccessor(consumer);
        if (this.state == State.UNAUTHORIZED) {
            try {
                message = new OAuthMessage("GET", uri, params.entrySet());
                message.sign(accessor);
                finalUri = OAuth.addParameters((String)message.URL, (Iterable)message.getParameters());
                method = new GetMethod(finalUri);
                httpClient.executeMethod((HttpMethod)method);
                content = method.getResponseBodyAsString();
            }
            catch (Exception e) {
                throw new ProponoException("ERROR fetching request token", e);
            }
        } else if (this.state == State.REQUEST_TOKEN) {
            try {
                params.put("oauth_token", this.requestToken);
                params.put("oauth_token_secret", this.tokenSecret);
                accessor.tokenSecret = this.tokenSecret;
                message = new OAuthMessage("POST", uri, params.entrySet());
                message.sign(accessor);
                finalUri = OAuth.addParameters((String)message.URL, (Iterable)message.getParameters());
                method = new PostMethod(finalUri);
                httpClient.executeMethod((HttpMethod)method);
                content = method.getResponseBodyAsString();
            }
            catch (Exception e) {
                throw new ProponoException("ERROR fetching request token", e);
            }
        } else if (this.state == State.AUTHORIZED) {
            try {
                params.put("oauth_token", this.accessToken);
                params.put("oauth_token_secret", this.tokenSecret);
                accessor.tokenSecret = this.tokenSecret;
                message = new OAuthMessage("GET", uri, params.entrySet());
                message.sign(accessor);
                finalUri = OAuth.addParameters((String)message.URL, (Iterable)message.getParameters());
                method = new GetMethod(finalUri);
                httpClient.executeMethod((HttpMethod)method);
                content = method.getResponseBodyAsString();
            }
            catch (Exception e) {
                throw new ProponoException("ERROR fetching request token", e);
            }
        } else {
            Object method2 = null;
            Object content2 = null;
            return;
        }
        String token = null;
        String secret = null;
        if (content != null) {
            String[] settings;
            for (String setting2 : settings = content.split("&")) {
                String[] setting = setting2.split("=");
                if (setting.length <= 1) continue;
                if ("oauth_token".equals(setting[0])) {
                    token = setting[1];
                    continue;
                }
                if (!"oauth_token_secret".equals(setting[0])) continue;
                secret = setting[1];
            }
        }
        switch (this.state) {
            case UNAUTHORIZED: {
                if (token != null && secret != null) {
                    this.requestToken = token;
                    this.tokenSecret = secret;
                    this.state = State.REQUEST_TOKEN;
                    break;
                }
                throw new ProponoException("ERROR: requestToken or tokenSecret is null");
            }
            case REQUEST_TOKEN: {
                if (method.getStatusCode() == 200) {
                    this.state = State.AUTHORIZED;
                    break;
                }
                throw new ProponoException("ERROR: authorization returned code: " + method.getStatusCode());
            }
            case AUTHORIZED: {
                if (token != null && secret != null) {
                    this.accessToken = token;
                    this.tokenSecret = secret;
                    this.state = State.ACCESS_TOKEN;
                    break;
                }
                throw new ProponoException("ERROR: accessToken or tokenSecret is null");
            }
        }
    }

    private static enum State {
        UNAUTHORIZED,
        REQUEST_TOKEN,
        AUTHORIZED,
        ACCESS_TOKEN;

    }
}

