/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.propono.atom.client;

import com.rometools.propono.atom.client.AuthStrategy;
import com.rometools.propono.atom.client.ClientAtomService;
import com.rometools.propono.atom.client.ClientCategories;
import com.rometools.propono.atom.client.ClientEntry;
import com.rometools.propono.atom.client.ClientMediaEntry;
import com.rometools.propono.atom.client.ClientWorkspace;
import com.rometools.propono.atom.client.EntryIterator;
import com.rometools.propono.atom.common.AtomService;
import com.rometools.propono.atom.common.Collection;
import com.rometools.propono.atom.common.Workspace;
import com.rometools.propono.utils.ProponoException;
import com.rometools.rome.feed.atom.Entry;
import com.rometools.rome.io.impl.Atom10Parser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.jdom2.Element;

@Deprecated
public class ClientCollection
extends Collection {
    private final boolean writable = true;
    private HttpClient httpClient = null;
    private AuthStrategy authStrategy = null;
    private ClientWorkspace workspace = null;
    private ClientAtomService service = null;

    ClientCollection(Element e, ClientWorkspace workspace, String baseURI) throws ProponoException {
        super(e, baseURI);
        this.workspace = workspace;
        this.service = workspace.getAtomService();
        this.httpClient = workspace.getAtomService().getHttpClient();
        this.authStrategy = workspace.getAtomService().getAuthStrategy();
        this.parseCollectionElement(e);
    }

    ClientCollection(String href, AuthStrategy authStrategy) throws ProponoException {
        super("Standalone connection", "text", href);
        this.authStrategy = authStrategy;
        try {
            this.httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
            this.httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(30000);
        }
        catch (Throwable t) {
            throw new ProponoException("ERROR creating HTTPClient", t);
        }
    }

    void addAuthentication(HttpMethodBase method) throws ProponoException {
        this.authStrategy.addAuthentication(this.httpClient, method);
    }

    HttpClient getHttpClient() {
        return this.httpClient;
    }

    public Iterator<ClientEntry> getEntries() throws ProponoException {
        return new EntryIterator(this);
    }

    public ClientEntry getEntry(String uri) throws ProponoException {
        GetMethod method = new GetMethod(uri);
        this.authStrategy.addAuthentication(this.httpClient, (HttpMethodBase)method);
        try {
            this.httpClient.executeMethod((HttpMethod)method);
            if (method.getStatusCode() != 200) {
                throw new ProponoException("ERROR HTTP status code=" + method.getStatusCode());
            }
            Entry romeEntry = Atom10Parser.parseEntry((Reader)new InputStreamReader(method.getResponseBodyAsStream()), (String)uri, (Locale)Locale.US);
            if (!romeEntry.isMediaEntry()) {
                ClientEntry clientEntry = new ClientEntry(this.service, this, romeEntry, false);
                return clientEntry;
            }
            ClientMediaEntry clientMediaEntry = new ClientMediaEntry(this.service, this, romeEntry, false);
            return clientMediaEntry;
        }
        catch (Exception e) {
            throw new ProponoException("ERROR: getting or parsing entry/media, HTTP code: ", e);
        }
        finally {
            method.releaseConnection();
        }
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public boolean isWritable() {
        return true;
    }

    public ClientEntry createEntry() throws ProponoException {
        if (!this.isWritable()) {
            throw new ProponoException("Collection is not writable");
        }
        return new ClientEntry(this.service, this);
    }

    public ClientMediaEntry createMediaEntry(String title, String slug, String contentType, byte[] bytes) throws ProponoException {
        if (!this.isWritable()) {
            throw new ProponoException("Collection is not writable");
        }
        return new ClientMediaEntry(this.service, this, title, slug, contentType, bytes);
    }

    public ClientMediaEntry createMediaEntry(String title, String slug, String contentType, InputStream is) throws ProponoException {
        if (!this.isWritable()) {
            throw new ProponoException("Collection is not writable");
        }
        return new ClientMediaEntry(this.service, this, title, slug, contentType, is);
    }

    public void addEntry(ClientEntry entry) throws ProponoException {
        if (!this.isWritable()) {
            throw new ProponoException("Collection is not writable");
        }
        entry.addToCollection(this);
    }

    @Override
    protected void parseCollectionElement(Element element) throws ProponoException {
        List acceptElems;
        if (this.workspace == null) {
            return;
        }
        this.setHref(element.getAttribute("href").getValue());
        Element titleElem = element.getChild("title", AtomService.ATOM_FORMAT);
        if (titleElem != null) {
            this.setTitle(titleElem.getText());
            if (titleElem.getAttribute("type", AtomService.ATOM_FORMAT) != null) {
                this.setTitleType(titleElem.getAttribute("type", AtomService.ATOM_FORMAT).getValue());
            }
        }
        if ((acceptElems = element.getChildren("accept", AtomService.ATOM_PROTOCOL)) != null && !acceptElems.isEmpty()) {
            for (Element acceptElem : acceptElems) {
                this.addAccept(acceptElem.getTextTrim());
            }
        }
        List catsElems = element.getChildren("categories", AtomService.ATOM_PROTOCOL);
        for (Element catsElem : catsElems) {
            ClientCategories cats = new ClientCategories(catsElem, this);
            this.addCategories(cats);
        }
    }
}

