/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.opml.io.impl;

import com.rometools.opml.feed.opml.Opml;
import com.rometools.opml.feed.opml.Outline;
import com.rometools.opml.io.impl.OPML10Generator;
import com.rometools.rome.feed.WireFeed;
import com.rometools.rome.io.FeedException;
import com.rometools.rome.io.impl.DateParser;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

public class OPML20Generator
extends OPML10Generator {
    public String getType() {
        return "opml_2.0";
    }

    @Override
    public Document generate(WireFeed feed) throws IllegalArgumentException, FeedException {
        Document document = super.generate(feed);
        document.getRootElement().setAttribute("version", "2.0");
        return document;
    }

    @Override
    protected Element generateHead(Opml opml) {
        Element headElement = super.generateHead(opml);
        if (headElement != null && opml.getDocs() != null) {
            Element docsElement = new Element("docs");
            docsElement.setText(opml.getDocs());
            headElement.addContent((Content)docsElement);
        }
        return headElement;
    }

    @Override
    protected Element generateOutline(Outline outline) {
        Element outlineElement = super.generateOutline(outline);
        if (outline.getCreated() != null) {
            outlineElement.setAttribute("created", DateParser.formatRFC822((Date)outline.getCreated(), (Locale)Locale.US));
        }
        List<String> categories = outline.getCategories();
        String categoryValue = this.generateCategoryValue(categories);
        this.addNotNullAttribute(outlineElement, "category", categoryValue);
        return outlineElement;
    }

    private String generateCategoryValue(Collection<String> categories) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String category : categories) {
            if (category == null || category.trim().isEmpty()) continue;
            if (first) {
                first = false;
            } else {
                builder.append(",");
            }
            builder.append(category.trim());
        }
        if (builder.length() > 0) {
            return builder.toString();
        }
        return null;
    }
}

