/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.opml.feed.synd.impl;

import com.rometools.opml.feed.opml.Attribute;
import com.rometools.opml.feed.opml.Opml;
import com.rometools.opml.feed.opml.Outline;
import com.rometools.opml.feed.synd.impl.TreeCategoryImpl;
import com.rometools.rome.feed.WireFeed;
import com.rometools.rome.feed.synd.Converter;
import com.rometools.rome.feed.synd.SyndCategory;
import com.rometools.rome.feed.synd.SyndCategoryImpl;
import com.rometools.rome.feed.synd.SyndContent;
import com.rometools.rome.feed.synd.SyndContentImpl;
import com.rometools.rome.feed.synd.SyndEntry;
import com.rometools.rome.feed.synd.SyndEntryImpl;
import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.feed.synd.SyndLink;
import com.rometools.rome.feed.synd.SyndLinkImpl;
import com.rometools.rome.feed.synd.SyndPerson;
import com.rometools.rome.feed.synd.SyndPersonImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConverterForOPML10
implements Converter {
    private static final Logger LOG = LoggerFactory.getLogger(ConverterForOPML10.class);
    public static final String URI_TREE = "urn:rome.tree";
    public static final String URI_ATTRIBUTE = "urn:rome.attribute#";

    protected void addOwner(Opml opml, SyndFeed syndFeed) {
        if (opml.getOwnerEmail() != null || opml.getOwnerName() != null) {
            ArrayList<SyndPersonImpl> authors = new ArrayList<SyndPersonImpl>();
            SyndPersonImpl person = new SyndPersonImpl();
            person.setEmail(opml.getOwnerEmail());
            person.setName(opml.getOwnerName());
            authors.add(person);
            syndFeed.setAuthors(authors);
        }
    }

    public void copyInto(WireFeed feed, SyndFeed syndFeed) {
        Opml opml = (Opml)feed;
        syndFeed.setTitle(opml.getTitle());
        this.addOwner(opml, syndFeed);
        syndFeed.setPublishedDate(opml.getModified() != null ? opml.getModified() : opml.getCreated());
        syndFeed.setFeedType(opml.getFeedType());
        syndFeed.setModules(opml.getModules());
        syndFeed.setFeedType(this.getType());
        this.createEntries(new Stack<Integer>(), syndFeed.getEntries(), opml.getOutlines());
    }

    protected void createEntries(Stack<Integer> context, List<SyndEntry> allEntries, List<Outline> outlines) {
        List<Outline> so = Collections.synchronizedList(outlines);
        for (int i = 0; i < so.size(); ++i) {
            this.createEntry(context, allEntries, so.get(i));
        }
    }

    protected SyndEntry createEntry(Stack<Integer> context, List<SyndEntry> allEntries, Outline outline) {
        SyndLinkImpl link;
        SyndEntryImpl entry = new SyndEntryImpl();
        if (outline.getType() != null && outline.getType().equals("rss")) {
            entry.setLink(outline.getHtmlUrl() != null ? outline.getHtmlUrl() : outline.getXmlUrl());
        } else if (outline.getType() != null && outline.getType().equals("link")) {
            entry.setLink(outline.getUrl());
        }
        if (outline.getHtmlUrl() != null) {
            link = new SyndLinkImpl();
            link.setRel("alternate");
            link.setType("text/html");
            link.setHref(outline.getHtmlUrl());
            entry.getLinks().add(link);
            entry.setLink(outline.getHtmlUrl());
        }
        if (outline.getXmlUrl() != null && outline.getType() != null && outline.getType().equalsIgnoreCase("rss")) {
            link = new SyndLinkImpl();
            link.setRel("alternate");
            link.setType("application/rss+xml");
            link.setHref(outline.getXmlUrl());
            entry.getLinks().add(link);
            if (entry.getLink() == null) {
                entry.setLink(outline.getXmlUrl());
            }
        }
        if (outline.getXmlUrl() != null && outline.getType() != null && outline.getType().equalsIgnoreCase("atom")) {
            link = new SyndLinkImpl();
            link.setRel("alternate");
            link.setType("application/atom+xml");
            link.setHref(outline.getXmlUrl());
            entry.getLinks().add(link);
            if (entry.getLink() == null) {
                entry.setLink(outline.getXmlUrl());
            }
        }
        if (outline.getType() != null && outline.getType().equals("rss")) {
            entry.setTitle(outline.getTitle());
        } else {
            entry.setTitle(outline.getText());
        }
        if (outline.getText() == null && entry.getTitle() != null) {
            SyndContentImpl c = new SyndContentImpl();
            c.setValue(outline.getText());
            entry.setDescription((SyndContent)c);
        }
        entry.setPublishedDate(outline.getCreated());
        String nodeName = "node." + outline.hashCode();
        TreeCategoryImpl cat = new TreeCategoryImpl();
        cat.setTaxonomyUri(URI_TREE);
        cat.setName(nodeName);
        entry.getCategories().add(cat);
        if (!context.isEmpty()) {
            Integer parent = context.peek();
            TreeCategoryImpl pcat = new TreeCategoryImpl();
            pcat.setTaxonomyUri(URI_TREE);
            pcat.setName("parent." + parent);
            entry.getCategories().add(pcat);
        }
        List<Attribute> attributes = Collections.synchronizedList(outline.getAttributes());
        for (int i = 0; i < attributes.size(); ++i) {
            Attribute a = attributes.get(i);
            SyndCategoryImpl acat = new SyndCategoryImpl();
            acat.setName(a.getValue());
            acat.setTaxonomyUri(URI_ATTRIBUTE + a.getName());
            entry.getCategories().add(acat);
        }
        entry.setModules(outline.getModules());
        allEntries.add((SyndEntry)entry);
        context.push(outline.hashCode());
        this.createEntries(context, allEntries, outline.getChildren());
        context.pop();
        return entry;
    }

    public WireFeed createRealFeed(SyndFeed syndFeed) {
        int i;
        List entries = Collections.synchronizedList(syndFeed.getEntries());
        HashMap<String, Outline> entriesByNode = new HashMap<String, Outline>();
        ArrayList<OutlineHolder> doAfterPass = new ArrayList<OutlineHolder>();
        ArrayList<Outline> root = new ArrayList<Outline>();
        for (i = 0; i < entries.size(); ++i) {
            SyndEntry entry = (SyndEntry)entries.get(i);
            Outline o = new Outline();
            List cats = Collections.synchronizedList(entry.getCategories());
            boolean parentFound = false;
            StringBuffer category = new StringBuffer();
            for (int j = 0; j < cats.size(); ++j) {
                SyndCategory cat = (SyndCategory)cats.get(j);
                if (cat.getTaxonomyUri() != null && cat.getTaxonomyUri().equals(URI_TREE)) {
                    String nodeVal = cat.getName().substring(cat.getName().lastIndexOf("."), cat.getName().length());
                    if (cat.getName().startsWith("node.")) {
                        entriesByNode.put(nodeVal, o);
                        continue;
                    }
                    if (!cat.getName().startsWith("parent.")) continue;
                    parentFound = true;
                    Outline parent = (Outline)entriesByNode.get(nodeVal);
                    if (parent != null) {
                        parent.getChildren().add(o);
                        continue;
                    }
                    doAfterPass.add(new OutlineHolder(o, nodeVal));
                    continue;
                }
                if (cat.getTaxonomyUri() != null && cat.getTaxonomyUri().startsWith(URI_ATTRIBUTE)) {
                    String name = cat.getTaxonomyUri().substring(cat.getTaxonomyUri().indexOf("#") + 1, cat.getTaxonomyUri().length());
                    o.getAttributes().add(new Attribute(name, cat.getName()));
                    continue;
                }
                if (category.length() > 0) {
                    category.append(", ");
                }
                category.append(cat.getName());
            }
            if (!parentFound) {
                root.add(o);
            }
            if (category.length() > 0) {
                o.getAttributes().add(new Attribute("category", category.toString()));
            }
            List links = Collections.synchronizedList(entry.getLinks());
            for (int j = 0; j < links.size(); ++j) {
                SyndLink link = (SyndLink)links.get(j);
                if (link.getType() != null && link.getRel() != null && link.getRel().equals("alternate") && (link.getType().equals("application/rss+xml") || link.getType().equals("application/atom+xml"))) {
                    o.setType("rss");
                    if (o.getXmlUrl() != null) continue;
                    o.getAttributes().add(new Attribute("xmlUrl", link.getHref()));
                    continue;
                }
                if (link.getType() != null && link.getType().equals("text/html")) {
                    if (o.getHtmlUrl() != null) continue;
                    o.getAttributes().add(new Attribute("htmlUrl", link.getHref()));
                    continue;
                }
                o.setType(link.getType());
            }
            if (o.getType() == null || o.getType().equals("link")) {
                o.setText(entry.getTitle());
            } else {
                o.setTitle(entry.getTitle());
            }
            if (o.getText() != null || entry.getDescription() == null) continue;
            o.setText(entry.getDescription().getValue());
        }
        for (i = 0; i < doAfterPass.size(); ++i) {
            OutlineHolder o = (OutlineHolder)doAfterPass.get(i);
            Outline parent = (Outline)entriesByNode.get(o.parent);
            if (parent == null) {
                root.add(o.outline);
                LOG.warn("Unable to find parent node: {}", (Object)o.parent);
                continue;
            }
            parent.getChildren().add(o.outline);
        }
        Opml opml = new Opml();
        opml.setFeedType(this.getType());
        opml.setCreated(syndFeed.getPublishedDate());
        opml.setTitle(syndFeed.getTitle());
        List authors = Collections.synchronizedList(syndFeed.getAuthors());
        for (int i2 = 0; i2 < authors.size(); ++i2) {
            SyndPerson p = (SyndPerson)authors.get(i2);
            if (syndFeed.getAuthor() != null && !syndFeed.getAuthor().equals(p.getName())) continue;
            opml.setOwnerName(p.getName());
            opml.setOwnerEmail(p.getEmail());
            opml.setOwnerId(p.getUri());
        }
        opml.setOutlines(root);
        return opml;
    }

    public String getType() {
        return "opml_1.0";
    }

    private static class OutlineHolder {
        private final Outline outline;
        private final String parent;

        public OutlineHolder(Outline outline, String parent) {
            this.outline = outline;
            this.parent = parent;
        }
    }
}

