/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.opml.feed.opml;

import com.rometools.opml.feed.opml.Attribute;
import com.rometools.rome.feed.impl.EqualsBean;
import com.rometools.rome.feed.impl.ToStringBean;
import com.rometools.rome.feed.module.Module;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class Outline
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private Date created;
    private List<Attribute> attributes;
    private List<String> categories;
    private List<Outline> children;
    private List<Module> modules;
    private String text;
    private String title;
    private String type;
    private boolean breakpoint;
    private boolean comment;

    public Outline() {
    }

    public Outline(String type, String text) {
        this.setType(type);
        this.setText(text);
    }

    public Outline(String title, URL xmlUrl, URL htmlUrl) {
        this.setType("rss");
        this.setTitle(title);
        this.setAttributes(new ArrayList<Attribute>());
        if (xmlUrl != null) {
            this.getAttributes().add(new Attribute("xmlUrl", xmlUrl.toString()));
        }
        if (htmlUrl != null) {
            this.getAttributes().add(new Attribute("htmlUrl", htmlUrl.toString()));
        }
    }

    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    public List<Attribute> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new ArrayList<Attribute>();
        }
        return this.attributes;
    }

    public void setBreakpoint(boolean breakpoint) {
        this.breakpoint = breakpoint;
    }

    public boolean isBreakpoint() {
        return this.breakpoint;
    }

    public void setCategories(List<String> categories) {
        this.categories = categories;
    }

    public List<String> getCategories() {
        if (this.categories == null) {
            this.categories = new ArrayList<String>();
        }
        return this.categories;
    }

    public void setChildren(List<Outline> children) {
        this.children = children;
    }

    public List<Outline> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<Outline>();
        }
        return this.children;
    }

    public void setComment(boolean comment) {
        this.comment = comment;
    }

    public boolean isComment() {
        return this.comment;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Date getCreated() {
        return this.created;
    }

    public String getUrl() {
        return this.getAttributeValue("url");
    }

    public String getHtmlUrl() {
        return this.getAttributeValue("htmlUrl");
    }

    public void setModules(List<Module> modules) {
        this.modules = modules;
    }

    public List<Module> getModules() {
        if (this.modules == null) {
            this.modules = new ArrayList<Module>();
        }
        return this.modules;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public String getXmlUrl() {
        return this.getAttributeValue("xmlUrl");
    }

    public String getAttributeValue(String name) {
        List<Attribute> attributes = Collections.synchronizedList(this.getAttributes());
        for (int i = 0; i < attributes.size(); ++i) {
            Attribute a = attributes.get(i);
            if (a.getName() == null || !a.getName().equals(name)) continue;
            return a.getValue();
        }
        return null;
    }

    public Object clone() {
        Outline o = new Outline();
        o.setBreakpoint(this.isBreakpoint());
        o.setCategories(new ArrayList<String>(this.getCategories()));
        o.setComment(this.isComment());
        o.setCreated(this.created != null ? (Date)this.created.clone() : null);
        o.setModules(new ArrayList<Module>(this.getModules()));
        o.setText(this.getText());
        o.setTitle(this.getTitle());
        o.setType(this.getType());
        ArrayList<Outline> children = new ArrayList<Outline>();
        for (int i = 0; i < this.getChildren().size(); ++i) {
            children.add((Outline)this.children.get(i).clone());
        }
        o.setChildren(children);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (int i = 0; i < this.getAttributes().size(); ++i) {
            attributes.add((Attribute)this.attributes.get(i).clone());
        }
        o.setAttributes(attributes);
        return o;
    }

    public boolean equals(Object obj) {
        return new EqualsBean(Outline.class, (Object)this).beanEquals(obj);
    }

    public int hashCode() {
        return new EqualsBean(Outline.class, (Object)this).beanHashCode();
    }

    public String toString() {
        return new ToStringBean(Outline.class, (Object)this).toString();
    }
}

