/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.opml.io.impl;

import com.rometools.opml.feed.opml.Attribute;
import com.rometools.opml.feed.opml.Opml;
import com.rometools.opml.feed.opml.Outline;
import com.rometools.rome.feed.WireFeed;
import com.rometools.rome.io.FeedException;
import com.rometools.rome.io.WireFeedGenerator;
import com.rometools.rome.io.impl.BaseWireFeedGenerator;
import com.rometools.rome.io.impl.DateParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

public class OPML10Generator
extends BaseWireFeedGenerator
implements WireFeedGenerator {
    public OPML10Generator() {
        super("opml_1.0");
    }

    public OPML10Generator(String type) {
        super(type);
    }

    public Document generate(WireFeed feed) throws IllegalArgumentException, FeedException {
        if (!(feed instanceof Opml)) {
            throw new IllegalArgumentException("Not an OPML file");
        }
        Opml opml = (Opml)feed;
        Document doc = new Document();
        Element root = new Element("opml");
        doc.addContent((Content)root);
        Element head = this.generateHead(opml);
        if (head != null) {
            root.addContent((Content)head);
        }
        Element body = new Element("body");
        root.addContent((Content)body);
        super.generateFeedModules(opml.getModules(), root);
        body.addContent(this.generateOutlines(opml.getOutlines()));
        return doc;
    }

    protected boolean addNotNullAttribute(Element target, String name, Object value) {
        if (target == null || name == null || value == null) {
            return false;
        }
        target.setAttribute(name, value.toString());
        return true;
    }

    protected boolean addNotNullSimpleElement(Element target, String name, Object value) {
        if (target == null || name == null || value == null) {
            return false;
        }
        Element e = new Element(name);
        e.addContent(value.toString());
        target.addContent((Content)e);
        return true;
    }

    protected Element generateHead(Opml opml) {
        Element head = new Element("head");
        boolean hasHead = false;
        if (opml.getCreated() != null) {
            hasHead = this.addNotNullSimpleElement(head, "dateCreated", DateParser.formatRFC822((Date)opml.getCreated(), (Locale)Locale.US));
        }
        hasHead = this.addNotNullSimpleElement(head, "expansionState", this.intArrayToCsvString(opml.getExpansionState()));
        if (opml.getModified() != null) {
            hasHead = this.addNotNullSimpleElement(head, "dateModified", DateParser.formatRFC822((Date)opml.getModified(), (Locale)Locale.US));
        }
        hasHead = this.addNotNullSimpleElement(head, "ownerEmail", opml.getOwnerEmail());
        hasHead = this.addNotNullSimpleElement(head, "ownerName", opml.getOwnerName());
        hasHead = this.addNotNullSimpleElement(head, "title", opml.getTitle());
        hasHead = this.addNotNullSimpleElement(head, "vertScrollState", opml.getVerticalScrollState());
        hasHead = this.addNotNullSimpleElement(head, "windowBottom", opml.getWindowBottom());
        hasHead = this.addNotNullSimpleElement(head, "windowLeft", opml.getWindowLeft());
        hasHead = this.addNotNullSimpleElement(head, "windowRight", opml.getWindowRight());
        hasHead = this.addNotNullSimpleElement(head, "windowTop", opml.getWindowTop());
        if (hasHead) {
            return head;
        }
        return null;
    }

    protected Element generateOutline(Outline outline) {
        Element e = new Element("outline");
        this.addNotNullAttribute(e, "text", outline.getText());
        this.addNotNullAttribute(e, "type", outline.getType());
        this.addNotNullAttribute(e, "title", outline.getTitle());
        if (outline.isBreakpoint()) {
            this.addNotNullAttribute(e, "isBreakpoint", "true");
        }
        if (outline.isComment()) {
            this.addNotNullAttribute(e, "isComment", "true");
        }
        List<Attribute> atts = Collections.synchronizedList(outline.getAttributes());
        for (int i = 0; i < atts.size(); ++i) {
            Attribute att = atts.get(i);
            this.addNotNullAttribute(e, att.getName(), att.getValue());
        }
        super.generateItemModules(outline.getModules(), e);
        e.addContent(this.generateOutlines(outline.getChildren()));
        return e;
    }

    protected List<Element> generateOutlines(List<Outline> outlines) {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (int i = 0; outlines != null && i < outlines.size(); ++i) {
            elements.add(this.generateOutline(outlines.get(i)));
        }
        return elements;
    }

    protected String intArrayToCsvString(int[] value) {
        if (value == null || value.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(value[0]);
        for (int i = 1; i < value.length; ++i) {
            sb.append(",");
            sb.append(value[i]);
        }
        return sb.toString();
    }
}

