/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.opml.io.impl;

import com.rometools.opml.feed.opml.Opml;
import com.rometools.opml.feed.opml.Outline;
import com.rometools.opml.io.impl.OPML10Generator;
import com.rometools.rome.feed.WireFeed;
import com.rometools.rome.io.FeedException;
import com.rometools.rome.io.impl.DateParser;
import java.util.Date;
import java.util.Locale;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

public class OPML20Generator
extends OPML10Generator {
    public String getType() {
        return "opml_2.0";
    }

    @Override
    public Document generate(WireFeed feed) throws IllegalArgumentException, FeedException {
        Document retValue = super.generate(feed);
        retValue.getRootElement().setAttribute("version", "2.0");
        return retValue;
    }

    @Override
    protected Element generateHead(Opml opml) {
        Element retValue = super.generateHead(opml);
        Element docs = new Element("docs", opml.getDocs());
        retValue.addContent((Content)docs);
        return retValue;
    }

    @Override
    protected Element generateOutline(Outline outline) {
        Element retValue = super.generateOutline(outline);
        if (outline.getCreated() != null) {
            retValue.setAttribute("created", DateParser.formatRFC822((Date)outline.getCreated(), (Locale)Locale.US));
        }
        return retValue;
    }
}

