/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.opml.feed.opml;

import com.rometools.opml.feed.opml.Attribute;
import com.rometools.rome.feed.impl.EqualsBean;
import com.rometools.rome.feed.impl.ToStringBean;
import com.rometools.rome.feed.module.Module;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class Outline
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private Date _created;
    private List<Attribute> _attributes;
    private List<String> _categories;
    private List<Outline> _children;
    private List<Module> _modules;
    private String _text;
    private String _title;
    private String _type;
    private boolean _breakpoint;
    private boolean _comment;

    public Outline() {
    }

    public Outline(String type, String text) {
        this.setType(type);
        this.setText(text);
    }

    public Outline(String title, URL xmlUrl, URL htmlUrl) {
        this.setType("rss");
        this.setTitle(title);
        this.setAttributes(new ArrayList<Attribute>());
        if (xmlUrl != null) {
            this.getAttributes().add(new Attribute("xmlUrl", xmlUrl.toString()));
        }
        if (htmlUrl != null) {
            this.getAttributes().add(new Attribute("htmlUrl", htmlUrl.toString()));
        }
    }

    public void setAttributes(List<Attribute> attributes) {
        this._attributes = attributes;
    }

    public List<Attribute> getAttributes() {
        if (this._attributes == null) {
            this._attributes = new ArrayList<Attribute>();
        }
        return this._attributes;
    }

    public void setBreakpoint(boolean breakpoint) {
        this._breakpoint = breakpoint;
    }

    public boolean isBreakpoint() {
        return this._breakpoint;
    }

    public void setCategories(List<String> categories) {
        this._categories = categories;
    }

    public List<String> getCategories() {
        if (this._categories == null) {
            this._categories = new ArrayList<String>();
        }
        return this._categories;
    }

    public void setChildren(List<Outline> children) {
        this._children = children;
    }

    public List<Outline> getChildren() {
        if (this._children == null) {
            this._children = new ArrayList<Outline>();
        }
        return this._children;
    }

    public void setComment(boolean comment) {
        this._comment = comment;
    }

    public boolean isComment() {
        return this._comment;
    }

    public void setCreated(Date created) {
        this._created = created;
    }

    public Date getCreated() {
        return this._created;
    }

    public String getUrl() {
        return this.getAttributeValue("url");
    }

    public String getHtmlUrl() {
        return this.getAttributeValue("htmlUrl");
    }

    public void setModules(List<Module> modules) {
        this._modules = modules;
    }

    public List<Module> getModules() {
        if (this._modules == null) {
            this._modules = new ArrayList<Module>();
        }
        return this._modules;
    }

    public void setText(String text) {
        this._text = text;
    }

    public String getText() {
        return this._text;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public String getTitle() {
        return this._title;
    }

    public void setType(String type) {
        this._type = type;
    }

    public String getType() {
        return this._type;
    }

    public String getXmlUrl() {
        return this.getAttributeValue("xmlUrl");
    }

    public String getAttributeValue(String name) {
        List<Attribute> attributes = Collections.synchronizedList(this.getAttributes());
        for (int i = 0; i < attributes.size(); ++i) {
            Attribute a = attributes.get(i);
            if (a.getName() == null || !a.getName().equals(name)) continue;
            return a.getValue();
        }
        return null;
    }

    public Object clone() {
        Outline o = new Outline();
        o.setBreakpoint(this.isBreakpoint());
        o.setCategories(new ArrayList<String>(this.getCategories()));
        o.setComment(this.isComment());
        o.setCreated(this._created != null ? (Date)this._created.clone() : null);
        o.setModules(new ArrayList<Module>(this.getModules()));
        o.setText(this.getText());
        o.setTitle(this.getTitle());
        o.setType(this.getType());
        ArrayList<Outline> children = new ArrayList<Outline>();
        for (int i = 0; i < this.getChildren().size(); ++i) {
            children.add((Outline)this._children.get(i).clone());
        }
        o.setChildren(children);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (int i = 0; i < this.getAttributes().size(); ++i) {
            attributes.add((Attribute)this._attributes.get(i).clone());
        }
        o.setAttributes(attributes);
        return o;
    }

    public boolean equals(Object obj) {
        EqualsBean eBean = new EqualsBean(Outline.class, (Object)this);
        return eBean.beanEquals(obj);
    }

    public int hashCode() {
        EqualsBean equals = new EqualsBean(Outline.class, (Object)this);
        return equals.beanHashCode();
    }

    public String toString() {
        ToStringBean tsBean = new ToStringBean(Outline.class, (Object)this);
        return tsBean.toString();
    }
}

