/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.atom.modules;

import com.rometools.modules.atom.modules.AtomLinkModule;
import com.rometools.rome.feed.CopyFrom;
import com.rometools.rome.feed.atom.Link;
import com.rometools.rome.feed.impl.EqualsBean;
import com.rometools.rome.feed.impl.ToStringBean;
import com.rometools.rome.feed.synd.SyndPerson;
import com.rometools.rome.feed.synd.SyndPersonImpl;
import java.util.LinkedList;
import java.util.List;

public class AtomLinkModuleImpl
implements AtomLinkModule {
    private List<Link> links = new LinkedList<Link>();
    private List<SyndPerson> authors = new LinkedList<SyndPerson>();
    private List<SyndPerson> contributors = new LinkedList<SyndPerson>();

    @Override
    public List<Link> getLinks() {
        return this.links;
    }

    @Override
    public Link getLink() {
        if (this.links.size() > 0) {
            return this.links.get(0);
        }
        return null;
    }

    @Override
    public void setLinks(List<Link> links) {
        this.links = links;
    }

    @Override
    public void setLink(Link link) {
        if (this.links.size() > 0) {
            this.links.set(0, link);
        } else {
            this.links.add(link);
        }
    }

    @Override
    public List<SyndPerson> getAuthors() {
        return this.authors;
    }

    @Override
    public void setAuthors(List<SyndPerson> authors) {
        this.authors = authors;
    }

    @Override
    public List<SyndPerson> getContributors() {
        return this.contributors;
    }

    @Override
    public void setContributors(List<SyndPerson> contributors) {
        this.contributors = contributors;
    }

    public String getUri() {
        return "http://www.w3.org/2005/Atom";
    }

    public Class<? extends CopyFrom> getInterface() {
        return AtomLinkModule.class;
    }

    public void copyFrom(CopyFrom obj) {
        AtomLinkModule other = (AtomLinkModule)obj;
        this.copyLinks(other.getLinks(), this.links);
        this.copyPerson(other.getAuthors(), this.authors);
        this.copyPerson(other.getContributors(), this.contributors);
    }

    private void copyLinks(List<Link> from, List<Link> to) {
        for (Link link : from) {
            Link l = new Link();
            l.setHref(link.getHref());
            l.setType(link.getType());
            l.setRel(link.getRel());
            l.setHreflang(link.getHreflang());
            l.setTitle(link.getTitle());
            l.setLength(link.getLength());
            to.add(l);
        }
    }

    private void copyPerson(List<SyndPerson> from, List<SyndPerson> to) {
        for (SyndPerson person : from) {
            SyndPersonImpl p = new SyndPersonImpl();
            p.setName(person.getName());
            p.setEmail(person.getEmail());
            p.setUri(person.getUri());
            to.add((SyndPerson)p);
        }
    }

    public Object clone() {
        AtomLinkModuleImpl m = new AtomLinkModuleImpl();
        LinkedList<Link> linksCopy = new LinkedList<Link>();
        this.copyLinks(this.getLinks(), linksCopy);
        m.setLinks(linksCopy);
        LinkedList<SyndPerson> authorsCopy = new LinkedList<SyndPerson>();
        this.copyPerson(this.getAuthors(), authorsCopy);
        m.setAuthors(authorsCopy);
        LinkedList<SyndPerson> contributorsCopy = new LinkedList<SyndPerson>();
        this.copyPerson(this.getContributors(), contributorsCopy);
        m.setContributors(contributorsCopy);
        return m;
    }

    public boolean equals(Object obj) {
        return EqualsBean.beanEquals(AtomLinkModuleImpl.class, (Object)this, (Object)obj);
    }

    public int hashCode() {
        return EqualsBean.beanHashCode((Object)this);
    }

    public String toString() {
        return ToStringBean.toString(AtomLinkModuleImpl.class, (Object)this);
    }
}

