/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.itunes.io;

import com.rometools.modules.itunes.AbstractITunesObject;
import com.rometools.modules.itunes.EntryInformationImpl;
import com.rometools.modules.itunes.FeedInformationImpl;
import com.rometools.modules.itunes.types.Category;
import com.rometools.modules.itunes.types.Duration;
import com.rometools.modules.itunes.types.Subcategory;
import com.rometools.rome.feed.module.Module;
import com.rometools.rome.io.ModuleParser;
import com.rometools.rome.io.WireFeedParser;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITunesParser
implements ModuleParser {
    private static final Logger LOG = LoggerFactory.getLogger(ITunesParser.class);
    Namespace ns = Namespace.getNamespace((String)"http://www.itunes.com/dtds/podcast-1.0.dtd");

    public void setParser(WireFeedParser feedParser) {
    }

    public String getNamespaceUri() {
        return "http://www.itunes.com/dtds/podcast-1.0.dtd";
    }

    public Module parse(Element element, Locale locale) {
        AbstractITunesObject module = null;
        if (element.getName().equals("channel")) {
            Element type;
            Element newFeedUrl;
            FeedInformationImpl feedInfo = new FeedInformationImpl();
            module = feedInfo;
            Element owner = element.getChild("owner", this.ns);
            if (owner != null) {
                Element email;
                Element name = owner.getChild("name", this.ns);
                if (name != null) {
                    feedInfo.setOwnerName(name.getValue().trim());
                }
                if ((email = owner.getChild("email", this.ns)) != null) {
                    feedInfo.setOwnerEmailAddress(email.getValue().trim());
                }
            }
            List categories = element.getChildren("category", this.ns);
            for (Element element2 : categories) {
                Element category = element2;
                if (category == null || category.getAttribute("text") == null) continue;
                Category cat = new Category();
                cat.setName(category.getAttribute("text").getValue().trim());
                List subCategories = category.getChildren("category", this.ns);
                for (Element subCategory : subCategories) {
                    if (subCategory.getAttribute("text") == null) continue;
                    Subcategory subcat = new Subcategory();
                    subcat.setName(subCategory.getAttribute("text").getValue().trim());
                    cat.addSubcategory(subcat);
                }
                feedInfo.getCategories().add(cat);
            }
            Element complete = element.getChild("complete", this.ns);
            if (complete != null) {
                feedInfo.setComplete("yes".equals(complete.getTextTrim().toLowerCase()));
            }
            if ((newFeedUrl = element.getChild("new-feed-url", this.ns)) != null) {
                feedInfo.setNewFeedUrl(newFeedUrl.getTextTrim());
            }
            if ((type = element.getChild("type", this.ns)) != null) {
                feedInfo.setType(type.getTextTrim());
            }
        } else if (element.getName().equals("item")) {
            Element episodeType;
            Element episode;
            Element season;
            Element order;
            Element closedCaptioned;
            EntryInformationImpl entryInfo = new EntryInformationImpl();
            module = entryInfo;
            Element duration = element.getChild("duration", this.ns);
            if (duration != null && duration.getValue() != null) {
                try {
                    Duration dur = new Duration(duration.getValue().trim());
                    entryInfo.setDuration(dur);
                }
                catch (Exception e) {
                    LOG.warn("Failed to parse duration: {}", (Object)duration.getValue());
                }
            }
            if ((closedCaptioned = element.getChild("isClosedCaptioned", this.ns)) != null && closedCaptioned.getValue() != null && closedCaptioned.getValue().trim().equalsIgnoreCase("yes")) {
                entryInfo.setClosedCaptioned(true);
            }
            if ((order = element.getChild("order", this.ns)) != null && order.getValue() != null) {
                Integer o = Integer.valueOf(order.getValue().trim());
                entryInfo.setOrder(o);
            }
            if ((season = element.getChild("season", this.ns)) != null && season.getValue() != null) {
                Integer o = Integer.valueOf(season.getValue().trim());
                entryInfo.setSeason(o);
            }
            if ((episode = element.getChild("episode", this.ns)) != null && episode.getValue() != null) {
                Integer o = Integer.valueOf(episode.getValue().trim());
                entryInfo.setEpisode(o);
            }
            if ((episodeType = element.getChild("episodeType", this.ns)) != null && episodeType.getValue() != null) {
                entryInfo.setEpisodeType(episodeType.getTextTrim());
            }
        }
        if (module != null) {
            Element image;
            Element summary;
            Element subtitle;
            Element keywords;
            Element explicit;
            Element block;
            Element author = element.getChild("author", this.ns);
            if (author != null && author.getText() != null) {
                module.setAuthor(author.getText());
            }
            if ((block = element.getChild("block", this.ns)) != null) {
                module.setBlock(true);
            }
            if ((explicit = element.getChild("explicit", this.ns)) != null && explicit.getValue() != null && explicit.getValue().trim().equalsIgnoreCase("yes")) {
                module.setExplicit(true);
            }
            if ((keywords = element.getChild("keywords", this.ns)) != null) {
                StringTokenizer tok = new StringTokenizer(this.getXmlInnerText(keywords).trim(), ",");
                String[] keywordsArray = new String[tok.countTokens()];
                int i = 0;
                while (tok.hasMoreTokens()) {
                    keywordsArray[i] = tok.nextToken();
                    ++i;
                }
                module.setKeywords(keywordsArray);
            }
            if ((subtitle = element.getChild("subtitle", this.ns)) != null) {
                module.setSubtitle(subtitle.getTextTrim());
            }
            if ((summary = element.getChild("summary", this.ns)) != null) {
                module.setSummary(summary.getTextTrim());
            }
            if ((image = element.getChild("image", this.ns)) != null && image.getAttributeValue("href") != null) {
                try {
                    URL imageURL = new URL(image.getAttributeValue("href").trim());
                    module.setImage(imageURL);
                }
                catch (MalformedURLException e) {
                    LOG.warn("Malformed URL Exception reading itunes:image tag: {}", (Object)image.getAttributeValue("href"));
                }
            }
        }
        return module;
    }

    protected String getXmlInnerText(Element e) {
        StringBuffer sb = new StringBuffer();
        XMLOutputter xo = new XMLOutputter();
        List children = e.getContent();
        sb.append(xo.outputString(children));
        return sb.toString();
    }
}

