/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.content.io;

import com.rometools.modules.content.ContentItem;
import com.rometools.modules.content.ContentModule;
import com.rometools.rome.feed.module.Module;
import com.rometools.rome.io.ModuleGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom2.Attribute;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentModuleGenerator
implements ModuleGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(ContentModuleGenerator.class);
    private static final Namespace CONTENT_NS = Namespace.getNamespace((String)"content", (String)"http://purl.org/rss/1.0/modules/content/");
    private static final Namespace RDF_NS = Namespace.getNamespace((String)"rdf", (String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#");
    private static final Set<Namespace> NAMESPACES;

    public void generate(Module module, Element element) {
        List<ContentItem> contentItems;
        Element root = element;
        while (root.getParent() != null && root.getParent() instanceof Element) {
            root = (Element)root.getParent();
        }
        root.addNamespaceDeclaration(CONTENT_NS);
        if (!(module instanceof ContentModule)) {
            return;
        }
        ContentModule cm = (ContentModule)module;
        List<String> encodeds = cm.getEncodeds();
        if (encodeds != null) {
            LOG.debug("{}", (Object)cm.getEncodeds().size());
            for (int i = 0; i < encodeds.size(); ++i) {
                element.addContent((Content)this.generateCDATAElement("encoded", encodeds.get(i).toString()));
            }
        }
        if ((contentItems = cm.getContentItems()) != null && !contentItems.isEmpty()) {
            Element items = new Element("items", CONTENT_NS);
            Element bag = new Element("Bag", RDF_NS);
            items.addContent((Content)bag);
            for (int i = 0; i < contentItems.size(); ++i) {
                ContentItem contentItem = contentItems.get(i);
                Element li = new Element("li", RDF_NS);
                Element item = new Element("item", CONTENT_NS);
                if (contentItem.getContentAbout() != null) {
                    Attribute about = new Attribute("about", contentItem.getContentAbout(), RDF_NS);
                    item.setAttribute(about);
                }
                if (contentItem.getContentFormat() != null) {
                    Element format = new Element("format", CONTENT_NS);
                    Attribute formatResource = new Attribute("resource", contentItem.getContentFormat(), RDF_NS);
                    format.setAttribute(formatResource);
                    item.addContent((Content)format);
                }
                if (contentItem.getContentEncoding() != null) {
                    Element encoding = new Element("encoding", CONTENT_NS);
                    Attribute encodingResource = new Attribute("resource", contentItem.getContentEncoding(), RDF_NS);
                    encoding.setAttribute(encodingResource);
                    item.addContent((Content)encoding);
                }
                if (contentItem.getContentValue() != null) {
                    Element value = new Element("value", RDF_NS);
                    if (contentItem.getContentValueParseType() != null) {
                        Attribute parseType = new Attribute("parseType", contentItem.getContentValueParseType(), RDF_NS);
                        value.setAttribute(parseType);
                    }
                    if (contentItem.getContentValueNamespaces() != null) {
                        List<Namespace> namespaces = contentItem.getContentValueNamespaces();
                        for (int ni = 0; ni < namespaces.size(); ++ni) {
                            value.addNamespaceDeclaration(namespaces.get(ni));
                        }
                    }
                    ArrayList<Content> detached = new ArrayList<Content>();
                    for (int c = 0; c < contentItem.getContentValueDOM().size(); ++c) {
                        detached.add(contentItem.getContentValueDOM().get(c).clone().detach());
                    }
                    value.setContent(detached);
                    item.addContent((Content)value);
                }
                li.addContent((Content)item);
                bag.addContent((Content)li);
            }
            element.addContent((Content)items);
        }
    }

    protected Element generateSimpleElement(String name, String value) {
        Element element = new Element(name, CONTENT_NS);
        element.addContent(value);
        return element;
    }

    protected Element generateCDATAElement(String name, String value) {
        Element element = new Element(name, CONTENT_NS);
        CDATA cdata = new CDATA(value);
        element.addContent((Content)cdata);
        return element;
    }

    public String getNamespaceUri() {
        return "http://purl.org/rss/1.0/modules/content/";
    }

    public Set<Namespace> getNamespaces() {
        return NAMESPACES;
    }

    static {
        HashSet<Namespace> nss = new HashSet<Namespace>();
        nss.add(CONTENT_NS);
        NAMESPACES = Collections.unmodifiableSet(nss);
    }
}

