/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.georss;

import com.rometools.modules.georss.GeoRSSModule;
import com.rometools.modules.georss.geometries.AbstractGeometry;
import com.rometools.modules.georss.geometries.Point;
import com.rometools.modules.georss.geometries.Position;
import com.rometools.rome.feed.module.Module;
import com.rometools.rome.io.ModuleGenerator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class W3CGeoGenerator
implements ModuleGenerator {
    private static boolean isShort = true;
    private static final Set<Namespace> NAMESPACES;

    public static void enableDefaultPointElement() {
        isShort = false;
    }

    public String getNamespaceUri() {
        return "http://www.w3.org/2003/01/geo/wgs84_pos#";
    }

    public Set<Namespace> getNamespaces() {
        return NAMESPACES;
    }

    public void generate(Module module, Element element) {
        GeoRSSModule geoRSSModule;
        AbstractGeometry geometry;
        Element root = element;
        while (root.getParent() != null && root.getParent() instanceof Element) {
            root = (Element)element.getParent();
        }
        root.addNamespaceDeclaration(GeoRSSModule.W3CGEO_NS);
        Element pointElement = element;
        if (!isShort) {
            pointElement = new Element("Point", GeoRSSModule.W3CGEO_NS);
            element.addContent((Content)pointElement);
        }
        if ((geometry = (geoRSSModule = (GeoRSSModule)module).getGeometry()) instanceof Point) {
            Position pos = ((Point)geometry).getPosition();
            Element latElement = new Element("lat", GeoRSSModule.W3CGEO_NS);
            latElement.addContent(String.valueOf(pos.getLatitude()));
            pointElement.addContent((Content)latElement);
            Element lngElement = new Element("long", GeoRSSModule.W3CGEO_NS);
            lngElement.addContent(String.valueOf(pos.getLongitude()));
            pointElement.addContent((Content)lngElement);
        } else {
            System.err.println("W3C Geo format can't handle geometries of type: " + geometry.getClass().getName());
        }
    }

    static {
        HashSet<Namespace> nss = new HashSet<Namespace>();
        nss.add(GeoRSSModule.W3CGEO_NS);
        NAMESPACES = Collections.unmodifiableSet(nss);
    }
}

