/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.mediarss.io;

import com.rometools.modules.mediarss.MediaEntryModuleImpl;
import com.rometools.modules.mediarss.MediaModuleImpl;
import com.rometools.modules.mediarss.types.Category;
import com.rometools.modules.mediarss.types.Credit;
import com.rometools.modules.mediarss.types.Expression;
import com.rometools.modules.mediarss.types.Hash;
import com.rometools.modules.mediarss.types.MediaContent;
import com.rometools.modules.mediarss.types.MediaGroup;
import com.rometools.modules.mediarss.types.Metadata;
import com.rometools.modules.mediarss.types.PlayerReference;
import com.rometools.modules.mediarss.types.Rating;
import com.rometools.modules.mediarss.types.Restriction;
import com.rometools.modules.mediarss.types.Text;
import com.rometools.modules.mediarss.types.Thumbnail;
import com.rometools.modules.mediarss.types.Time;
import com.rometools.modules.mediarss.types.UrlReference;
import com.rometools.rome.feed.module.Module;
import com.rometools.rome.io.ModuleParser;
import com.rometools.utils.Integers;
import com.rometools.utils.Longs;
import com.rometools.utils.Strings;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaModuleParser
implements ModuleParser {
    private static final Logger LOG = LoggerFactory.getLogger(MediaModuleParser.class);
    private static final Namespace NS = Namespace.getNamespace((String)"http://search.yahoo.com/mrss/");

    public String getNamespaceUri() {
        return "http://search.yahoo.com/mrss/";
    }

    public Module parse(Element mmRoot, Locale locale) {
        MediaModuleImpl mod = null;
        mod = mmRoot.getName().equals("channel") || mmRoot.getName().equals("feed") ? new MediaModuleImpl() : new MediaEntryModuleImpl();
        mod.setMetadata(this.parseMetadata(mmRoot));
        mod.setPlayer(this.parsePlayer(mmRoot));
        if (mod instanceof MediaEntryModuleImpl) {
            MediaEntryModuleImpl m = (MediaEntryModuleImpl)mod;
            m.setMediaContents(this.parseContent(mmRoot));
            m.setMediaGroups(this.parseGroup(mmRoot));
        }
        return mod;
    }

    private MediaContent[] parseContent(Element e) {
        List contents = e.getChildren("content", this.getNS());
        ArrayList<MediaContent> values = new ArrayList<MediaContent>();
        try {
            for (int i = 0; contents != null && i < contents.size(); ++i) {
                Element content = (Element)contents.get(i);
                MediaContent mc = null;
                if (content.getAttributeValue("url") != null) {
                    try {
                        mc = new MediaContent(new UrlReference(new URI(content.getAttributeValue("url").replace(' ', '+'))));
                        mc.setPlayer(this.parsePlayer(content));
                    }
                    catch (Exception ex) {
                        LOG.warn("Exception parsing content tag.", (Throwable)ex);
                    }
                } else {
                    mc = new MediaContent(this.parsePlayer(content));
                }
                if (mc != null) {
                    values.add(mc);
                    try {
                        if (content.getAttributeValue("channels") != null) {
                            mc.setAudioChannels(Integer.valueOf(content.getAttributeValue("channels")));
                        }
                    }
                    catch (Exception ex) {
                        LOG.warn("Exception parsing content tag.", (Throwable)ex);
                    }
                    try {
                        if (content.getAttributeValue("bitrate") != null) {
                            mc.setBitrate(Float.valueOf(content.getAttributeValue("bitrate")));
                        }
                    }
                    catch (Exception ex) {
                        LOG.warn("Exception parsing content tag.", (Throwable)ex);
                    }
                    try {
                        if (content.getAttributeValue("duration") != null) {
                            mc.setDuration(Longs.parseDecimal((String)content.getAttributeValue("duration")));
                        }
                    }
                    catch (Exception ex) {
                        LOG.warn("Exception parsing content tag.", (Throwable)ex);
                    }
                    mc.setMedium(content.getAttributeValue("medium"));
                    String expression = content.getAttributeValue("expression");
                    if (expression != null) {
                        if (expression.equalsIgnoreCase("full")) {
                            mc.setExpression(Expression.FULL);
                        } else if (expression.equalsIgnoreCase("sample")) {
                            mc.setExpression(Expression.SAMPLE);
                        } else if (expression.equalsIgnoreCase("nonstop")) {
                            mc.setExpression(Expression.NONSTOP);
                        }
                    }
                    try {
                        if (content.getAttributeValue("fileSize") != null) {
                            mc.setFileSize(Long.valueOf(content.getAttributeValue("fileSize")));
                        }
                    }
                    catch (Exception ex) {
                        LOG.warn("Exception parsing content tag.", (Throwable)ex);
                    }
                    try {
                        if (content.getAttributeValue("framerate") != null) {
                            mc.setFramerate(Float.valueOf(content.getAttributeValue("framerate")));
                        }
                    }
                    catch (Exception ex) {
                        LOG.warn("Exception parsing content tag.", (Throwable)ex);
                    }
                    try {
                        if (content.getAttributeValue("height") != null) {
                            mc.setHeight(Integer.valueOf(content.getAttributeValue("height")));
                        }
                    }
                    catch (Exception ex) {
                        LOG.warn("Exception parsing content tag.", (Throwable)ex);
                    }
                    mc.setLanguage(content.getAttributeValue("lang"));
                    mc.setMetadata(this.parseMetadata(content));
                    try {
                        if (content.getAttributeValue("samplingrate") != null) {
                            mc.setSamplingrate(Float.valueOf(content.getAttributeValue("samplingrate")));
                        }
                    }
                    catch (Exception ex) {
                        LOG.warn("Exception parsing content tag.", (Throwable)ex);
                    }
                    mc.setType(content.getAttributeValue("type"));
                    try {
                        if (content.getAttributeValue("width") != null) {
                            mc.setWidth(Integer.valueOf(content.getAttributeValue("width")));
                        }
                    }
                    catch (Exception ex) {
                        LOG.warn("Exception parsing content tag.", (Throwable)ex);
                    }
                    if (content.getAttributeValue("isDefault") == null) continue;
                    mc.setDefaultContent(Boolean.valueOf(content.getAttributeValue("isDefault")));
                    continue;
                }
                LOG.warn("Could not find MediaContent.");
            }
        }
        catch (Exception ex) {
            LOG.warn("Exception parsing content tag.", (Throwable)ex);
        }
        return values.toArray(new MediaContent[values.size()]);
    }

    private MediaGroup[] parseGroup(Element e) {
        List groups = e.getChildren("group", this.getNS());
        ArrayList<MediaGroup> values = new ArrayList<MediaGroup>();
        for (int i = 0; groups != null && i < groups.size(); ++i) {
            Element group = (Element)groups.get(i);
            MediaGroup g = new MediaGroup(this.parseContent(group));
            for (int j = 0; j < g.getContents().length; ++j) {
                if (!g.getContents()[j].isDefaultContent()) continue;
                g.setDefaultContentIndex(new Integer(j));
                break;
            }
            g.setMetadata(this.parseMetadata(group));
            values.add(g);
        }
        return values.toArray(new MediaGroup[values.size()]);
    }

    private Metadata parseMetadata(Element e) {
        int i;
        Metadata md = new Metadata();
        List categories = e.getChildren("category", this.getNS());
        ArrayList<Serializable> values = new ArrayList<Serializable>();
        for (i = 0; categories != null && i < categories.size(); ++i) {
            try {
                Element cat = (Element)categories.get(i);
                values.add(new Category(cat.getAttributeValue("scheme"), cat.getAttributeValue("label"), cat.getText()));
                continue;
            }
            catch (Exception ex) {
                LOG.warn("Exception parsing category tag.", (Throwable)ex);
            }
        }
        md.setCategories(values.toArray(new Category[values.size()]));
        try {
            Element copy = e.getChild("copyright", this.getNS());
            if (copy != null) {
                md.setCopyright(copy.getText());
                md.setCopyrightUrl(copy.getAttributeValue("url") != null ? new URI(copy.getAttributeValue("url")) : null);
            }
        }
        catch (Exception ex) {
            LOG.warn("Exception parsing copyright tag.", (Throwable)ex);
        }
        List credits = e.getChildren("credit", this.getNS());
        values = new ArrayList();
        for (i = 0; credits != null && i < credits.size(); ++i) {
            try {
                Element cred = (Element)credits.get(i);
                values.add(new Credit(cred.getAttributeValue("scheme"), cred.getAttributeValue("role"), cred.getText()));
                md.setCredits(values.toArray(new Credit[values.size()]));
                continue;
            }
            catch (Exception ex) {
                LOG.warn("Exception parsing credit tag.", (Throwable)ex);
            }
        }
        try {
            Element description = e.getChild("description", this.getNS());
            if (description != null) {
                md.setDescription(description.getText());
                md.setDescriptionType(description.getAttributeValue("type"));
            }
        }
        catch (Exception ex) {
            LOG.warn("Exception parsing description tag.", (Throwable)ex);
        }
        try {
            Element hash = e.getChild("hash", this.getNS());
            if (hash != null) {
                md.setHash(new Hash(hash.getAttributeValue("algo"), hash.getText()));
            }
        }
        catch (Exception ex) {
            LOG.warn("Exception parsing hash tag.", (Throwable)ex);
        }
        Element keywords = e.getChild("keywords", this.getNS());
        if (keywords != null) {
            StringTokenizer tok = new StringTokenizer(keywords.getText(), ",");
            String[] value = new String[tok.countTokens()];
            int i2 = 0;
            while (tok.hasMoreTokens()) {
                value[i2] = tok.nextToken().trim();
                ++i2;
            }
            md.setKeywords(value);
        }
        ArrayList<Serializable> values2 = new ArrayList<Serializable>();
        List ratings = e.getChildren("rating", this.getNS());
        for (Element ratingElement : ratings) {
            try {
                String ratingText = ratingElement.getText();
                String ratingScheme = Strings.trimToNull((String)ratingElement.getAttributeValue("scheme"));
                if (ratingScheme == null) {
                    ratingScheme = "urn:simple";
                }
                Rating rating = new Rating(ratingScheme, ratingText);
                values2.add(rating);
            }
            catch (Exception ex) {
                LOG.warn("Exception parsing rating tag.", (Throwable)ex);
            }
        }
        md.setRatings(values2.toArray(new Rating[values2.size()]));
        List texts = e.getChildren("text", this.getNS());
        values = new ArrayList();
        for (int i3 = 0; texts != null && i3 < texts.size(); ++i3) {
            try {
                Element text = (Element)texts.get(i3);
                Time start = text.getAttributeValue("start") == null ? null : new Time(text.getAttributeValue("start"));
                Time end = text.getAttributeValue("end") == null ? null : new Time(text.getAttributeValue("end"));
                values.add(new Text(text.getAttributeValue("type"), text.getTextTrim(), start, end));
                continue;
            }
            catch (Exception ex) {
                LOG.warn("Exception parsing text tag.", (Throwable)ex);
            }
        }
        md.setText(values.toArray(new Text[values.size()]));
        values2 = new ArrayList();
        List thumbnails = e.getChildren("thumbnail", this.getNS());
        for (Element thumb : thumbnails) {
            try {
                String timeAttr = Strings.trimToNull((String)thumb.getAttributeValue("time"));
                Time time = null;
                if (timeAttr != null) {
                    time = new Time(timeAttr);
                }
                String widthAttr = thumb.getAttributeValue("width");
                Integer width = Integers.parse((String)widthAttr);
                String heightAttr = thumb.getAttributeValue("height");
                Integer height = Integers.parse((String)heightAttr);
                String url = thumb.getAttributeValue("url");
                URI uri = new URI(url);
                Thumbnail thumbnail = new Thumbnail(uri, width, height, time);
                values2.add(thumbnail);
            }
            catch (Exception ex) {
                LOG.warn("Exception parsing thumbnail tag.", (Throwable)ex);
            }
        }
        md.setThumbnail(values2.toArray(new Thumbnail[values2.size()]));
        Element title = e.getChild("title", this.getNS());
        if (title != null) {
            md.setTitle(title.getText());
            md.setTitleType(title.getAttributeValue("type"));
        }
        List restrictions = e.getChildren("restriction", this.getNS());
        values = new ArrayList();
        for (int i4 = 0; i4 < restrictions.size(); ++i4) {
            Element r = (Element)restrictions.get(i4);
            Restriction.Type type = null;
            if (r.getAttributeValue("type").equalsIgnoreCase("uri")) {
                type = Restriction.Type.URI;
            } else if (r.getAttributeValue("type").equalsIgnoreCase("country")) {
                type = Restriction.Type.COUNTRY;
            }
            Restriction.Relationship relationship = null;
            if (r.getAttributeValue("relationship").equalsIgnoreCase("allow")) {
                relationship = Restriction.Relationship.ALLOW;
            } else if (r.getAttributeValue("relationship").equalsIgnoreCase("deny")) {
                relationship = Restriction.Relationship.DENY;
            }
            Restriction value = new Restriction(relationship, type, r.getTextTrim());
            values.add(value);
        }
        md.setRestrictions(values.toArray(new Restriction[values.size()]));
        Element adult = e.getChild("adult", this.getNS());
        if (adult != null && md.getRatings().length == 0) {
            Rating[] r = new Rating[]{adult.getTextTrim().equals("true") ? new Rating("urn:simple", "adult") : new Rating("urn:simple", "nonadult")};
            md.setRatings(r);
        }
        return md;
    }

    private PlayerReference parsePlayer(Element e) {
        Element player = e.getChild("player", this.getNS());
        PlayerReference p = null;
        if (player != null) {
            Integer width = player.getAttributeValue("width") == null ? null : new Integer(player.getAttributeValue("width"));
            Integer height = player.getAttributeValue("height") == null ? null : new Integer(player.getAttributeValue("height"));
            try {
                p = new PlayerReference(new URI(player.getAttributeValue("url")), width, height);
            }
            catch (Exception ex) {
                LOG.warn("Exception parsing player tag.", (Throwable)ex);
            }
        }
        return p;
    }

    public Namespace getNS() {
        return NS;
    }
}

