/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.sle;

import com.rometools.modules.sle.SleEntry;
import com.rometools.modules.sle.io.LabelNamespaceElement;
import com.rometools.modules.sle.io.ModuleParser;
import com.rometools.modules.sle.types.EntryValue;
import com.rometools.modules.sle.types.Group;
import com.rometools.modules.sle.types.Sort;
import com.rometools.rome.feed.CopyFrom;
import com.rometools.rome.feed.impl.CloneableBean;
import com.rometools.rome.feed.impl.EqualsBean;
import com.rometools.rome.feed.impl.ToStringBean;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SleEntryImpl
implements SleEntry {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(SleEntryImpl.class);
    private static final EntryValue[] EMPTY_VALUES = new EntryValue[0];
    private EntryValue[] groupValues = EMPTY_VALUES;
    private EntryValue[] sortValues = EMPTY_VALUES;

    @Override
    public EntryValue getGroupByElement(Group element) {
        EntryValue[] values = this.getGroupValues();
        LabelNamespaceElement compare = new LabelNamespaceElement(element.getLabel(), element.getNamespace(), element.getElement());
        for (EntryValue value : values) {
            if (!compare.equals(new LabelNamespaceElement(value.getLabel(), value.getNamespace(), value.getElement()))) continue;
            return value;
        }
        return null;
    }

    public void setGroupValues(EntryValue[] groupValues) {
        this.groupValues = groupValues == null ? EMPTY_VALUES : groupValues;
    }

    @Override
    public EntryValue[] getGroupValues() {
        return this.groupValues;
    }

    public Class<SleEntry> getInterface() {
        return SleEntry.class;
    }

    @Override
    public EntryValue getSortByElement(Sort element) {
        LOG.debug("Looking for value for {} from {}", (Object)element.getLabel(), (Object)this.sortValues.length);
        EntryValue[] values = this.getSortValues();
        LabelNamespaceElement compare = new LabelNamespaceElement(element.getLabel(), element.getNamespace(), element.getElement());
        for (EntryValue value : values) {
            LOG.debug("Compare to value {}", (Object)value.getLabel());
            if (!compare.equals(new LabelNamespaceElement(value.getLabel(), value.getNamespace(), value.getElement()))) continue;
            LOG.debug("Match.");
            return value;
        }
        return null;
    }

    public void setSortValues(EntryValue[] sortValues) {
        this.sortValues = sortValues;
    }

    @Override
    public EntryValue[] getSortValues() {
        return this.sortValues;
    }

    public String getUri() {
        return ModuleParser.TEMP.getURI();
    }

    public Object clone() throws CloneNotSupportedException {
        return CloneableBean.beanClone((Object)this, Collections.emptySet());
    }

    public void copyFrom(CopyFrom obj) {
        SleEntry entry = (SleEntry)obj;
        this.setGroupValues((EntryValue[])entry.getGroupValues().clone());
        this.setSortValues((EntryValue[])entry.getSortValues().clone());
    }

    public boolean equals(Object o) {
        return EqualsBean.beanEquals(SleEntryImpl.class, (Object)this, (Object)o);
    }

    public int hashCode() {
        return EqualsBean.beanHashCode((Object)this);
    }

    public String toString() {
        return ToStringBean.toString(SleEntryImpl.class, (Object)this);
    }
}

