/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.yahooweather.io;

import com.rometools.modules.yahooweather.YWeatherModuleImpl;
import com.rometools.modules.yahooweather.types.Forecast;
import com.rometools.rome.feed.module.Module;
import com.rometools.rome.io.ModuleGenerator;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class WeatherModuleGenerator
implements ModuleGenerator {
    private static final Namespace NS = Namespace.getNamespace((String)"yweather", (String)"http://xml.weather.yahoo.com/ns/rss/1.0");
    private static final SimpleDateFormat TIME_ONLY = new SimpleDateFormat("h:mm a", Locale.US);
    private static final SimpleDateFormat LONG_DATE = new SimpleDateFormat("EEE, d MMM yyyy h:mm a zzz", Locale.US);
    private static final SimpleDateFormat SHORT_DATE = new SimpleDateFormat("d MMM yyyy", Locale.US);

    public void generate(Module module, Element element) {
        if (!(module instanceof YWeatherModuleImpl)) {
            return;
        }
        YWeatherModuleImpl weather = (YWeatherModuleImpl)module;
        if (weather.getAstronomy() != null) {
            Element astro = new Element("astronomy", NS);
            if (weather.getAstronomy().getSunrise() != null) {
                astro.setAttribute("sunrise", TIME_ONLY.format(weather.getAstronomy().getSunrise()).toLowerCase());
            }
            if (weather.getAstronomy().getSunrise() != null) {
                astro.setAttribute("sunset", TIME_ONLY.format(weather.getAstronomy().getSunset()).toLowerCase());
            }
            element.addContent((Content)astro);
        }
        if (weather.getAtmosphere() != null) {
            Element atmos = new Element("atmosphere", NS);
            atmos.setAttribute("humidity", Integer.toString(weather.getAtmosphere().getHumidity()));
            atmos.setAttribute("visibility", Integer.toString((int)(weather.getAtmosphere().getVisibility() * 100.0)));
            atmos.setAttribute("pressure", Double.toString(weather.getAtmosphere().getPressure()));
            if (weather.getAtmosphere().getChange() != null) {
                atmos.setAttribute("rising", Integer.toString(weather.getAtmosphere().getChange().getCode()));
            }
            element.addContent((Content)atmos);
        }
        if (weather.getCondition() != null) {
            Element condition = new Element("condition", NS);
            if (weather.getCondition().getText() != null) {
                condition.setAttribute("text", weather.getCondition().getText());
            }
            if (weather.getCondition().getCode() != null) {
                condition.setAttribute("code", Integer.toString(weather.getCondition().getCode().getCode()));
            }
            if (weather.getCondition().getDate() != null) {
                condition.setAttribute("date", LONG_DATE.format(weather.getCondition().getDate()).replaceAll("AM", "am").replaceAll("PM", "pm"));
            }
            condition.setAttribute("temp", Integer.toString(weather.getCondition().getTemperature()));
            element.addContent((Content)condition);
        }
        if (weather.getLocation() != null) {
            Element location = new Element("location", NS);
            if (weather.getLocation().getCity() != null) {
                location.setAttribute("city", weather.getLocation().getCity());
            }
            if (weather.getLocation().getRegion() != null) {
                location.setAttribute("region", weather.getLocation().getRegion());
            }
            if (weather.getLocation().getCountry() != null) {
                location.setAttribute("country", weather.getLocation().getCountry());
            }
            element.addContent((Content)location);
        }
        if (weather.getUnits() != null) {
            Element units = new Element("units", NS);
            if (weather.getUnits().getDistance() != null) {
                units.setAttribute("distance", weather.getUnits().getDistance());
            }
            if (weather.getUnits().getPressure() != null) {
                units.setAttribute("pressure", weather.getUnits().getPressure());
            }
            if (weather.getUnits().getSpeed() != null) {
                units.setAttribute("speed", weather.getUnits().getSpeed());
            }
            if (weather.getUnits().getTemperature() != null) {
                units.setAttribute("temperature", weather.getUnits().getTemperature());
            }
            element.addContent((Content)units);
        }
        if (weather.getWind() != null) {
            Element wind = new Element("wind", NS);
            wind.setAttribute("chill", Integer.toString(weather.getWind().getChill()));
            wind.setAttribute("direction", Integer.toString(weather.getWind().getDirection()));
            wind.setAttribute("speed", Integer.toString(weather.getWind().getSpeed()));
            element.addContent((Content)wind);
        }
        if (weather.getForecasts() != null) {
            for (int i = 0; i < weather.getForecasts().length; ++i) {
                Element forecast = new Element("forecast", NS);
                Forecast f = weather.getForecasts()[i];
                if (f.getCode() != null) {
                    forecast.setAttribute("code", Integer.toString(f.getCode().getCode()));
                }
                if (f.getDate() != null) {
                    forecast.setAttribute("date", SHORT_DATE.format(f.getDate()));
                }
                if (f.getDay() != null) {
                    forecast.setAttribute("day", f.getDay());
                }
                if (f.getText() != null) {
                    forecast.setAttribute("text", f.getText());
                }
                forecast.setAttribute("high", Integer.toString(f.getHigh()));
                forecast.setAttribute("low", Integer.toString(f.getLow()));
                element.addContent((Content)forecast);
            }
        }
    }

    protected Element generateSimpleElement(String name, String value) {
        Element element = new Element(name, NS);
        element.addContent(value);
        return element;
    }

    public Set<Namespace> getNamespaces() {
        HashSet<Namespace> set = new HashSet<Namespace>();
        set.add(NS);
        return set;
    }

    public String getNamespaceUri() {
        return "http://xml.weather.yahoo.com/ns/rss/1.0";
    }
}

