/*
 * Decompiled with CFR 0.152.
 */
package com.rd.utils;

import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.rd.animation.type.AnimationType;
import com.rd.draw.data.Indicator;
import com.rd.draw.data.Orientation;

public class CoordinatesUtils {
    public static int getCoordinate(@Nullable Indicator indicator, int position) {
        if (indicator == null) {
            return 0;
        }
        if (indicator.getOrientation() == Orientation.HORIZONTAL) {
            return CoordinatesUtils.getXCoordinate(indicator, position);
        }
        return CoordinatesUtils.getYCoordinate(indicator, position);
    }

    public static int getXCoordinate(@Nullable Indicator indicator, int position) {
        if (indicator == null) {
            return 0;
        }
        int coordinate = indicator.getOrientation() == Orientation.HORIZONTAL ? CoordinatesUtils.getHorizontalCoordinate(indicator, position) : CoordinatesUtils.getVerticalCoordinate(indicator);
        return coordinate += indicator.getPaddingLeft();
    }

    public static int getYCoordinate(@Nullable Indicator indicator, int position) {
        if (indicator == null) {
            return 0;
        }
        int coordinate = indicator.getOrientation() == Orientation.HORIZONTAL ? CoordinatesUtils.getVerticalCoordinate(indicator) : CoordinatesUtils.getHorizontalCoordinate(indicator, position);
        return coordinate += indicator.getPaddingTop();
    }

    public static int getPosition(@Nullable Indicator indicator, float x, float y) {
        float heightCoordinate;
        float lengthCoordinate;
        if (indicator == null) {
            return -1;
        }
        if (indicator.getOrientation() == Orientation.HORIZONTAL) {
            lengthCoordinate = x;
            heightCoordinate = y;
        } else {
            lengthCoordinate = y;
            heightCoordinate = x;
        }
        return CoordinatesUtils.getFitPosition(indicator, lengthCoordinate, heightCoordinate);
    }

    private static int getFitPosition(@NonNull Indicator indicator, float lengthCoordinate, float heightCoordinate) {
        int count = indicator.getCount();
        int radius = indicator.getRadius();
        int stroke = indicator.getStroke();
        int padding = indicator.getPadding();
        int height = indicator.getOrientation() == Orientation.HORIZONTAL ? indicator.getHeight() : indicator.getWidth();
        int length = 0;
        for (int i = 0; i < count; ++i) {
            boolean fitHeight;
            int indicatorPadding = i > 0 ? padding : padding / 2;
            int startValue = length;
            int endValue = length += radius * 2 + stroke / 2 + indicatorPadding;
            boolean fitLength = lengthCoordinate >= (float)startValue && lengthCoordinate <= (float)endValue;
            boolean bl = fitHeight = heightCoordinate >= 0.0f && heightCoordinate <= (float)height;
            if (!fitLength || !fitHeight) continue;
            return i;
        }
        return -1;
    }

    private static int getHorizontalCoordinate(@NonNull Indicator indicator, int position) {
        int count = indicator.getCount();
        int radius = indicator.getRadius();
        int stroke = indicator.getStroke();
        int padding = indicator.getPadding();
        int coordinate = 0;
        for (int i = 0; i < count; ++i) {
            coordinate += radius + stroke / 2;
            if (position == i) {
                return coordinate;
            }
            coordinate += radius + padding + stroke / 2;
        }
        if (indicator.getAnimationType() == AnimationType.DROP) {
            coordinate += radius * 2;
        }
        return coordinate;
    }

    private static int getVerticalCoordinate(@NonNull Indicator indicator) {
        int radius = indicator.getRadius();
        int coordinate = indicator.getAnimationType() == AnimationType.DROP ? radius * 3 : radius;
        return coordinate;
    }

    public static Pair<Integer, Float> getProgress(@NonNull Indicator indicator, int position, float positionOffset, boolean isRtl) {
        float selectingProgress;
        int selectingPosition;
        boolean slideToRightSide;
        boolean isLeftOverScrolled;
        boolean isRightOverScrolled;
        int count = indicator.getCount();
        int selectedPosition = indicator.getSelectedPosition();
        if (isRtl) {
            position = count - 1 - position;
        }
        if (position < 0) {
            position = 0;
        } else if (position > count - 1) {
            position = count - 1;
        }
        boolean bl = isRightOverScrolled = position > selectedPosition;
        if (isRtl) {
            isLeftOverScrolled = position - 1 < selectedPosition;
        } else {
            boolean bl2 = isLeftOverScrolled = position + 1 < selectedPosition;
        }
        if (isRightOverScrolled || isLeftOverScrolled) {
            selectedPosition = position;
            indicator.setSelectedPosition(selectedPosition);
        }
        boolean bl3 = slideToRightSide = selectedPosition == position && positionOffset != 0.0f;
        if (slideToRightSide) {
            selectingPosition = isRtl ? position - 1 : position + 1;
            selectingProgress = positionOffset;
        } else {
            selectingPosition = position;
            selectingProgress = 1.0f - positionOffset;
        }
        if (selectingProgress > 1.0f) {
            selectingProgress = 1.0f;
        } else if (selectingProgress < 0.0f) {
            selectingProgress = 0.0f;
        }
        return new Pair((Object)selectingPosition, (Object)Float.valueOf(selectingProgress));
    }
}

