/*
 * Decompiled with CFR 0.152.
 */
package com.rd.draw.drawer.type;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import androidx.annotation.NonNull;
import com.rd.animation.data.Value;
import com.rd.animation.data.type.WormAnimationValue;
import com.rd.draw.data.Indicator;
import com.rd.draw.data.Orientation;
import com.rd.draw.drawer.type.BaseDrawer;

public class WormDrawer
extends BaseDrawer {
    public RectF rect = new RectF();

    public WormDrawer(@NonNull Paint paint, @NonNull Indicator indicator) {
        super(paint, indicator);
    }

    public void draw(@NonNull Canvas canvas, @NonNull Value value, int coordinateX, int coordinateY) {
        if (!(value instanceof WormAnimationValue)) {
            return;
        }
        WormAnimationValue v = (WormAnimationValue)value;
        int rectStart = v.getRectStart();
        int rectEnd = v.getRectEnd();
        int radius = this.indicator.getRadius();
        int unselectedColor = this.indicator.getUnselectedColor();
        int selectedColor = this.indicator.getSelectedColor();
        if (this.indicator.getOrientation() == Orientation.HORIZONTAL) {
            this.rect.left = rectStart;
            this.rect.right = rectEnd;
            this.rect.top = coordinateY - radius;
            this.rect.bottom = coordinateY + radius;
        } else {
            this.rect.left = coordinateX - radius;
            this.rect.right = coordinateX + radius;
            this.rect.top = rectStart;
            this.rect.bottom = rectEnd;
        }
        this.paint.setColor(unselectedColor);
        canvas.drawCircle((float)coordinateX, (float)coordinateY, (float)radius, this.paint);
        this.paint.setColor(selectedColor);
        canvas.drawRoundRect(this.rect, (float)radius, (float)radius, this.paint);
    }
}

