/*
 * Decompiled with CFR 0.152.
 */
package com.rd.draw.controller;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.rd.animation.type.AnimationType;
import com.rd.draw.data.Indicator;
import com.rd.draw.data.Orientation;
import com.rd.draw.data.RtlMode;
import com.rd.pageindicatorview.R;
import com.rd.utils.DensityUtils;

public class AttributeController {
    private Indicator indicator;
    private static final int DEFAULT_IDLE_DURATION = 3000;

    public AttributeController(@NonNull Indicator indicator) {
        this.indicator = indicator;
    }

    public void init(@NonNull Context context, @Nullable AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.PageIndicatorView, 0, 0);
        this.initCountAttribute(typedArray);
        this.initColorAttribute(typedArray);
        this.initAnimationAttribute(typedArray);
        this.initSizeAttribute(typedArray);
        typedArray.recycle();
    }

    private void initCountAttribute(@NonNull TypedArray typedArray) {
        int position;
        int viewPagerId = typedArray.getResourceId(R.styleable.PageIndicatorView_piv_viewPager, -1);
        boolean autoVisibility = typedArray.getBoolean(R.styleable.PageIndicatorView_piv_autoVisibility, true);
        boolean dynamicCount = typedArray.getBoolean(R.styleable.PageIndicatorView_piv_dynamicCount, false);
        int count = typedArray.getInt(R.styleable.PageIndicatorView_piv_count, -1);
        if (count == -1) {
            count = 3;
        }
        if ((position = typedArray.getInt(R.styleable.PageIndicatorView_piv_select, 0)) < 0) {
            position = 0;
        } else if (count > 0 && position > count - 1) {
            position = count - 1;
        }
        this.indicator.setViewPagerId(viewPagerId);
        this.indicator.setAutoVisibility(autoVisibility);
        this.indicator.setDynamicCount(dynamicCount);
        this.indicator.setCount(count);
        this.indicator.setSelectedPosition(position);
        this.indicator.setSelectingPosition(position);
        this.indicator.setLastSelectedPosition(position);
    }

    private void initColorAttribute(@NonNull TypedArray typedArray) {
        int unselectedColor = typedArray.getColor(R.styleable.PageIndicatorView_piv_unselectedColor, Color.parseColor((String)"#33ffffff"));
        int selectedColor = typedArray.getColor(R.styleable.PageIndicatorView_piv_selectedColor, Color.parseColor((String)"#ffffff"));
        this.indicator.setUnselectedColor(unselectedColor);
        this.indicator.setSelectedColor(selectedColor);
    }

    private void initAnimationAttribute(@NonNull TypedArray typedArray) {
        boolean interactiveAnimation = typedArray.getBoolean(R.styleable.PageIndicatorView_piv_interactiveAnimation, false);
        long animationDuration = typedArray.getInt(R.styleable.PageIndicatorView_piv_animationDuration, 350);
        if (animationDuration < 0L) {
            animationDuration = 0L;
        }
        int animIndex = typedArray.getInt(R.styleable.PageIndicatorView_piv_animationType, AnimationType.NONE.ordinal());
        AnimationType animationType = this.getAnimationType(animIndex);
        int rtlIndex = typedArray.getInt(R.styleable.PageIndicatorView_piv_rtl_mode, RtlMode.Off.ordinal());
        RtlMode rtlMode = this.getRtlMode(rtlIndex);
        boolean fadeOnIdle = typedArray.getBoolean(R.styleable.PageIndicatorView_piv_fadeOnIdle, false);
        long idleDuration = typedArray.getInt(R.styleable.PageIndicatorView_piv_idleDuration, 3000);
        this.indicator.setAnimationDuration(animationDuration);
        this.indicator.setInteractiveAnimation(interactiveAnimation);
        this.indicator.setAnimationType(animationType);
        this.indicator.setRtlMode(rtlMode);
        this.indicator.setFadeOnIdle(fadeOnIdle);
        this.indicator.setIdleDuration(idleDuration);
    }

    private void initSizeAttribute(@NonNull TypedArray typedArray) {
        float scaleFactor;
        int padding;
        int orientationIndex = typedArray.getInt(R.styleable.PageIndicatorView_piv_orientation, Orientation.HORIZONTAL.ordinal());
        Orientation orientation = orientationIndex == 0 ? Orientation.HORIZONTAL : Orientation.VERTICAL;
        int radius = (int)typedArray.getDimension(R.styleable.PageIndicatorView_piv_radius, (float)DensityUtils.dpToPx(6));
        if (radius < 0) {
            radius = 0;
        }
        if ((padding = (int)typedArray.getDimension(R.styleable.PageIndicatorView_piv_padding, (float)DensityUtils.dpToPx(8))) < 0) {
            padding = 0;
        }
        if ((scaleFactor = typedArray.getFloat(R.styleable.PageIndicatorView_piv_scaleFactor, 0.7f)) < 0.3f) {
            scaleFactor = 0.3f;
        } else if (scaleFactor > 1.0f) {
            scaleFactor = 1.0f;
        }
        int stroke = (int)typedArray.getDimension(R.styleable.PageIndicatorView_piv_strokeWidth, (float)DensityUtils.dpToPx(1));
        if (stroke > radius) {
            stroke = radius;
        }
        if (this.indicator.getAnimationType() != AnimationType.FILL) {
            stroke = 0;
        }
        this.indicator.setRadius(radius);
        this.indicator.setOrientation(orientation);
        this.indicator.setPadding(padding);
        this.indicator.setScaleFactor(scaleFactor);
        this.indicator.setStroke(stroke);
    }

    private AnimationType getAnimationType(int index) {
        switch (index) {
            case 0: {
                return AnimationType.NONE;
            }
            case 1: {
                return AnimationType.COLOR;
            }
            case 2: {
                return AnimationType.SCALE;
            }
            case 3: {
                return AnimationType.WORM;
            }
            case 4: {
                return AnimationType.SLIDE;
            }
            case 5: {
                return AnimationType.FILL;
            }
            case 6: {
                return AnimationType.THIN_WORM;
            }
            case 7: {
                return AnimationType.DROP;
            }
            case 8: {
                return AnimationType.SWAP;
            }
            case 9: {
                return AnimationType.SCALE_DOWN;
            }
        }
        return AnimationType.NONE;
    }

    private RtlMode getRtlMode(int index) {
        switch (index) {
            case 0: {
                return RtlMode.On;
            }
            case 1: {
                return RtlMode.Off;
            }
            case 2: {
                return RtlMode.Auto;
            }
        }
        return RtlMode.Auto;
    }
}

