/*
 * Decompiled with CFR 0.152.
 */
package com.rd;

import androidx.annotation.Nullable;
import com.rd.animation.AnimationManager;
import com.rd.animation.controller.ValueController;
import com.rd.animation.data.Value;
import com.rd.draw.DrawManager;
import com.rd.draw.data.Indicator;

public class IndicatorManager
implements ValueController.UpdateListener {
    private DrawManager drawManager;
    private AnimationManager animationManager;
    private Listener listener;

    IndicatorManager(@Nullable Listener listener) {
        this.listener = listener;
        this.drawManager = new DrawManager();
        this.animationManager = new AnimationManager(this.drawManager.indicator(), this);
    }

    public AnimationManager animate() {
        return this.animationManager;
    }

    public Indicator indicator() {
        return this.drawManager.indicator();
    }

    public DrawManager drawer() {
        return this.drawManager;
    }

    @Override
    public void onValueUpdated(@Nullable Value value) {
        this.drawManager.updateValue(value);
        if (this.listener != null) {
            this.listener.onIndicatorUpdated();
        }
    }

    static interface Listener {
        public void onIndicatorUpdated();
    }
}

