/*
 * Decompiled with CFR 0.152.
 */
package com.rd;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.text.TextUtilsCompat;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.Pair;
import android.view.MotionEvent;
import android.view.View;
import com.rd.IndicatorManager;
import com.rd.animation.type.AnimationType;
import com.rd.draw.controller.DrawController;
import com.rd.draw.data.Indicator;
import com.rd.draw.data.Orientation;
import com.rd.draw.data.PositionSavedState;
import com.rd.draw.data.RtlMode;
import com.rd.utils.CoordinatesUtils;
import com.rd.utils.DensityUtils;
import com.rd.utils.IdUtils;
import java.util.Locale;

public class PageIndicatorView
extends View
implements ViewPager.OnPageChangeListener,
IndicatorManager.Listener {
    private IndicatorManager manager;
    private DataSetObserver setObserver;
    private ViewPager viewPager;
    private boolean isInteractionEnabled;

    public PageIndicatorView(Context context) {
        super(context);
        this.init(null);
    }

    public PageIndicatorView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public PageIndicatorView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    @TargetApi(value=21)
    public PageIndicatorView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.findViewPager();
    }

    protected void onDetachedFromWindow() {
        this.unRegisterSetObserver();
        super.onDetachedFromWindow();
    }

    public Parcelable onSaveInstanceState() {
        Indicator indicator = this.manager.indicator();
        PositionSavedState positionSavedState = new PositionSavedState(super.onSaveInstanceState());
        positionSavedState.setSelectedPosition(indicator.getSelectedPosition());
        positionSavedState.setSelectingPosition(indicator.getSelectingPosition());
        positionSavedState.setLastSelectedPosition(indicator.getLastSelectedPosition());
        return positionSavedState;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof PositionSavedState) {
            Indicator indicator = this.manager.indicator();
            PositionSavedState positionSavedState = (PositionSavedState)state;
            indicator.setSelectedPosition(positionSavedState.getSelectedPosition());
            indicator.setSelectingPosition(positionSavedState.getSelectingPosition());
            indicator.setLastSelectedPosition(positionSavedState.getLastSelectedPosition());
            super.onRestoreInstanceState(positionSavedState.getSuperState());
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Pair<Integer, Integer> pair = this.manager.drawer().measureViewSize(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension((Integer)pair.first, (Integer)pair.second);
    }

    protected void onDraw(Canvas canvas) {
        this.manager.drawer().draw(canvas);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        this.manager.drawer().touch(event);
        return true;
    }

    @Override
    public void onIndicatorUpdated() {
        this.invalidate();
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        this.onPageScroll(position, positionOffset);
    }

    public void onPageSelected(int position) {
        this.onPageSelect(position);
    }

    public void onPageScrollStateChanged(int state) {
        if (state == 0) {
            this.manager.indicator().setInteractiveAnimation(this.isInteractionEnabled);
        }
    }

    public void setCount(int count) {
        if (count >= 0 && this.manager.indicator().getCount() != count) {
            this.manager.indicator().setCount(count);
            this.updateVisibility();
            this.requestLayout();
        }
    }

    public int getCount() {
        return this.manager.indicator().getCount();
    }

    public void setDynamicCount(boolean dynamicCount) {
        this.manager.indicator().setDynamicCount(dynamicCount);
        if (dynamicCount) {
            this.registerSetObserver();
        } else {
            this.unRegisterSetObserver();
        }
    }

    public void setRadius(int radiusDp) {
        if (radiusDp < 0) {
            radiusDp = 0;
        }
        int radiusPx = DensityUtils.dpToPx(radiusDp);
        this.manager.indicator().setRadius(radiusPx);
        this.invalidate();
    }

    public void setRadius(float radiusPx) {
        if (radiusPx < 0.0f) {
            radiusPx = 0.0f;
        }
        this.manager.indicator().setRadius((int)radiusPx);
        this.invalidate();
    }

    public int getRadius() {
        return this.manager.indicator().getRadius();
    }

    public void setPadding(int paddingDp) {
        if (paddingDp < 0) {
            paddingDp = 0;
        }
        int paddingPx = DensityUtils.dpToPx(paddingDp);
        this.manager.indicator().setPadding(paddingPx);
        this.invalidate();
    }

    public void setPadding(float paddingPx) {
        if (paddingPx < 0.0f) {
            paddingPx = 0.0f;
        }
        this.manager.indicator().setPadding((int)paddingPx);
        this.invalidate();
    }

    public int getPadding() {
        return this.manager.indicator().getPadding();
    }

    public void setScaleFactor(float factor) {
        if (factor > 1.0f) {
            factor = 1.0f;
        } else if (factor < 0.3f) {
            factor = 0.3f;
        }
        this.manager.indicator().setScaleFactor(factor);
    }

    public float getScaleFactor() {
        return this.manager.indicator().getScaleFactor();
    }

    public void setStrokeWidth(float strokePx) {
        int radiusPx = this.manager.indicator().getRadius();
        if (strokePx < 0.0f) {
            strokePx = 0.0f;
        } else if (strokePx > (float)radiusPx) {
            strokePx = radiusPx;
        }
        this.manager.indicator().setStroke((int)strokePx);
        this.invalidate();
    }

    public void setStrokeWidth(int strokeDp) {
        int strokePx = DensityUtils.dpToPx(strokeDp);
        int radiusPx = this.manager.indicator().getRadius();
        if (strokePx < 0) {
            strokePx = 0;
        } else if (strokePx > radiusPx) {
            strokePx = radiusPx;
        }
        this.manager.indicator().setStroke(strokePx);
        this.invalidate();
    }

    public int getStrokeWidth() {
        return this.manager.indicator().getStroke();
    }

    public void setSelectedColor(int color) {
        this.manager.indicator().setSelectedColor(color);
        this.invalidate();
    }

    public int getSelectedColor() {
        return this.manager.indicator().getSelectedColor();
    }

    public void setUnselectedColor(int color) {
        this.manager.indicator().setUnselectedColor(color);
        this.invalidate();
    }

    public int getUnselectedColor() {
        return this.manager.indicator().getUnselectedColor();
    }

    public void setAutoVisibility(boolean autoVisibility) {
        if (!autoVisibility) {
            this.setVisibility(0);
        }
        this.manager.indicator().setAutoVisibility(autoVisibility);
        this.updateVisibility();
    }

    public void setOrientation(@Nullable Orientation orientation) {
        if (orientation != null) {
            this.manager.indicator().setOrientation(orientation);
            this.requestLayout();
        }
    }

    public void setAnimationDuration(long duration) {
        this.manager.indicator().setAnimationDuration(duration);
    }

    public long getAnimationDuration() {
        return this.manager.indicator().getAnimationDuration();
    }

    public void setAnimationType(@Nullable AnimationType type) {
        this.manager.onValueUpdated(null);
        if (type != null) {
            this.manager.indicator().setAnimationType(type);
        } else {
            this.manager.indicator().setAnimationType(AnimationType.NONE);
        }
        this.invalidate();
    }

    public void setInteractiveAnimation(boolean isInteractive) {
        this.manager.indicator().setInteractiveAnimation(isInteractive);
        this.isInteractionEnabled = isInteractive;
    }

    public void setViewPager(@Nullable ViewPager pager) {
        this.releaseViewPager();
        if (pager == null) {
            return;
        }
        this.viewPager = pager;
        this.viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.manager.indicator().setViewPagerId(this.viewPager.getId());
        this.setDynamicCount(this.manager.indicator().isDynamicCount());
        int count = this.getViewPagerCount();
        if (this.isRtl()) {
            int selectedPosition = count - 1 - this.viewPager.getCurrentItem();
            this.manager.indicator().setSelectedPosition(selectedPosition);
        }
        this.setCount(count);
    }

    public void releaseViewPager() {
        if (this.viewPager != null) {
            this.viewPager.removeOnPageChangeListener((ViewPager.OnPageChangeListener)this);
            this.viewPager = null;
        }
    }

    public void setRtlMode(@Nullable RtlMode mode) {
        int selectedPosition;
        Indicator indicator = this.manager.indicator();
        if (mode == null) {
            indicator.setRtlMode(RtlMode.Off);
        } else {
            indicator.setRtlMode(mode);
        }
        if (this.viewPager == null) {
            return;
        }
        int position = selectedPosition = indicator.getSelectedPosition();
        if (this.isRtl()) {
            position = indicator.getCount() - 1 - selectedPosition;
        } else if (this.viewPager != null) {
            position = this.viewPager.getCurrentItem();
        }
        indicator.setLastSelectedPosition(position);
        indicator.setSelectingPosition(position);
        indicator.setSelectedPosition(position);
        this.invalidate();
    }

    public void setSelection(int position) {
        Indicator indicator = this.manager.indicator();
        if ((position = this.adjustPosition(position)) == indicator.getSelectedPosition() || position == indicator.getSelectingPosition()) {
            return;
        }
        indicator.setInteractiveAnimation(false);
        indicator.setLastSelectedPosition(indicator.getSelectedPosition());
        indicator.setSelectingPosition(position);
        indicator.setSelectedPosition(position);
        this.manager.animate().basic();
    }

    public void setSelected(int position) {
        Indicator indicator = this.manager.indicator();
        AnimationType animationType = indicator.getAnimationType();
        indicator.setAnimationType(AnimationType.NONE);
        this.setSelection(position);
        indicator.setAnimationType(animationType);
    }

    public int getSelection() {
        return this.manager.indicator().getSelectedPosition();
    }

    public void setProgress(int selectingPosition, float progress) {
        Indicator indicator = this.manager.indicator();
        if (!indicator.isInteractiveAnimation()) {
            return;
        }
        int count = indicator.getCount();
        if (count <= 0 || selectingPosition < 0) {
            selectingPosition = 0;
        } else if (selectingPosition > count - 1) {
            selectingPosition = count - 1;
        }
        if (progress < 0.0f) {
            progress = 0.0f;
        } else if (progress > 1.0f) {
            progress = 1.0f;
        }
        if (progress == 1.0f) {
            indicator.setLastSelectedPosition(indicator.getSelectedPosition());
            indicator.setSelectedPosition(selectingPosition);
        }
        indicator.setSelectingPosition(selectingPosition);
        this.manager.animate().interactive(progress);
    }

    public void setClickListener(@Nullable DrawController.ClickListener listener) {
        this.manager.drawer().setClickListener(listener);
    }

    private void init(@Nullable AttributeSet attrs) {
        this.setupId();
        this.initIndicatorManager(attrs);
    }

    private void setupId() {
        if (this.getId() == -1) {
            this.setId(IdUtils.generateViewId());
        }
    }

    private void initIndicatorManager(@Nullable AttributeSet attrs) {
        this.manager = new IndicatorManager(this);
        this.manager.drawer().initAttributes(this.getContext(), attrs);
        Indicator indicator = this.manager.indicator();
        indicator.setPaddingLeft(this.getPaddingLeft());
        indicator.setPaddingTop(this.getPaddingTop());
        indicator.setPaddingRight(this.getPaddingRight());
        indicator.setPaddingBottom(this.getPaddingBottom());
        this.isInteractionEnabled = indicator.isInteractiveAnimation();
    }

    private void registerSetObserver() {
        if (this.setObserver != null || this.viewPager == null || this.viewPager.getAdapter() == null) {
            return;
        }
        this.setObserver = new DataSetObserver(){

            public void onChanged() {
                PageIndicatorView.this.updateCount();
            }
        };
        try {
            this.viewPager.getAdapter().registerDataSetObserver(this.setObserver);
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }

    private void unRegisterSetObserver() {
        if (this.setObserver == null || this.viewPager == null || this.viewPager.getAdapter() == null) {
            return;
        }
        try {
            this.viewPager.getAdapter().unregisterDataSetObserver(this.setObserver);
            this.setObserver = null;
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }

    private void updateCount() {
        if (this.viewPager == null || this.viewPager.getAdapter() == null) {
            return;
        }
        int newCount = this.viewPager.getAdapter().getCount();
        int currItem = this.viewPager.getCurrentItem();
        this.manager.indicator().setSelectedPosition(currItem);
        this.manager.indicator().setSelectingPosition(currItem);
        this.manager.indicator().setLastSelectedPosition(currItem);
        this.manager.animate().end();
        this.setCount(newCount);
    }

    private void updateVisibility() {
        if (!this.manager.indicator().isAutoVisibility()) {
            return;
        }
        int count = this.manager.indicator().getCount();
        int visibility = this.getVisibility();
        if (visibility != 0 && count > 1) {
            this.setVisibility(0);
        } else if (visibility != 4 && count <= 1) {
            this.setVisibility(4);
        }
    }

    private int getViewPagerCount() {
        if (this.viewPager != null && this.viewPager.getAdapter() != null) {
            return this.viewPager.getAdapter().getCount();
        }
        return this.manager.indicator().getCount();
    }

    private void onPageSelect(int position) {
        Indicator indicator = this.manager.indicator();
        boolean canSelectIndicator = this.isViewMeasured();
        int count = indicator.getCount();
        if (canSelectIndicator) {
            if (this.isRtl()) {
                position = count - 1 - position;
            }
            this.setSelection(position);
        }
    }

    private void onPageScroll(int position, float positionOffset) {
        boolean canSelectIndicator;
        Indicator indicator = this.manager.indicator();
        AnimationType animationType = indicator.getAnimationType();
        boolean interactiveAnimation = indicator.isInteractiveAnimation();
        boolean bl = canSelectIndicator = this.isViewMeasured() && interactiveAnimation && animationType != AnimationType.NONE;
        if (!canSelectIndicator) {
            return;
        }
        Pair<Integer, Float> progressPair = CoordinatesUtils.getProgress(indicator, position, positionOffset, this.isRtl());
        int selectingPosition = (Integer)progressPair.first;
        float selectingProgress = ((Float)progressPair.second).floatValue();
        this.setProgress(selectingPosition, selectingProgress);
    }

    private boolean isRtl() {
        switch (this.manager.indicator().getRtlMode()) {
            case On: {
                return true;
            }
            case Off: {
                return false;
            }
            case Auto: {
                return TextUtilsCompat.getLayoutDirectionFromLocale((Locale)this.getContext().getResources().getConfiguration().locale) == 1;
            }
        }
        return false;
    }

    private boolean isViewMeasured() {
        return this.getMeasuredHeight() != 0 || this.getMeasuredWidth() != 0;
    }

    private void findViewPager() {
        int viewPagerId;
        Activity activity;
        View view;
        if (this.getContext() instanceof Activity && (view = (activity = (Activity)this.getContext()).findViewById(viewPagerId = this.manager.indicator().getViewPagerId())) != null && view instanceof ViewPager) {
            this.setViewPager((ViewPager)view);
        }
    }

    private int adjustPosition(int position) {
        Indicator indicator = this.manager.indicator();
        int count = indicator.getCount();
        int lastPosition = count - 1;
        if (position < 0) {
            position = 0;
        } else if (position > lastPosition) {
            position = lastPosition;
        }
        return position;
    }
}

