/*
 * Decompiled with CFR 0.152.
 */
package com.rd.animation;

import android.animation.ArgbEvaluator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.support.annotation.NonNull;
import android.view.animation.DecelerateInterpolator;
import com.rd.animation.AbsAnimation;
import com.rd.animation.ValueAnimation;

public class ColorAnimation
extends AbsAnimation<ValueAnimator> {
    public static final String DEFAULT_UNSELECTED_COLOR = "#33ffffff";
    public static final String DEFAULT_SELECTED_COLOR = "#ffffff";
    private static final String ANIMATION_COLOR_REVERSE = "ANIMATION_COLOR_REVERSE";
    private static final String ANIMATION_COLOR = "ANIMATION_COLOR";
    protected int startColor;
    protected int endColor;

    public ColorAnimation(@NonNull ValueAnimation.UpdateListener listener) {
        super(listener);
    }

    @Override
    @NonNull
    public ValueAnimator createAnimator() {
        ValueAnimator animator = new ValueAnimator();
        animator.setDuration(350L);
        animator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ColorAnimation.this.onAnimateUpdated(animation);
            }
        });
        return animator;
    }

    @Override
    public ColorAnimation progress(float progress) {
        if (this.animator != null) {
            long playTime = (long)(progress * (float)this.animationDuration);
            if (((ValueAnimator)this.animator).getValues() != null && ((ValueAnimator)this.animator).getValues().length > 0) {
                ((ValueAnimator)this.animator).setCurrentPlayTime(playTime);
            }
        }
        return this;
    }

    @NonNull
    public ColorAnimation with(int colorStartValue, int colorEndValue) {
        if (this.animator != null && this.hasChanges(colorStartValue, colorEndValue)) {
            this.startColor = colorStartValue;
            this.endColor = colorEndValue;
            PropertyValuesHolder colorHolder = this.createColorPropertyHolder(false);
            PropertyValuesHolder reverseColorHolder = this.createColorPropertyHolder(true);
            ((ValueAnimator)this.animator).setValues(new PropertyValuesHolder[]{colorHolder, reverseColorHolder});
        }
        return this;
    }

    protected PropertyValuesHolder createColorPropertyHolder(boolean isReverse) {
        int endColorValue;
        int startColorValue;
        String propertyName;
        if (isReverse) {
            propertyName = ANIMATION_COLOR_REVERSE;
            startColorValue = this.endColor;
            endColorValue = this.startColor;
        } else {
            propertyName = ANIMATION_COLOR;
            startColorValue = this.startColor;
            endColorValue = this.endColor;
        }
        PropertyValuesHolder holder = PropertyValuesHolder.ofInt((String)propertyName, (int[])new int[]{startColorValue, endColorValue});
        holder.setEvaluator((TypeEvaluator)new ArgbEvaluator());
        return holder;
    }

    private boolean hasChanges(int colorStartValue, int colorEndValue) {
        if (this.startColor != colorStartValue) {
            return true;
        }
        return this.endColor != colorEndValue;
    }

    private void onAnimateUpdated(@NonNull ValueAnimator animation) {
        int color = (Integer)animation.getAnimatedValue(ANIMATION_COLOR);
        int colorReverse = (Integer)animation.getAnimatedValue(ANIMATION_COLOR_REVERSE);
        if (this.listener != null) {
            this.listener.onColorAnimationUpdated(color, colorReverse);
        }
    }
}

