/*
 * Decompiled with CFR 0.152.
 */
package com.rd;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.text.TextUtilsCompat;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.Pair;
import android.view.View;
import com.rd.Orientation;
import com.rd.PositionSavedState;
import com.rd.RtlMode;
import com.rd.animation.AbsAnimation;
import com.rd.animation.AnimationType;
import com.rd.animation.ValueAnimation;
import com.rd.pageindicatorview.R;
import com.rd.utils.DensityUtils;
import com.rd.utils.IdUtils;
import java.util.Locale;

public class PageIndicatorView
extends View
implements ViewPager.OnPageChangeListener {
    private static final int DEFAULT_CIRCLES_COUNT = 3;
    private static final int COUNT_NOT_SET = -1;
    private static final int DEFAULT_RADIUS_DP = 6;
    private static final int DEFAULT_PADDING_DP = 8;
    private int radiusPx;
    private int paddingPx;
    private int strokePx;
    private int count;
    private boolean isCountSet;
    private int unselectedColor;
    private int selectedColor;
    private int frameColor;
    private int frameColorReverse;
    private Orientation orientation = Orientation.HORIZONTAL;
    private int frameRadiusPx;
    private int frameRadiusReversePx;
    private float scaleFactor;
    private int frameStrokePx;
    private int frameStrokeReversePx;
    private int frameFrom;
    private int frameTo;
    private int frameSlideFrom;
    private int frameY;
    private int frameHeight;
    private boolean autoVisibility;
    private int selectedPosition;
    private int selectingPosition;
    private int lastSelectedPosition;
    private boolean isFrameValuesSet;
    private boolean interactiveAnimation;
    private long animationDuration;
    private DataSetObserver setObserver;
    private boolean dynamicCount;
    private Paint fillPaint = new Paint();
    private Paint strokePaint = new Paint();
    private RectF rect = new RectF();
    private AnimationType animationType = AnimationType.NONE;
    private ValueAnimation animation;
    private ViewPager viewPager;
    private int viewPagerId;
    private RtlMode rtlMode = RtlMode.Off;

    public PageIndicatorView(Context context) {
        super(context);
        this.init(null);
    }

    public PageIndicatorView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public PageIndicatorView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    @TargetApi(value=21)
    public PageIndicatorView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.findViewPager();
    }

    protected void onDetachedFromWindow() {
        this.unRegisterSetObserver();
        super.onDetachedFromWindow();
    }

    public Parcelable onSaveInstanceState() {
        PositionSavedState positionSavedState = new PositionSavedState(super.onSaveInstanceState());
        positionSavedState.setSelectedPosition(this.selectedPosition);
        positionSavedState.setSelectingPosition(this.selectingPosition);
        positionSavedState.setLastSelectedPosition(this.lastSelectedPosition);
        return positionSavedState;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof PositionSavedState) {
            PositionSavedState positionSavedState = (PositionSavedState)state;
            this.selectedPosition = positionSavedState.getSelectedPosition();
            this.selectingPosition = positionSavedState.getSelectingPosition();
            this.lastSelectedPosition = positionSavedState.getLastSelectedPosition();
            super.onRestoreInstanceState(positionSavedState.getSuperState());
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int circleDiameterPx = this.radiusPx * 2;
        int desiredWidth = 0;
        int desiredHeight = 0;
        if (this.orientation == Orientation.HORIZONTAL) {
            desiredHeight = circleDiameterPx + this.strokePx;
        } else {
            desiredWidth = circleDiameterPx + this.strokePx;
        }
        if (this.count != 0) {
            int diameterSum = circleDiameterPx * this.count;
            int strokeSum = this.strokePx * 2 * this.count;
            int paddingSum = this.paddingPx * (this.count - 1);
            if (this.orientation == Orientation.HORIZONTAL) {
                desiredWidth = diameterSum + strokeSum + paddingSum;
            } else {
                desiredHeight = diameterSum + strokeSum + paddingSum;
            }
        }
        int width = widthMode == 0x40000000 ? widthSize : (widthMode == Integer.MIN_VALUE ? Math.min(desiredWidth, widthSize) : desiredWidth);
        int height = heightMode == 0x40000000 ? heightSize : (heightMode == Integer.MIN_VALUE ? Math.min(desiredHeight, heightSize) : desiredHeight);
        if (this.animationType == AnimationType.DROP) {
            if (this.orientation == Orientation.HORIZONTAL) {
                height *= 2;
            } else {
                width *= 2;
            }
        }
        if (width < 0) {
            width = 0;
        }
        if (height < 0) {
            height = 0;
        }
        this.setMeasuredDimension(width, height);
    }

    private boolean isViewMeasured() {
        return this.getMeasuredHeight() != 0 || this.getMeasuredWidth() != 0;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.setupFrameValues();
    }

    protected void onDraw(Canvas canvas) {
        this.drawIndicatorView(canvas);
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (this.isViewMeasured() && this.interactiveAnimation && this.animationType != AnimationType.NONE) {
            this.onPageScroll(position, positionOffset);
        }
    }

    public void onPageSelected(int position) {
        int pageCount;
        if (this.viewPager != null && this.viewPager.getAdapter() != null && (pageCount = this.viewPager.getAdapter().getCount()) < this.count) {
            return;
        }
        if (this.isViewMeasured() && (!this.interactiveAnimation || this.animationType == AnimationType.NONE)) {
            if (this.isRtl()) {
                position = this.count - 1 - position;
            }
            this.setSelection(position);
        }
    }

    public void onPageScrollStateChanged(int state) {
    }

    public void setCount(int count) {
        if (this.count != count) {
            this.count = count;
            this.isCountSet = true;
            this.resetFrameValues();
            this.updateVisibility();
            this.requestLayout();
        }
    }

    public int getCount() {
        return this.count;
    }

    public void setDynamicCount(boolean dynamicCount) {
        this.dynamicCount = dynamicCount;
        if (dynamicCount) {
            this.registerSetObserver();
        } else {
            this.unRegisterSetObserver();
        }
    }

    public void setRadius(int radiusDp) {
        if (radiusDp < 0) {
            radiusDp = 0;
        }
        this.radiusPx = DensityUtils.dpToPx(radiusDp);
        this.invalidate();
    }

    public void setRadius(float radiusPx) {
        if (radiusPx < 0.0f) {
            radiusPx = 0.0f;
        }
        this.radiusPx = (int)radiusPx;
        this.invalidate();
    }

    public int getRadius() {
        return this.radiusPx;
    }

    public void setPadding(int paddingDp) {
        if (paddingDp < 0) {
            paddingDp = 0;
        }
        this.paddingPx = DensityUtils.dpToPx(paddingDp);
        this.invalidate();
    }

    public void setPadding(float paddingPx) {
        if (paddingPx < 0.0f) {
            paddingPx = 0.0f;
        }
        this.paddingPx = (int)paddingPx;
        this.invalidate();
    }

    public int getPadding() {
        return this.paddingPx;
    }

    public void setScaleFactor(float factor) {
        if (factor > 1.0f) {
            factor = 1.0f;
        } else if (factor < 0.3f) {
            factor = 0.3f;
        }
        this.scaleFactor = factor;
    }

    public float getScaleFactor() {
        return this.scaleFactor;
    }

    public void setStrokeWidth(float strokePx) {
        if (strokePx < 0.0f) {
            strokePx = 0.0f;
        } else if (strokePx > (float)this.radiusPx) {
            strokePx = this.radiusPx;
        }
        this.strokePx = (int)strokePx;
        this.invalidate();
    }

    public void setStrokeWidth(int strokeDp) {
        int strokePx = DensityUtils.dpToPx(strokeDp);
        if (strokePx < 0) {
            strokePx = 0;
        } else if (strokePx > this.radiusPx) {
            strokePx = this.radiusPx;
        }
        this.strokePx = strokePx;
        this.invalidate();
    }

    public int getStrokeWidth() {
        return this.strokePx;
    }

    public void setUnselectedColor(int color) {
        this.unselectedColor = color;
        this.invalidate();
    }

    public int getUnselectedColor() {
        return this.unselectedColor;
    }

    public void setSelectedColor(int color) {
        this.selectedColor = color;
        this.invalidate();
    }

    public void setAutoVisibility(boolean autoVisibility) {
        if (!autoVisibility) {
            this.setVisibility(0);
        }
        this.autoVisibility = autoVisibility;
        this.updateVisibility();
    }

    public void setOrientation(@Nullable Orientation orientation) {
        if (orientation != null) {
            this.orientation = orientation;
            this.requestLayout();
        }
    }

    public int getSelectedColor() {
        return this.selectedColor;
    }

    public void setAnimationDuration(long duration) {
        this.animationDuration = duration;
    }

    public long getAnimationDuration() {
        return this.animationDuration;
    }

    public void setAnimationType(@Nullable AnimationType type) {
        this.animationType = type != null ? type : AnimationType.NONE;
    }

    public void setInteractiveAnimation(boolean isInteractive) {
        this.interactiveAnimation = isInteractive;
    }

    public void setProgress(int selectingPosition, float progress) {
        if (this.interactiveAnimation) {
            if (this.count <= 0 || selectingPosition < 0) {
                selectingPosition = 0;
            } else if (selectingPosition > this.count - 1) {
                selectingPosition = this.count - 1;
            }
            if (progress < 0.0f) {
                progress = 0.0f;
            } else if (progress > 1.0f) {
                progress = 1.0f;
            }
            this.selectingPosition = selectingPosition;
            this.setAnimationProgress(progress);
        }
    }

    public void setSelection(int position) {
        if (position < 0) {
            position = 0;
        } else if (position > this.count - 1) {
            position = this.count - 1;
        }
        this.lastSelectedPosition = this.selectedPosition;
        this.selectedPosition = position;
        switch (this.animationType) {
            case NONE: {
                this.invalidate();
                break;
            }
            case COLOR: {
                this.startColorAnimation();
                break;
            }
            case SCALE: {
                this.startScaleAnimation();
                break;
            }
            case WORM: {
                this.startWormAnimation();
                break;
            }
            case FILL: {
                this.startFillAnimation();
                break;
            }
            case SLIDE: {
                this.startSlideAnimation();
                break;
            }
            case THIN_WORM: {
                this.startThinWormAnimation();
                break;
            }
            case DROP: {
                this.startDropAnimation();
                break;
            }
            case SWAP: {
                this.startSwapAnimation();
            }
        }
    }

    public int getSelection() {
        return this.selectedPosition;
    }

    public void setViewPager(@Nullable ViewPager pager) {
        this.releaseViewPager();
        if (pager == null) {
            return;
        }
        this.viewPager = pager;
        this.viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.setDynamicCount(this.dynamicCount);
        int count = this.getViewPagerCount();
        if (this.isRtl()) {
            int selected = this.viewPager.getCurrentItem();
            this.selectedPosition = count - 1 - selected;
        }
        this.setCount(count);
    }

    public void releaseViewPager() {
        if (this.viewPager != null) {
            this.viewPager.removeOnPageChangeListener((ViewPager.OnPageChangeListener)this);
            this.viewPager = null;
        }
    }

    public void setRtlMode(@Nullable RtlMode mode) {
        this.rtlMode = mode == null ? RtlMode.Off : mode;
    }

    private void onPageScroll(int position, float positionOffset) {
        Pair<Integer, Float> progressPair = this.getProgress(position, positionOffset);
        int selectingPosition = (Integer)progressPair.first;
        float selectingProgress = ((Float)progressPair.second).floatValue();
        if (selectingProgress == 1.0f) {
            this.lastSelectedPosition = this.selectedPosition;
            this.selectedPosition = selectingPosition;
        }
        this.setProgress(selectingPosition, selectingProgress);
    }

    private void drawIndicatorView(@NonNull Canvas canvas) {
        for (int i = 0; i < this.count; ++i) {
            int x = this.getXCoordinate(i);
            int y = this.getYCoordinate(i);
            this.drawCircle(canvas, i, x, y);
        }
    }

    private void drawCircle(@NonNull Canvas canvas, int position, int x, int y) {
        boolean selectingItem;
        boolean selectedItem = !this.interactiveAnimation && (position == this.selectedPosition || position == this.lastSelectedPosition);
        boolean isSelectedItem = selectedItem | (selectingItem = this.interactiveAnimation && (position == this.selectingPosition || position == this.selectedPosition));
        if (isSelectedItem) {
            this.drawWithAnimationEffect(canvas, position, x, y);
        } else {
            this.drawWithNoEffect(canvas, position, x, y);
        }
    }

    private void drawWithAnimationEffect(@NonNull Canvas canvas, int position, int x, int y) {
        switch (this.animationType) {
            case NONE: {
                this.drawWithNoEffect(canvas, position, x, y);
                break;
            }
            case COLOR: {
                this.drawWithColorAnimation(canvas, position, x, y);
                break;
            }
            case SCALE: {
                this.drawWithScaleAnimation(canvas, position, x, y);
                break;
            }
            case SLIDE: {
                this.drawWithSlideAnimation(canvas, position, x, y);
                break;
            }
            case WORM: {
                this.drawWithWormAnimation(canvas, x, y);
                break;
            }
            case FILL: {
                this.drawWithFillAnimation(canvas, position, x, y);
                break;
            }
            case THIN_WORM: {
                this.drawWithThinWormAnimation(canvas, x, y);
                break;
            }
            case DROP: {
                this.drawWithDropAnimation(canvas, x, y);
                break;
            }
            case SWAP: {
                if (this.orientation == Orientation.HORIZONTAL) {
                    this.drawWithSwapAnimation(canvas, position, x, y);
                    break;
                }
                this.drawWithSwapAnimationVertically(canvas, position, x, y);
            }
        }
    }

    private void drawWithNoEffect(@NonNull Canvas canvas, int position, int x, int y) {
        Paint paint;
        float radius = this.radiusPx;
        if (this.animationType == AnimationType.SCALE) {
            radius *= this.scaleFactor;
        }
        int color = this.unselectedColor;
        if (position == this.selectedPosition) {
            color = this.selectedColor;
        }
        if (this.animationType == AnimationType.FILL) {
            paint = this.strokePaint;
            paint.setStrokeWidth((float)this.strokePx);
        } else {
            paint = this.fillPaint;
        }
        paint.setColor(color);
        canvas.drawCircle((float)x, (float)y, radius, paint);
    }

    private void drawWithColorAnimation(@NonNull Canvas canvas, int position, int x, int y) {
        int color = this.unselectedColor;
        if (this.interactiveAnimation) {
            if (position == this.selectingPosition) {
                color = this.frameColor;
            } else if (position == this.selectedPosition) {
                color = this.frameColorReverse;
            }
        } else if (position == this.selectedPosition) {
            color = this.frameColor;
        } else if (position == this.lastSelectedPosition) {
            color = this.frameColorReverse;
        }
        this.fillPaint.setColor(color);
        canvas.drawCircle((float)x, (float)y, (float)this.radiusPx, this.fillPaint);
    }

    private void drawWithScaleAnimation(@NonNull Canvas canvas, int position, int x, int y) {
        int color = this.unselectedColor;
        int radius = this.radiusPx;
        if (this.interactiveAnimation) {
            if (position == this.selectingPosition) {
                radius = this.frameRadiusPx;
                color = this.frameColor;
            } else if (position == this.selectedPosition) {
                radius = this.frameRadiusReversePx;
                color = this.frameColorReverse;
            }
        } else if (position == this.selectedPosition) {
            radius = this.frameRadiusPx;
            color = this.frameColor;
        } else if (position == this.lastSelectedPosition) {
            radius = this.frameRadiusReversePx;
            color = this.frameColorReverse;
        }
        this.fillPaint.setColor(color);
        canvas.drawCircle((float)x, (float)y, (float)radius, this.fillPaint);
    }

    private void drawWithSlideAnimation(@NonNull Canvas canvas, int position, int x, int y) {
        int to;
        this.fillPaint.setColor(this.unselectedColor);
        canvas.drawCircle((float)x, (float)y, (float)this.radiusPx, this.fillPaint);
        int from = this.orientation == Orientation.HORIZONTAL ? this.frameSlideFrom : x;
        int n = to = this.orientation == Orientation.HORIZONTAL ? y : this.frameSlideFrom;
        if (this.interactiveAnimation && (position == this.selectingPosition || position == this.selectedPosition)) {
            this.fillPaint.setColor(this.selectedColor);
            canvas.drawCircle((float)from, (float)to, (float)this.radiusPx, this.fillPaint);
        } else if (!(this.interactiveAnimation || position != this.selectedPosition && position != this.lastSelectedPosition)) {
            this.fillPaint.setColor(this.selectedColor);
            canvas.drawCircle((float)from, (float)to, (float)this.radiusPx, this.fillPaint);
        }
    }

    private void drawWithWormAnimation(@NonNull Canvas canvas, int x, int y) {
        int radius = this.radiusPx;
        if (this.orientation == Orientation.HORIZONTAL) {
            this.rect.left = this.frameFrom;
            this.rect.right = this.frameTo;
            this.rect.top = y - radius;
            this.rect.bottom = y + radius;
        } else {
            this.rect.left = x - this.radiusPx;
            this.rect.right = x + this.radiusPx;
            this.rect.top = this.frameFrom;
            this.rect.bottom = this.frameTo;
        }
        this.fillPaint.setColor(this.unselectedColor);
        canvas.drawCircle((float)x, (float)y, (float)radius, this.fillPaint);
        this.fillPaint.setColor(this.selectedColor);
        canvas.drawRoundRect(this.rect, (float)this.radiusPx, (float)this.radiusPx, this.fillPaint);
    }

    private void drawWithFillAnimation(@NonNull Canvas canvas, int position, int x, int y) {
        int color = this.unselectedColor;
        float radius = this.radiusPx;
        int stroke = this.strokePx;
        if (this.interactiveAnimation) {
            if (position == this.selectingPosition) {
                color = this.frameColor;
                radius = this.frameRadiusPx;
                stroke = this.frameStrokePx;
            } else if (position == this.selectedPosition) {
                color = this.frameColorReverse;
                radius = this.frameRadiusReversePx;
                stroke = this.frameStrokeReversePx;
            }
        } else if (position == this.selectedPosition) {
            color = this.frameColor;
            radius = this.frameRadiusPx;
            stroke = this.frameStrokePx;
        } else if (position == this.lastSelectedPosition) {
            color = this.frameColorReverse;
            radius = this.frameRadiusReversePx;
            stroke = this.frameStrokeReversePx;
        }
        this.strokePaint.setColor(color);
        this.strokePaint.setStrokeWidth((float)this.strokePx);
        canvas.drawCircle((float)x, (float)y, (float)this.radiusPx, this.strokePaint);
        this.strokePaint.setStrokeWidth((float)stroke);
        canvas.drawCircle((float)x, (float)y, radius, this.strokePaint);
    }

    private void drawWithThinWormAnimation(@NonNull Canvas canvas, int x, int y) {
        int radius = this.radiusPx;
        if (this.orientation == Orientation.HORIZONTAL) {
            this.rect.left = this.frameFrom;
            this.rect.right = this.frameTo;
            this.rect.top = y - this.frameHeight / 2;
            this.rect.bottom = y + this.frameHeight / 2;
        } else {
            this.rect.left = x - this.frameHeight / 2;
            this.rect.right = x + this.frameHeight / 2;
            this.rect.top = this.frameFrom;
            this.rect.bottom = this.frameTo;
        }
        this.fillPaint.setColor(this.unselectedColor);
        canvas.drawCircle((float)x, (float)y, (float)radius, this.fillPaint);
        this.fillPaint.setColor(this.selectedColor);
        canvas.drawRoundRect(this.rect, (float)this.radiusPx, (float)this.radiusPx, this.fillPaint);
    }

    private void drawWithDropAnimation(@NonNull Canvas canvas, int x, int y) {
        this.fillPaint.setColor(this.unselectedColor);
        canvas.drawCircle((float)x, (float)y, (float)this.radiusPx, this.fillPaint);
        this.fillPaint.setColor(this.selectedColor);
        canvas.drawCircle((float)this.frameSlideFrom, (float)this.frameY, (float)this.frameRadiusPx, this.fillPaint);
    }

    private void drawWithSwapAnimation(@NonNull Canvas canvas, int position, int x, int y) {
        this.fillPaint.setColor(this.unselectedColor);
        if (position == this.selectedPosition) {
            this.fillPaint.setColor(this.selectedColor);
            canvas.drawCircle((float)this.frameSlideFrom, (float)y, (float)this.radiusPx, this.fillPaint);
        } else if (this.interactiveAnimation && position == this.selectingPosition) {
            canvas.drawCircle((float)(x - (this.frameSlideFrom - this.getXCoordinate(this.selectedPosition))), (float)y, (float)this.radiusPx, this.fillPaint);
        } else if (!this.interactiveAnimation) {
            canvas.drawCircle((float)(x - (this.frameSlideFrom - this.getXCoordinate(this.selectedPosition))), (float)y, (float)this.radiusPx, this.fillPaint);
        } else {
            canvas.drawCircle((float)x, (float)y, (float)this.radiusPx, this.fillPaint);
        }
    }

    private void drawWithSwapAnimationVertically(@NonNull Canvas canvas, int position, int x, int y) {
        this.fillPaint.setColor(this.unselectedColor);
        if (position == this.selectedPosition) {
            this.fillPaint.setColor(this.selectedColor);
            canvas.drawCircle((float)x, (float)this.frameSlideFrom, (float)this.radiusPx, this.fillPaint);
        } else if (this.interactiveAnimation && position == this.selectingPosition) {
            canvas.drawCircle((float)x, (float)(y - (this.frameSlideFrom - this.getYCoordinate(this.selectedPosition))), (float)this.radiusPx, this.fillPaint);
        } else if (!this.interactiveAnimation) {
            canvas.drawCircle((float)x, (float)(y - (this.frameSlideFrom - this.getYCoordinate(this.selectedPosition))), (float)this.radiusPx, this.fillPaint);
        } else {
            canvas.drawCircle((float)x, (float)y, (float)this.radiusPx, this.fillPaint);
        }
    }

    private void init(@Nullable AttributeSet attrs) {
        this.setupId();
        this.initAttributes(attrs);
        this.initAnimation();
        this.updateVisibility();
        this.fillPaint.setStyle(Paint.Style.FILL);
        this.fillPaint.setAntiAlias(true);
        this.strokePaint.setStyle(Paint.Style.STROKE);
        this.strokePaint.setAntiAlias(true);
        this.strokePaint.setStrokeWidth((float)this.strokePx);
    }

    private void setupId() {
        if (this.getId() == -1) {
            this.setId(IdUtils.generateViewId());
        }
    }

    private void initAttributes(@Nullable AttributeSet attrs) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.PageIndicatorView, 0, 0);
        this.initCountAttribute(typedArray);
        this.initColorAttribute(typedArray);
        this.initAnimationAttribute(typedArray);
        this.initSizeAttribute(typedArray);
    }

    private void initCountAttribute(@NonNull TypedArray typedArray) {
        int position;
        this.autoVisibility = typedArray.getBoolean(R.styleable.PageIndicatorView_piv_autoVisibility, true);
        this.dynamicCount = typedArray.getBoolean(R.styleable.PageIndicatorView_piv_dynamicCount, false);
        this.count = typedArray.getInt(R.styleable.PageIndicatorView_piv_count, -1);
        if (!this.isCountSet && this.count == -1) {
            this.isCountSet = true;
            this.count = 3;
        }
        if ((position = typedArray.getInt(R.styleable.PageIndicatorView_piv_select, 0)) < 0) {
            position = 0;
        } else if (this.count > 0 && position > this.count - 1) {
            position = this.count - 1;
        }
        this.selectedPosition = position;
        this.selectingPosition = position;
        this.viewPagerId = typedArray.getResourceId(R.styleable.PageIndicatorView_piv_viewPager, 0);
    }

    private void initColorAttribute(@NonNull TypedArray typedArray) {
        this.unselectedColor = typedArray.getColor(R.styleable.PageIndicatorView_piv_unselectedColor, Color.parseColor((String)"#33ffffff"));
        this.selectedColor = typedArray.getColor(R.styleable.PageIndicatorView_piv_selectedColor, Color.parseColor((String)"#ffffff"));
    }

    private void initAnimationAttribute(@NonNull TypedArray typedArray) {
        this.animationDuration = typedArray.getInt(R.styleable.PageIndicatorView_piv_animationDuration, 350);
        this.interactiveAnimation = typedArray.getBoolean(R.styleable.PageIndicatorView_piv_interactiveAnimation, false);
        int animIndex = typedArray.getInt(R.styleable.PageIndicatorView_piv_animationType, AnimationType.NONE.ordinal());
        this.animationType = this.getAnimationType(animIndex);
        int rtlIndex = typedArray.getInt(R.styleable.PageIndicatorView_piv_rtl_mode, RtlMode.Off.ordinal());
        this.rtlMode = this.getRtlMode(rtlIndex);
    }

    private void initSizeAttribute(@NonNull TypedArray typedArray) {
        int orientationIndex = typedArray.getInt(R.styleable.PageIndicatorView_piv_orientation, Orientation.HORIZONTAL.ordinal());
        this.orientation = orientationIndex == 0 ? Orientation.HORIZONTAL : Orientation.VERTICAL;
        this.radiusPx = (int)typedArray.getDimension(R.styleable.PageIndicatorView_piv_radius, (float)DensityUtils.dpToPx(6));
        this.paddingPx = (int)typedArray.getDimension(R.styleable.PageIndicatorView_piv_padding, (float)DensityUtils.dpToPx(8));
        this.scaleFactor = typedArray.getFloat(R.styleable.PageIndicatorView_piv_scaleFactor, 0.7f);
        if (this.scaleFactor < 0.3f) {
            this.scaleFactor = 0.3f;
        } else if (this.scaleFactor > 1.0f) {
            this.scaleFactor = 1.0f;
        }
        this.strokePx = (int)typedArray.getDimension(R.styleable.PageIndicatorView_piv_strokeWidth, (float)DensityUtils.dpToPx(1));
        if (this.strokePx > this.radiusPx) {
            this.strokePx = this.radiusPx;
        }
        if (this.animationType != AnimationType.FILL) {
            this.strokePx = 0;
        }
    }

    private void initAnimation() {
        this.animation = new ValueAnimation(new ValueAnimation.UpdateListener(){

            @Override
            public void onColorAnimationUpdated(int color, int colorReverse) {
                PageIndicatorView.this.frameColor = color;
                PageIndicatorView.this.frameColorReverse = colorReverse;
                PageIndicatorView.this.invalidate();
            }

            @Override
            public void onScaleAnimationUpdated(int color, int colorReverse, int radius, int radiusReverse) {
                PageIndicatorView.this.frameColor = color;
                PageIndicatorView.this.frameColorReverse = colorReverse;
                PageIndicatorView.this.frameRadiusPx = radius;
                PageIndicatorView.this.frameRadiusReversePx = radiusReverse;
                PageIndicatorView.this.invalidate();
            }

            @Override
            public void onSlideAnimationUpdated(int value) {
                PageIndicatorView.this.frameSlideFrom = value;
                PageIndicatorView.this.invalidate();
            }

            @Override
            public void onWormAnimationUpdated(int leftX, int rightX) {
                PageIndicatorView.this.frameFrom = leftX;
                PageIndicatorView.this.frameTo = rightX;
                PageIndicatorView.this.invalidate();
            }

            @Override
            public void onThinWormAnimationUpdated(int leftX, int rightX, int height) {
                PageIndicatorView.this.frameFrom = leftX;
                PageIndicatorView.this.frameTo = rightX;
                PageIndicatorView.this.frameHeight = height;
                PageIndicatorView.this.invalidate();
            }

            @Override
            public void onFillAnimationUpdated(int color, int colorReverse, int radius, int radiusReverse, int stroke, int strokeReverse) {
                PageIndicatorView.this.frameColor = color;
                PageIndicatorView.this.frameColorReverse = colorReverse;
                PageIndicatorView.this.frameRadiusPx = radius;
                PageIndicatorView.this.frameRadiusReversePx = radiusReverse;
                PageIndicatorView.this.frameStrokePx = stroke;
                PageIndicatorView.this.frameStrokeReversePx = strokeReverse;
                PageIndicatorView.this.invalidate();
            }

            @Override
            public void onDropAnimationUpdated(int x, int y, int selectedRadius) {
                PageIndicatorView.this.frameSlideFrom = PageIndicatorView.this.orientation == Orientation.HORIZONTAL ? x : y;
                PageIndicatorView.this.frameY = PageIndicatorView.this.orientation == Orientation.HORIZONTAL ? y : x;
                PageIndicatorView.this.frameRadiusPx = selectedRadius;
                PageIndicatorView.this.invalidate();
            }

            @Override
            public void onSwapAnimationUpdated(int xCoordinate) {
                PageIndicatorView.this.frameSlideFrom = xCoordinate;
                PageIndicatorView.this.invalidate();
            }
        });
    }

    private AnimationType getAnimationType(int index) {
        switch (index) {
            case 0: {
                return AnimationType.NONE;
            }
            case 1: {
                return AnimationType.COLOR;
            }
            case 2: {
                return AnimationType.SCALE;
            }
            case 3: {
                return AnimationType.WORM;
            }
            case 4: {
                return AnimationType.SLIDE;
            }
            case 5: {
                return AnimationType.FILL;
            }
            case 6: {
                return AnimationType.THIN_WORM;
            }
            case 7: {
                return AnimationType.DROP;
            }
            case 8: {
                return AnimationType.SWAP;
            }
            case 9: {
                return AnimationType.DRAG_WORM;
            }
        }
        return AnimationType.NONE;
    }

    private RtlMode getRtlMode(int index) {
        switch (index) {
            case 0: {
                return RtlMode.On;
            }
            case 1: {
                return RtlMode.Off;
            }
            case 2: {
                return RtlMode.Auto;
            }
        }
        return RtlMode.Auto;
    }

    private void resetFrameValues() {
        this.isFrameValuesSet = false;
        this.setupFrameValues();
    }

    private void setupFrameValues() {
        if (!this.isViewMeasured() || this.isFrameValuesSet) {
            return;
        }
        this.frameColor = this.selectedColor;
        this.frameColorReverse = this.unselectedColor;
        this.frameRadiusPx = this.radiusPx;
        this.frameRadiusReversePx = this.radiusPx;
        int xCoordinate = this.getXCoordinate(this.selectedPosition);
        if (xCoordinate - this.radiusPx >= 0) {
            this.frameFrom = xCoordinate - this.radiusPx;
            this.frameTo = xCoordinate + this.radiusPx;
        } else {
            this.frameFrom = xCoordinate;
            this.frameTo = xCoordinate + this.radiusPx * 2;
        }
        this.frameSlideFrom = xCoordinate;
        this.frameY = this.getYCoordinate(this.selectedPosition);
        this.frameStrokePx = this.radiusPx;
        this.frameStrokeReversePx = this.radiusPx / 2;
        if (this.animationType == AnimationType.FILL) {
            this.frameRadiusPx = this.radiusPx / 2;
            this.frameRadiusReversePx = this.radiusPx;
        }
        this.frameHeight = this.radiusPx * 2;
        this.isFrameValuesSet = true;
    }

    private void startColorAnimation() {
        this.animation.color().end();
        this.animation.color().with(this.unselectedColor, this.selectedColor).duration(this.animationDuration).start();
    }

    private void startScaleAnimation() {
        this.animation.scale().end();
        this.animation.scale().with(this.unselectedColor, this.selectedColor, this.radiusPx, this.scaleFactor).duration(this.animationDuration).start();
    }

    private void startSlideAnimation() {
        int fromX = this.getCoordinate(this.lastSelectedPosition);
        int toX = this.getCoordinate(this.selectedPosition);
        this.animation.slide().end();
        this.animation.slide().with(fromX, toX).duration(this.animationDuration).start();
    }

    private void startWormAnimation() {
        int from = this.getCoordinate(this.lastSelectedPosition);
        int to = this.getCoordinate(this.selectedPosition);
        boolean isRightSide = this.selectedPosition > this.lastSelectedPosition;
        this.animation.worm().end();
        this.animation.worm().duration(this.animationDuration).with(from, to, this.radiusPx, isRightSide).start();
    }

    private void startFillAnimation() {
        this.animation.fill().end();
        this.animation.fill().with(this.unselectedColor, this.selectedColor, this.radiusPx, this.strokePx).duration(this.animationDuration).start();
    }

    private void startThinWormAnimation() {
        int from = this.getCoordinate(this.lastSelectedPosition);
        int to = this.getCoordinate(this.selectedPosition);
        boolean isRightSide = this.selectedPosition > this.lastSelectedPosition;
        this.animation.thinWorm().end();
        this.animation.thinWorm().duration(this.animationDuration).with(from, to, this.radiusPx, isRightSide).start();
    }

    private void startDropAnimation() {
        int from = this.getCoordinate(this.lastSelectedPosition);
        int to = this.getCoordinate(this.selectedPosition);
        int center = this.orientation == Orientation.HORIZONTAL ? this.getYCoordinate(this.selectedPosition) : this.getXCoordinate(this.selectedPosition);
        this.animation.drop().end();
        this.animation.drop().duration(this.animationDuration).with(from, to, center, this.radiusPx).start();
    }

    private void startSwapAnimation() {
        int from = this.getCoordinate(this.lastSelectedPosition);
        int to = this.getCoordinate(this.selectedPosition);
        this.animation.swap().end();
        this.animation.swap().with(from, to).duration(this.animationDuration).start();
    }

    @Nullable
    private AbsAnimation setAnimationProgress(float progress) {
        switch (this.animationType) {
            case COLOR: {
                return this.animation.color().with(this.unselectedColor, this.selectedColor).progress(progress);
            }
            case SCALE: {
                return this.animation.scale().with(this.unselectedColor, this.selectedColor, this.radiusPx, this.scaleFactor).progress(progress);
            }
            case FILL: {
                return this.animation.fill().with(this.unselectedColor, this.selectedColor, this.radiusPx, this.strokePx).progress(progress);
            }
            case WORM: 
            case SLIDE: 
            case THIN_WORM: 
            case DROP: 
            case SWAP: 
            case DRAG_WORM: {
                int to;
                int from = this.orientation == Orientation.HORIZONTAL ? this.getXCoordinate(this.selectedPosition) : this.getYCoordinate(this.selectedPosition);
                int n = to = this.orientation == Orientation.HORIZONTAL ? this.getXCoordinate(this.selectingPosition) : this.getYCoordinate(this.selectingPosition);
                if (this.animationType == AnimationType.SLIDE) {
                    return this.animation.slide().with(from, to).progress(progress);
                }
                if (this.animationType == AnimationType.SWAP) {
                    return this.animation.swap().with(from, to).progress(progress);
                }
                if (this.animationType == AnimationType.WORM || this.animationType == AnimationType.THIN_WORM || this.animationType == AnimationType.DRAG_WORM) {
                    boolean isRightSide;
                    boolean bl = isRightSide = this.selectingPosition > this.selectedPosition;
                    if (this.animationType == AnimationType.WORM) {
                        return this.animation.worm().with(from, to, this.radiusPx, isRightSide).progress(progress);
                    }
                    if (this.animationType != AnimationType.THIN_WORM) break;
                    return this.animation.thinWorm().with(from, to, this.radiusPx, isRightSide).progress(progress);
                }
                int center = this.orientation == Orientation.HORIZONTAL ? this.getYCoordinate(this.selectedPosition) : this.getXCoordinate(this.selectedPosition);
                return this.animation.drop().with(from, to, center, this.radiusPx).progress(progress);
            }
        }
        return null;
    }

    private void registerSetObserver() {
        if (this.setObserver == null && this.viewPager != null && this.viewPager.getAdapter() != null) {
            this.setObserver = new DataSetObserver(){

                public void onChanged() {
                    if (PageIndicatorView.this.viewPager != null && PageIndicatorView.this.viewPager.getAdapter() != null) {
                        int newCount = PageIndicatorView.this.viewPager.getAdapter().getCount();
                        int currItem = PageIndicatorView.this.viewPager.getCurrentItem();
                        PageIndicatorView.this.selectedPosition = currItem;
                        PageIndicatorView.this.selectingPosition = currItem;
                        PageIndicatorView.this.lastSelectedPosition = currItem;
                        PageIndicatorView.this.endAnimation();
                        PageIndicatorView.this.setCount(newCount);
                        PageIndicatorView.this.setProgress(PageIndicatorView.this.selectingPosition, 1.0f);
                    }
                }
            };
            try {
                this.viewPager.getAdapter().registerDataSetObserver(this.setObserver);
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
        }
    }

    private void updateVisibility() {
        if (!this.autoVisibility) {
            return;
        }
        if (this.count > 1 && this.getVisibility() != 0) {
            this.setVisibility(0);
        } else if (this.count <= 1 && this.getVisibility() != 4) {
            this.setVisibility(4);
        }
    }

    private void endAnimation() {
        AbsAnimation anim = null;
        switch (this.animationType) {
            case COLOR: {
                anim = this.animation.color();
                break;
            }
            case SLIDE: {
                anim = this.animation.slide();
                break;
            }
            case SCALE: {
                anim = this.animation.scale();
                break;
            }
            case WORM: {
                anim = this.animation.worm();
                break;
            }
            case THIN_WORM: {
                anim = this.animation.thinWorm();
                break;
            }
            case FILL: {
                anim = this.animation.fill();
                break;
            }
            case DROP: {
                anim = this.animation.drop();
                break;
            }
            case SWAP: {
                anim = this.animation.swap();
            }
        }
        if (anim != null) {
            anim.end();
        }
    }

    private void unRegisterSetObserver() {
        if (this.setObserver != null && this.viewPager != null && this.viewPager.getAdapter() != null) {
            try {
                this.viewPager.getAdapter().unregisterDataSetObserver(this.setObserver);
                this.setObserver = null;
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
        }
    }

    private int getViewPagerCount() {
        if (this.viewPager != null && this.viewPager.getAdapter() != null) {
            return this.viewPager.getAdapter().getCount();
        }
        return this.count;
    }

    private void findViewPager() {
        Activity activity;
        View view;
        if (this.viewPagerId == 0) {
            return;
        }
        Context context = this.getContext();
        if (context instanceof Activity && (view = (activity = (Activity)this.getContext()).findViewById(this.viewPagerId)) != null && view instanceof ViewPager) {
            this.setViewPager((ViewPager)view);
        }
    }

    private int getXCoordinate(int position) {
        if (this.orientation == Orientation.HORIZONTAL) {
            int x = 0;
            for (int i = 0; i < this.count; ++i) {
                x += this.radiusPx + this.strokePx;
                if (position == i) {
                    return x;
                }
                x += this.radiusPx + this.paddingPx;
            }
            return x;
        }
        int x = this.getWidth() / 2;
        if (this.animationType == AnimationType.DROP) {
            x += this.radiusPx + this.strokePx;
        }
        return x;
    }

    private int getYCoordinate(int position) {
        if (this.orientation == Orientation.HORIZONTAL) {
            int y = this.getHeight() / 2;
            if (this.animationType == AnimationType.DROP) {
                y += this.radiusPx;
            }
            return y;
        }
        int y = 0;
        for (int i = 0; i < this.count; ++i) {
            y += this.radiusPx + this.strokePx;
            if (position == i) {
                return y;
            }
            y += this.radiusPx + this.paddingPx;
        }
        return y;
    }

    private int getCoordinate(int position) {
        return this.orientation == Orientation.HORIZONTAL ? this.getXCoordinate(position) : this.getYCoordinate(position);
    }

    private Pair<Integer, Float> getProgress(int position, float positionOffset) {
        float selectingProgress;
        int selectingPosition;
        boolean isSlideToRightSide;
        boolean isLeftOverScrolled;
        boolean isRightOverScrolled;
        if (this.isRtl() && (position = this.count - 1 - position) < 0) {
            position = 0;
        }
        boolean bl = isRightOverScrolled = position > this.selectedPosition;
        if (this.isRtl()) {
            isLeftOverScrolled = position - 1 < this.selectedPosition;
        } else {
            boolean bl2 = isLeftOverScrolled = position + 1 < this.selectedPosition;
        }
        if (isRightOverScrolled || isLeftOverScrolled) {
            this.selectedPosition = position;
        }
        boolean bl3 = isSlideToRightSide = this.selectedPosition == position && positionOffset != 0.0f;
        if (isSlideToRightSide) {
            selectingPosition = this.isRtl() ? position - 1 : position + 1;
            selectingProgress = positionOffset;
        } else {
            selectingPosition = position;
            selectingProgress = 1.0f - positionOffset;
        }
        if (selectingProgress > 1.0f) {
            selectingProgress = 1.0f;
        } else if (selectingProgress < 0.0f) {
            selectingProgress = 0.0f;
        }
        return new Pair((Object)selectingPosition, (Object)Float.valueOf(selectingProgress));
    }

    private boolean isRtl() {
        switch (this.rtlMode) {
            case On: {
                return true;
            }
            case Off: {
                return false;
            }
            case Auto: {
                return TextUtilsCompat.getLayoutDirectionFromLocale((Locale)this.getContext().getResources().getConfiguration().locale) == 1;
            }
        }
        return false;
    }
}

