/*
 * Decompiled with CFR 0.152.
 */
package com.rd.animation;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.support.annotation.NonNull;
import android.view.animation.AccelerateDecelerateInterpolator;
import com.rd.animation.AbsAnimation;
import com.rd.animation.ValueAnimation;

public class WormAnimation
extends AbsAnimation<AnimatorSet> {
    int fromValue;
    int toValue;
    int radius;
    boolean isRightSide;
    int rectLeftX;
    int rectRightX;

    public WormAnimation(@NonNull ValueAnimation.UpdateListener listener) {
        super(listener);
    }

    @Override
    @NonNull
    public AnimatorSet createAnimator() {
        AnimatorSet animator = new AnimatorSet();
        animator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        return animator;
    }

    @Override
    public WormAnimation duration(long duration) {
        super.duration(duration);
        return this;
    }

    public WormAnimation with(int fromValue, int toValue, int radius, boolean isRightSide) {
        if (this.hasChanges(fromValue, toValue, radius, isRightSide)) {
            this.animator = this.createAnimator();
            this.fromValue = fromValue;
            this.toValue = toValue;
            this.radius = radius;
            this.isRightSide = isRightSide;
            this.rectLeftX = fromValue - radius;
            this.rectRightX = fromValue + radius;
            AnimationValues values = this.createAnimationValues(isRightSide);
            long duration = this.animationDuration / 2L;
            ValueAnimator straightAnimator = this.createWormAnimator(values.fromX, values.toX, duration, false);
            ValueAnimator reverseAnimator = this.createWormAnimator(values.reverseFromX, values.reverseToX, duration, true);
            ((AnimatorSet)this.animator).playSequentially(new Animator[]{straightAnimator, reverseAnimator});
        }
        return this;
    }

    @Override
    public WormAnimation progress(float progress) {
        if (this.animator != null) {
            long playTimeLeft = (long)(progress * (float)this.animationDuration);
            for (Animator anim : ((AnimatorSet)this.animator).getChildAnimations()) {
                long currPlayTime;
                ValueAnimator animator = (ValueAnimator)anim;
                long animDuration = animator.getDuration();
                if (playTimeLeft < 0L) {
                    playTimeLeft = 0L;
                }
                if ((currPlayTime = playTimeLeft) >= animDuration) {
                    currPlayTime = animDuration;
                }
                if (animator.getValues() != null && animator.getValues().length > 0) {
                    animator.setCurrentPlayTime(currPlayTime);
                }
                playTimeLeft -= currPlayTime;
            }
        }
        return this;
    }

    ValueAnimator createWormAnimator(int fromX, int toX, long duration, final boolean isReverse) {
        ValueAnimator anim = ValueAnimator.ofInt((int[])new int[]{fromX, toX});
        anim.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        anim.setDuration(duration);
        anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int value = (Integer)animation.getAnimatedValue();
                if (!isReverse) {
                    if (WormAnimation.this.isRightSide) {
                        WormAnimation.this.rectRightX = value;
                    } else {
                        WormAnimation.this.rectLeftX = value;
                    }
                } else if (WormAnimation.this.isRightSide) {
                    WormAnimation.this.rectLeftX = value;
                } else {
                    WormAnimation.this.rectRightX = value;
                }
                WormAnimation.this.listener.onWormAnimationUpdated(WormAnimation.this.rectLeftX, WormAnimation.this.rectRightX);
            }
        });
        return anim;
    }

    boolean hasChanges(int fromValue, int toValue, int radius, boolean isRightSide) {
        if (this.fromValue != fromValue) {
            return true;
        }
        if (this.toValue != toValue) {
            return true;
        }
        if (this.radius != radius) {
            return true;
        }
        return this.isRightSide != isRightSide;
    }

    @NonNull
    AnimationValues createAnimationValues(boolean isRightSide) {
        int reverseToX;
        int reverseFromX;
        int toX;
        int fromX;
        if (isRightSide) {
            fromX = this.fromValue + this.radius;
            toX = this.toValue + this.radius;
            reverseFromX = this.fromValue - this.radius;
            reverseToX = this.toValue - this.radius;
        } else {
            fromX = this.fromValue - this.radius;
            toX = this.toValue - this.radius;
            reverseFromX = this.fromValue + this.radius;
            reverseToX = this.toValue + this.radius;
        }
        return new AnimationValues(fromX, toX, reverseFromX, reverseToX);
    }

    class AnimationValues {
        final int fromX;
        final int toX;
        final int reverseFromX;
        final int reverseToX;

        AnimationValues(int fromX, int toX, int reverseFromX, int reverseToX) {
            this.fromX = fromX;
            this.toX = toX;
            this.reverseFromX = reverseFromX;
            this.reverseToX = reverseToX;
        }
    }
}

