/*
 * Decompiled with CFR 0.152.
 */
package com.rd.animation;

import android.animation.IntEvaluator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.support.annotation.NonNull;
import android.view.animation.DecelerateInterpolator;
import com.rd.animation.ColorAnimation;
import com.rd.animation.ValueAnimation;

public class ScaleAnimation
extends ColorAnimation {
    public static final float DEFAULT_SCALE_FACTOR = 0.7f;
    public static final float MIN_SCALE_FACTOR = 0.3f;
    public static final float MAX_SCALE_FACTOR = 1.0f;
    private static final String ANIMATION_COLOR_REVERSE = "ANIMATION_COLOR_REVERSE";
    private static final String ANIMATION_COLOR = "ANIMATION_COLOR";
    private static final String ANIMATION_SCALE_REVERSE = "ANIMATION_SCALE_REVERSE";
    private static final String ANIMATION_SCALE = "ANIMATION_SCALE";
    private int radiusPx;
    private float scaleFactor;

    public ScaleAnimation(@NonNull ValueAnimation.UpdateListener listener) {
        super(listener);
    }

    @Override
    @NonNull
    public ValueAnimator createAnimator() {
        ValueAnimator animator = new ValueAnimator();
        animator.setDuration(350L);
        animator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ScaleAnimation.this.onAnimateUpdated(animation);
            }
        });
        return animator;
    }

    @NonNull
    public ScaleAnimation with(int colorStartValue, int colorEndValue, int radiusValue, float scaleFactorValue) {
        if (this.animator != null && this.hasChanges(colorStartValue, colorEndValue, radiusValue, scaleFactorValue)) {
            this.startColor = colorStartValue;
            this.endColor = colorEndValue;
            this.radiusPx = radiusValue;
            this.scaleFactor = scaleFactorValue;
            PropertyValuesHolder colorHolder = this.createColorPropertyHolder(false);
            PropertyValuesHolder reverseColorHolder = this.createColorPropertyHolder(true);
            PropertyValuesHolder scaleHolder = this.createScalePropertyHolder(false);
            PropertyValuesHolder scaleReverseHolder = this.createScalePropertyHolder(true);
            ((ValueAnimator)this.animator).setValues(new PropertyValuesHolder[]{colorHolder, reverseColorHolder, scaleHolder, scaleReverseHolder});
        }
        return this;
    }

    private void onAnimateUpdated(@NonNull ValueAnimator animation) {
        int color = (Integer)animation.getAnimatedValue(ANIMATION_COLOR);
        int colorReverse = (Integer)animation.getAnimatedValue(ANIMATION_COLOR_REVERSE);
        int radius = (Integer)animation.getAnimatedValue(ANIMATION_SCALE);
        int radiusReverse = (Integer)animation.getAnimatedValue(ANIMATION_SCALE_REVERSE);
        if (this.listener != null) {
            this.listener.onScaleAnimationUpdated(color, colorReverse, radius, radiusReverse);
        }
    }

    @NonNull
    private PropertyValuesHolder createScalePropertyHolder(boolean isReverse) {
        int endRadiusValue;
        int startRadiusValue;
        String propertyName;
        if (isReverse) {
            propertyName = ANIMATION_SCALE_REVERSE;
            startRadiusValue = this.radiusPx;
            endRadiusValue = (int)((float)this.radiusPx * this.scaleFactor);
        } else {
            propertyName = ANIMATION_SCALE;
            startRadiusValue = (int)((float)this.radiusPx * this.scaleFactor);
            endRadiusValue = this.radiusPx;
        }
        PropertyValuesHolder holder = PropertyValuesHolder.ofInt((String)propertyName, (int[])new int[]{startRadiusValue, endRadiusValue});
        holder.setEvaluator((TypeEvaluator)new IntEvaluator());
        return holder;
    }

    private boolean hasChanges(int colorStartValue, int colorEndValue, int radiusValue, float scaleFactorValue) {
        if (this.startColor != colorStartValue) {
            return true;
        }
        if (this.endColor != colorEndValue) {
            return true;
        }
        if (this.radiusPx != radiusValue) {
            return true;
        }
        return this.scaleFactor != scaleFactorValue;
    }
}

