/*
 * Decompiled with CFR 0.152.
 */
package com.rd.animation;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.support.annotation.NonNull;
import android.view.animation.AccelerateDecelerateInterpolator;
import com.rd.animation.AbsAnimation;
import com.rd.animation.ValueAnimation;

public class DropAnimation
extends AbsAnimation<AnimatorSet> {
    private int xFromValue;
    private int xToValue;
    private int center;
    private int radius;
    private int frameX;
    private int frameY;
    private int frameRadius;

    public DropAnimation(@NonNull ValueAnimation.UpdateListener listener) {
        super(listener);
    }

    @Override
    @NonNull
    public AnimatorSet createAnimator() {
        AnimatorSet animator = new AnimatorSet();
        animator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        return animator;
    }

    @Override
    public DropAnimation progress(float progress) {
        if (this.animator != null) {
            long playTimeLeft = (long)(progress * (float)this.animationDuration);
            boolean isReverse = false;
            for (Animator anim : ((AnimatorSet)this.animator).getChildAnimations()) {
                ValueAnimator animator = (ValueAnimator)anim;
                long animDuration = animator.getDuration();
                long currPlayTime = playTimeLeft;
                if (isReverse) {
                    currPlayTime -= animDuration;
                }
                if (currPlayTime < 0L) continue;
                if (currPlayTime >= animDuration) {
                    currPlayTime = animDuration;
                }
                if (animator.getValues() != null && animator.getValues().length > 0) {
                    animator.setCurrentPlayTime(currPlayTime);
                }
                if (isReverse || animDuration < this.animationDuration) continue;
                isReverse = true;
            }
        }
        return this;
    }

    @Override
    public DropAnimation duration(long duration) {
        super.duration(duration);
        return this;
    }

    public DropAnimation with(int xFromValue, int xToValue, int center, int radius) {
        if (this.hasChanges(xFromValue, xToValue, center, radius)) {
            this.animator = this.createAnimator();
            this.xFromValue = xFromValue;
            this.xToValue = xToValue;
            this.center = center;
            this.radius = radius;
            int yFromValue = center;
            int yToValue = center / 3;
            int fromSelectedRadius = radius;
            int toSelectedRadius = (int)((double)radius / 1.5);
            long halfDuration = this.animationDuration / 2L;
            this.frameX = xFromValue;
            this.frameY = yFromValue;
            this.frameRadius = radius;
            ValueAnimator widthAnimator = this.createValueAnimation(xFromValue, xToValue, this.animationDuration, AnimationType.Width);
            ValueAnimator heightForwardAnimator = this.createValueAnimation(yFromValue, yToValue, halfDuration, AnimationType.Height);
            ValueAnimator heightBackwardAnimator = this.createValueAnimation(yToValue, yFromValue, halfDuration, AnimationType.Height);
            ValueAnimator radiusForwardAnimator = this.createValueAnimation(fromSelectedRadius, toSelectedRadius, halfDuration, AnimationType.Radius);
            ValueAnimator radiusBackwardAnimator = this.createValueAnimation(toSelectedRadius, fromSelectedRadius, halfDuration, AnimationType.Radius);
            ((AnimatorSet)this.animator).play((Animator)heightForwardAnimator).with((Animator)radiusForwardAnimator).with((Animator)widthAnimator).before((Animator)heightBackwardAnimator).before((Animator)radiusBackwardAnimator);
        }
        return this;
    }

    private ValueAnimator createValueAnimation(int fromValue, int toValue, long duration, final AnimationType type) {
        ValueAnimator anim = ValueAnimator.ofInt((int[])new int[]{fromValue, toValue});
        anim.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        anim.setDuration(duration);
        anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int value = (Integer)animation.getAnimatedValue();
                DropAnimation.this.onAnimatorUpdate(value, type);
            }
        });
        return anim;
    }

    private void onAnimatorUpdate(int value, AnimationType type) {
        switch (type) {
            case Width: {
                this.frameX = value;
                break;
            }
            case Height: {
                this.frameY = value;
                break;
            }
            case Radius: {
                this.frameRadius = value;
            }
        }
        if (this.listener != null) {
            this.listener.onDropAnimationUpdated(this.frameX, this.frameY, this.frameRadius);
        }
    }

    private boolean hasChanges(int fromValue, int toValue, int center, int radius) {
        if (this.xFromValue != fromValue) {
            return true;
        }
        if (this.xToValue != toValue) {
            return true;
        }
        if (this.center != center) {
            return true;
        }
        return this.radius != radius;
    }

    public static enum AnimationType {
        Width,
        Height,
        Radius;

    }
}

