/*
 * Decompiled with CFR 0.152.
 */
package com.rd.animation;

import android.animation.IntEvaluator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.support.annotation.NonNull;
import android.view.animation.DecelerateInterpolator;
import com.rd.animation.ColorAnimation;
import com.rd.animation.ValueAnimation;

public class FillAnimation
extends ColorAnimation {
    private static final String ANIMATION_COLOR_REVERSE = "ANIMATION_COLOR_REVERSE";
    private static final String ANIMATION_COLOR = "ANIMATION_COLOR";
    private static final String ANIMATION_RADIUS_REVERSE = "ANIMATION_RADIUS_REVERSE";
    private static final String ANIMATION_RADIUS = "ANIMATION_RADIUS";
    private static final String ANIMATION_STROKE_REVERSE = "ANIMATION_STROKE_REVERSE";
    private static final String ANIMATION_STROKE = "ANIMATION_STROKE";
    private static final int ANIMATION_DURATION = 350;
    private int radiusPx;
    private int strokePx;

    public FillAnimation(@NonNull ValueAnimation.UpdateListener listener) {
        super(listener);
    }

    @Override
    @NonNull
    public ValueAnimator createAnimator() {
        ValueAnimator animator = new ValueAnimator();
        animator.setDuration(350L);
        animator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                FillAnimation.this.onAnimateUpdated(animation);
            }
        });
        return animator;
    }

    @NonNull
    public FillAnimation with(int colorStartValue, int colorEndValue, int radiusValue, int strokeValue) {
        if (this.animator != null && this.hasChanges(colorStartValue, colorEndValue, radiusValue, strokeValue)) {
            this.startColor = colorStartValue;
            this.endColor = colorEndValue;
            this.radiusPx = radiusValue;
            this.strokePx = strokeValue;
            PropertyValuesHolder colorHolder = this.createColorPropertyHolder(false);
            PropertyValuesHolder reverseColorHolder = this.createColorPropertyHolder(true);
            PropertyValuesHolder radiusHolder = this.createRadiusPropertyHolder(false);
            PropertyValuesHolder radiusReverseHolder = this.createRadiusPropertyHolder(true);
            PropertyValuesHolder strokeHolder = this.createStrokePropertyHolder(false);
            PropertyValuesHolder strokeReverseHolder = this.createStrokePropertyHolder(true);
            ((ValueAnimator)this.animator).setValues(new PropertyValuesHolder[]{colorHolder, reverseColorHolder, radiusHolder, radiusReverseHolder, strokeHolder, strokeReverseHolder});
        }
        return this;
    }

    @NonNull
    private PropertyValuesHolder createRadiusPropertyHolder(boolean isReverse) {
        int endRadiusValue;
        int startRadiusValue;
        String propertyName;
        if (isReverse) {
            propertyName = ANIMATION_RADIUS_REVERSE;
            startRadiusValue = this.radiusPx / 2;
            endRadiusValue = this.radiusPx;
        } else {
            propertyName = ANIMATION_RADIUS;
            startRadiusValue = this.radiusPx;
            endRadiusValue = this.radiusPx / 2;
        }
        PropertyValuesHolder holder = PropertyValuesHolder.ofInt((String)propertyName, (int[])new int[]{startRadiusValue, endRadiusValue});
        holder.setEvaluator((TypeEvaluator)new IntEvaluator());
        return holder;
    }

    @NonNull
    private PropertyValuesHolder createStrokePropertyHolder(boolean isReverse) {
        int endStrokeValue;
        int startStrokeValue;
        String propertyName;
        if (isReverse) {
            propertyName = ANIMATION_STROKE_REVERSE;
            startStrokeValue = this.radiusPx;
            endStrokeValue = 0;
        } else {
            propertyName = ANIMATION_STROKE;
            startStrokeValue = 0;
            endStrokeValue = this.radiusPx;
        }
        PropertyValuesHolder holder = PropertyValuesHolder.ofInt((String)propertyName, (int[])new int[]{startStrokeValue, endStrokeValue});
        holder.setEvaluator((TypeEvaluator)new IntEvaluator());
        return holder;
    }

    private void onAnimateUpdated(@NonNull ValueAnimator animation) {
        int color = (Integer)animation.getAnimatedValue(ANIMATION_COLOR);
        int colorReverse = (Integer)animation.getAnimatedValue(ANIMATION_COLOR_REVERSE);
        int radius = (Integer)animation.getAnimatedValue(ANIMATION_RADIUS);
        int radiusReverse = (Integer)animation.getAnimatedValue(ANIMATION_RADIUS_REVERSE);
        int stroke = (Integer)animation.getAnimatedValue(ANIMATION_STROKE);
        int strokeReverse = (Integer)animation.getAnimatedValue(ANIMATION_STROKE_REVERSE);
        if (this.listener != null) {
            this.listener.onFillAnimationUpdated(color, colorReverse, radius, radiusReverse, stroke, strokeReverse);
        }
    }

    private boolean hasChanges(int colorStartValue, int colorEndValue, int radiusValue, int strokeValue) {
        if (this.startColor != colorStartValue) {
            return true;
        }
        if (this.endColor != colorEndValue) {
            return true;
        }
        if (this.radiusPx != radiusValue) {
            return true;
        }
        return this.strokePx != strokeValue;
    }
}

